/*
 * MiningMart Version 1.1
 * 
 * Copyright (C) 2006 Martin Scholz, Timm Euler, 
 *                    Daniel Hakenjos, Katharina Morik
 *
 * Contact: miningmart@ls8.cs.uni-dortmund.de
 *
 * A list of contributing developers (other than the copyright 
 * holders) can be found at
 * http://mmart.cs.uni-dortmund.de/downloads/download.html
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program, see the file MM_HOME/LICENSE; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 */
package edu.udo.cs.miningmart.compiler.wrapper;

import java.io.IOException;

import edu.udo.cs.miningmart.db.CompilerDatabaseService;
import edu.udo.cs.miningmart.m4.utils.Print;

import edu.udo.cs.miningmart.exception.M4CompilerError;


/**
 * This class inherits all methods from its super class. Use it to handle a
 * Support Vector Machine for regression.
 *
 * @see edu.udo.cs.miningmart.m4.core.operator.SupportVectorMachine
 * @see edu.udo.cs.miningmart.m4.core.operator.SVM_CL
 * 
 * @author Timm Euler
 * @version $Id: SVM_RG.java,v 1.4 2006/09/27 15:00:03 euler Exp $
 */
public class SVM_RG extends SupportVectorMachine
{
	/**
     * Constructor. The connections to the databases are needed because the
     * SVM needs to read metadata as well as data and create an
     * intermediate table in the database.
     *
     * @param databaseObj the DB object to be used for database connections
     * @param printObj the Print object to be used for log messages
     * @param databasePrefix Prefix for all functions, view and tables that
     * 	      this wrapper creates in the database
     * @param nameOfDatabaseSchema Name of the database schema that holds the business 
     *        views and tables
     * @param stepId Id of the step
     * @param sampleSize the maximum number of examples to be used for training;
     * 		  they are selected randomly from the database
     * @param lossFunctionPos The positive loss function value for the support
     *        vector machine
     * @param lossFunctionNeg The negative loss function value for the support
     *        vector machine
     *
     * @throws M4CompilerError A simple exception object with an error message.
     */
    public SVM_RG( CompilerDatabaseService databaseObj, 
    			   Print printObj, 
    			   String databasePrefix, 
    			   String nameOfDatabaseSchema,
    			   long stepId,
    			   long sampleSize,
    			   String lossFunctionPos,
    			   String lossFunctionNeg)
    	throws IOException, Exception
    {
        super(databaseObj, printObj, databasePrefix, nameOfDatabaseSchema, stepId, sampleSize);
        this.forClassification = false;      
        this.lossNeg = lossFunctionNeg;
        this.lossPos = lossFunctionPos;
    }
    
	/**
	 * No XiAlpha estimation is possible for regression. So this method throws an exception.
	 * 
	 * @see edu.udo.cs.miningmart.m4.core.operator.SVM_Wrapper#extractXiAlpha
	 */
    protected void extractXiAlpha() throws M4CompilerError
    {
    	throw new M4CompilerError("Attempt to call method 'extractXiAlpha' in class SVM_RG.java. Not supported (no estimation possible for regression).");
    }   
}
/*
 * Historie
 * --------
 * 
 * $Log: SVM_RG.java,v $
 * Revision 1.4  2006/09/27 15:00:03  euler
 * New version 1.1
 *
 * Revision 1.3  2006/04/11 14:10:18  euler
 * Updated license text.
 *
 * Revision 1.2  2006/04/06 16:31:17  euler
 * Prepended license remark.
 *
 * Revision 1.1  2006/01/03 09:54:36  hakenjos
 * Initial version!
 *
 */
