---------------------- M4 Operators --------------------------

INSERT INTO operator_t VALUES (34, 'MultiRelationalFeatureConstruction', 'NO', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  500,   34,    1,      1,    'TheInputConcept',    'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  501,   34,    1,   NULL,    'TheConcepts',        'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  502,   34,    1,   NULL,    'TheRelations',       'IN', 'REL', NULL);
INSERT INTO op_params_t VALUES (
  503,   34,    1,   NULL,    'TheChainedFeatures', 'IN', 'FEA', NULL);
INSERT INTO op_params_t VALUES (
  504,   34,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO op_constr_t VALUES (
  505, 34, 'COMP',     'TheInputConcept',  'TheRelations',     NULL, NULL);
INSERT INTO op_constr_t VALUES (
  506, 34, 'COMP',        'TheRelations',   'TheConcepts',     NULL, NULL);
INSERT INTO op_constr_t VALUES (
  507, 34,   'IN',  'TheChainedFeatures',  'TheOutputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  508, 34,   'IN',  'TheChainedFeatures',  'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  509, 34,   'IN',  'TheChainedFeatures',  'TheConcepts',      NULL, NULL);

-- no conditions

INSERT INTO op_assert_t VALUES (
  510, 34, 'PROJ', 'TheInputConcept', 'TheOutputConcept', NULL, NULL); 
-- input is proj of output
INSERT INTO op_assert_t VALUES (
  511, 34, 'PROJ', 'TheConcepts',     'TheOutputConcept', NULL, NULL); 
-- theConcepts are proj of output

-- assertions for estimation of statistics:
INSERT INTO op_assert_t VALUES (
  512, 34, 'SZ_BY_REL', 'TheRelations', NULL, NULL, NULL);
INSERT INTO op_assert_t VALUES (
  513, 34, 'MM_FROM',   'TheChainedFeatures', NULL, NULL, NULL);
INSERT INTO op_assert_t VALUES (
  514, 34, 'VL_FROM',   'TheChainedFeatures', NULL, NULL, NULL);


-------------------------------------------------------
INSERT INTO operator_t VALUES (37, 'RowSelectionByRandomSampling', 'NO', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  515,   37,    1,      1,     'TheInputConcept',   'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  516,   37,    1,      1,             'HowMany',   'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  517,   37,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO op_constr_t VALUES (
  518, 37, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  519, 37,      'TYPE',          'HowMany',         'NUMERIC',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  520, 37,        'GE',          'HowMany',                 1,  NULL, NULL);

-- no conditions

INSERT INTO op_assert_t VALUES (
  521, 37, 'SUBSET', 'TheOutputConcept', 'TheInputConcept', NULL, NULL); 
-- output is subset of input

-- assertions for estimation of statistics:
INSERT INTO op_assert_t VALUES (
  522, 37, 'SZ_BY_VAL',  'HowMany', NULL, NULL, NULL);
INSERT INTO op_assert_t VALUES (
  523, 37, 'MM_UNCH', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  524, 37, 'VL_UNCH', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  525, 37, 'MV_BY_SEL', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  526, 37, 'VF_BY_SEL', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);
  
-------------------------------------------------------
INSERT INTO operator_t VALUES (38, 'DeleteRecordsWithMissingValues', 'NO', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  527,   38,    1,      1,     'TheInputConcept',   'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  528,   38,    1,      1,  'TheTargetAttribute',   'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  529,   38,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO op_constr_t VALUES (
  530, 38, 'SAME_FEAT',   'TheOutputConcept',  'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  531, 38, 'IN',        'TheTargetAttribute',  'TheInputConcept',  NULL, NULL);

-- no conditions

INSERT INTO op_assert_t VALUES (
  532, 38, 'SUBSET', 'TheOutputConcept', 'TheInputConcept', NULL, NULL); 
-- output is subset of input

-- assertions for estimation of statistics:
INSERT INTO op_assert_t VALUES (
  533, 38, 'SZ_MIN_MV',  'TheTargetAttribute', NULL, NULL, NULL);
INSERT INTO op_assert_t VALUES (
  534, 38, 'NOT_NULL',    'TheTargetAttribute', NULL, NULL, NULL);
INSERT INTO op_assert_t VALUES (
  535, 38, 'MM_UNCH', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  536, 38, 'VL_UNCH', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  537, 38, 'MV_BY_SEL', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  538, 38, 'VF_BY_SEL', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);
  
-------------------------------------------------------
INSERT INTO operator_t VALUES (39, 'RowSelectionByQuery', 'YES', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  539,   39,    1,      1,    'TheInputConcept',    'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  540,   39,    1,      1,   'TheLeftCondition',    'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  541,   39,    1,      1,'TheConditionOperator',   'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  542,   39,    1,      1,   'TheRightCondition',   'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  543,   39,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO op_constr_t VALUES (
  544, 39, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  545, 39,        'IN', 'TheLeftCondition', 'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  546, 39, 'IS_LOOPED', 'TheLeftCondition',              NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  547, 39, 'IS_LOOPED', 'TheConditionOperator',          NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  548, 39, 'IS_LOOPED', 'TheRightCondition',             NULL,  NULL, NULL);

-- no conditions

INSERT INTO op_assert_t VALUES (
  549, 39, 'SUBSET', 'TheOutputConcept', 'TheInputConcept', NULL, NULL); 
-- output is subset of input

INSERT INTO op_assert_t VALUES (
  550, 39, 'ES_SELECT', 'TheInputConcept', 'TheLeftCondition', NULL, NULL); 

-------------------------------------------------------
INSERT INTO operator_t VALUES (40, 'SegmentationStratified', 'NO', 'YES','YES', NULL);

INSERT INTO op_params_t VALUES (
  551,   40,    1,      1,     'TheInputConcept',   'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  552,   40,    1,      1,        'TheAttribute',   'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  553,   40,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);

-- 'TheAttribute' is missing in the OutputConcept:
INSERT INTO op_constr_t VALUES (
  554, 40,        'IN',     'TheAttribute',  'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  555, 40, 'ALL_EXCEPT',    'TheAttribute',  'TheOutputConcept',  NULL, NULL);

-- no conditions

INSERT INTO op_assert_t VALUES (
  556, 40, 'PROJ', 'TheOutputConcept', 'TheInputConcept', NULL, NULL); 
-- output is proj of input

-- assertions for estimation of statistics:
INSERT INTO op_assert_t VALUES (
  557, 40, 'SZ_DIV_BY', 'TheAttribute',    NULL, NULL, NULL);
INSERT INTO op_assert_t VALUES (
  558, 40, 'MM_UNCH',   'TheInputConcept', 'TheOutputConcept', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  559, 40, 'VL_UNCH',   'TheInputConcept', 'TheOutputConcept', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  560, 40, 'VF_BY_SEL', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);
   
-------------------------------------------------------
INSERT INTO operator_t VALUES (42, 'SegmentationByPartitioning', 'NO', 'YES','YES', NULL);

INSERT INTO op_params_t VALUES (
  561,   42,    1,      1,     'TheInputConcept',   'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  562,   42,    1,      1,   'HowManyPartitions',   'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  563,   42,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO op_constr_t VALUES (
  564, 42, 'SAME_FEAT',  'TheOutputConcept',  'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  565, 42,        'GE', 'HowManyPartitions',                  1,  NULL, NULL);

-- no conditions

INSERT INTO op_assert_t VALUES (
  566, 42, 'SUBSET', 'TheOutputConcept', 'TheInputConcept', NULL, NULL);

-- assertions for estimation of statistics:
INSERT INTO op_assert_t VALUES (
  567, 42, 'SZ_DIV_BY', 'HowManyPartitions', NULL, NULL, NULL);
INSERT INTO op_assert_t VALUES (
  568, 42, 'MM_UNCH',   'TheInputConcept', 'TheOutputConcept', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  569, 42, 'VL_UNCH',   'TheInputConcept', 'TheOutputConcept', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  570, 42, 'VF_BY_SEL', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);
  
-------------------------------------------------------
INSERT INTO operator_t VALUES (43, 'FeatureSelectionByAttributes', 'NO', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  571, 43, 1,    1,       'TheInputConcept',     'IN',  'CON', NULL);
INSERT INTO op_params_t VALUES (
  572, 43, 1,    1,       'TheOutputConcept',    'OUT', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  573, 43, 1, NULL,       'TheSelectedFeatures', 'OUT', 'FEA', NULL);

INSERT INTO op_constr_t VALUES (
  574, 43, 'IN',         'TheOutputConcept',    'TheInputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  575, 43, 'IN',         'TheSelectedFeatures', 'TheInputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  576, 43, 'IN',         'TheSelectedFeatures', 'TheOutputConcept', NULL, NULL);

-- no conditions

INSERT INTO op_assert_t VALUES (
  577, 43, 'PROJ', 'TheOutputConcept', 'TheInputConcept', NULL, NULL); 
-- output is proj of input

-- assertions for estimation of statistics:
INSERT INTO op_assert_t VALUES (
  578, 43, 'NO_CHANGE', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);
  
-------------------------------------------------------
INSERT INTO operator_t VALUES (44, 'LinearScaling', 'YES', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  579, 44, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  580, 44, 1,    1,       'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  581, 44, 1,    1,              'NewRangeMin',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  582, 44, 1,    1,              'NewRangeMax',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  583, 44, 1,    1,       'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO op_constr_t VALUES (
  584, 44, 'IS_LOOPED',   'TheTargetAttribute',             NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  585, 44, 'IS_LOOPED',   'NewRangeMin',                    NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  586, 44, 'IS_LOOPED',   'NewRangeMax',                    NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  587, 44, 'IS_LOOPED',   'TheOutputAttribute',             NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  588, 44,        'IN',   'TheTargetAttribute',  'TheInputConcept',     NULL, NULL);
INSERT INTO op_constr_t VALUES (
  589, 44,        'IN',   'TheOutputAttribute',  'TheInputConcept',     NULL, NULL);
INSERT INTO op_constr_t VALUES (
  590, 44, 'SAME_TYPE',   'TheTargetAttribute',  'TheOutputAttribute',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  591, 44,      'TYPE',   'NewRangeMin',         'NUMERIC',             NULL, NULL);
INSERT INTO op_constr_t VALUES (
  592, 44,      'TYPE',   'NewRangeMax',         'NUMERIC',             NULL, NULL);
INSERT INTO op_constr_t VALUES (
  593, 44,        'GT',   'NewRangeMax',         'NewRangeMin',         NULL, NULL);

-- why not allow nulls? there will be nulls in the output, so what?
-- INSERT INTO op_cond_t VALUES (
--   594, 44, 'NOT_NULL', 'TheTargetAttribute', NULL, NULL, NULL);

INSERT INTO op_assert_t VALUES (
  595, 44, 'NOT_NULL', 'TheOutputAttribute',          NULL, NULL, NULL);
INSERT INTO op_assert_t VALUES (
  596, 44, 'GE',       'TheOutputAttribute', 'NewRangeMin', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  597, 44, 'LE',       'TheOutputAttribute', 'NewRangeMax', NULL, NULL);


-- assertions for estimation of statistics:
INSERT INTO op_assert_t VALUES (
  598, 44, 'MIN_FROM',  'TheOutputAttribute', 'NewRangeMin',  NULL, NULL);
INSERT INTO op_assert_t VALUES (
  599, 44, 'MAX_FROM',  'TheOutputAttribute', 'NewRangeMax',  NULL, NULL);
INSERT INTO op_assert_t VALUES (
  600, 44, 'MV_FROM',   'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
  
-------------------------------------------------------
INSERT INTO operator_t VALUES (45, 'LogScaling', 'YES', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  601, 45, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  602, 45, 1,    1,       'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  603, 45, 1,    1,                  'LogBase',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  604, 45, 1,    1,       'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO op_constr_t VALUES (
  605, 45, 'IS_LOOPED',   'TheTargetAttribute',             NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  606, 45, 'IS_LOOPED',   'LogBase',                        NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  607, 45, 'IS_LOOPED',   'TheOutputAttribute',             NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  608, 45,        'IN',   'TheTargetAttribute',  'TheInputConcept',     NULL, NULL);
INSERT INTO op_constr_t VALUES (
  609, 45,        'IN',   'TheOutputAttribute',  'TheInputConcept',     NULL, NULL);
INSERT INTO op_constr_t VALUES (
  610, 45, 'SAME_TYPE',   'TheTargetAttribute',  'TheOutputAttribute',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  611, 45,      'TYPE',   'LogBase',             'NUMERIC',             NULL, NULL);
INSERT INTO op_constr_t VALUES (
  612, 45,        'GT',   'LogBase',             0,                     NULL, NULL);

-- why not allow nulls? there will be nulls in the output, so what?
-- INSERT INTO op_cond_t VALUES (
--   613, 45, 'NOT_NULL', 'TheTargetAttribute', NULL, NULL, NULL);
INSERT INTO op_cond_t VALUES (
  614, 45, 'LOWERBOUND',       'TheTargetAttribute', 0,    NULL, NULL);

INSERT INTO op_assert_t VALUES (
  615, 45, 'NOT_NULL', 'TheOutputAttribute', NULL, NULL, NULL);
INSERT INTO op_assert_t VALUES (
  616, 44, 'MV_FROM',  'TheTargetAttribute', 'TheOutputAttribute',  NULL, NULL);

-------------------------------------------------------
INSERT INTO operator_t VALUES (46, 'AssignDefault', 'YES', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  617, 46, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  618, 46, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  619, 46, 1,   1,        'DefaultValue',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  620, 46, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO op_constr_t VALUES (
  621, 46,        'IN',   'TheTargetAttribute',     'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  622, 46,        'IN',   'TheOutputAttribute',     'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  623, 46, 'IS_LOOPED',   'TheTargetAttribute',             NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  624, 46, 'IS_LOOPED',   'DefaultValue',                   NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  625, 46, 'IS_LOOPED',   'TheOutputAttribute',             NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  626, 46, 'SAME_TYPE',   'TheOutputAttribute',  'TheTargetAttribute',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  627, 46, 'TYPE',              'DefaultValue',             'NOMINAL',  NULL, NULL);

INSERT INTO op_cond_t VALUES (
  628, 46, 'HAS_NULLS', 'TheTargetAttribute', NULL, NULL, NULL);

INSERT INTO op_assert_t VALUES (
  629, 46, 'NOT_NULL', 'TheOutputAttribute', NULL, NULL, NULL);

-- assertions for estimation of statistics:
INSERT INTO op_assert_t VALUES (
  630, 46, 'VL_FROM',  'TheTargetAttribute',  'TheOutputAttribute', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  631, 46, 'MM_FROM',  'TheTargetAttribute',  'TheOutputAttribute', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  632, 46, 'VF_REPL_MV', 'TheOutputAttribute',  'DefaultValue', NULL, NULL);
  
-------------------------------------------------------
INSERT INTO operator_t VALUES (47, 'AssignModalValue', 'YES', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  633, 47, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  634, 47, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  635, 47, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO op_constr_t VALUES (
  636, 47, 'IS_LOOPED',   'TheTargetAttribute',             NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  637, 47, 'IS_LOOPED',   'TheOutputAttribute',             NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  638, 47,        'IN',   'TheTargetAttribute',  'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  639, 47,        'IN',   'TheOutputAttribute',  'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  640, 47, 'SAME_TYPE',   'TheTargetAttribute',  'TheOutputAttribute', NULL, NULL);

INSERT INTO op_cond_t VALUES (
  641, 47, 'HAS_NULLS', 'TheTargetAttribute', NULL, NULL, NULL);

INSERT INTO op_assert_t VALUES (
  642, 47, 'NOT_NULL', 'TheOutputAttribute', NULL, NULL, NULL);

-------------------------------------------------------
INSERT INTO operator_t VALUES (48, 'AssignMedianValue', 'YES', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  643, 48, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  644, 48, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  645, 48, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO op_constr_t VALUES (
  646, 48, 'IS_LOOPED',   'TheTargetAttribute',             NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  647, 48, 'IS_LOOPED',   'TheOutputAttribute',             NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  648, 48,        'IN',   'TheTargetAttribute',  'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  649, 48,        'IN',   'TheOutputAttribute',  'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  650, 48, 'SAME_TYPE',   'TheTargetAttribute',  'TheOutputAttribute', NULL, NULL);

INSERT INTO op_cond_t VALUES (
  651, 48, 'HAS_NULLS', 'TheTargetAttribute', NULL, NULL, NULL);

INSERT INTO op_assert_t VALUES (
  652, 48, 'NOT_NULL', 'TheOutputAttribute', NULL, NULL, NULL);

-------------------------------------------------------
INSERT INTO operator_t VALUES (49, 'AssignAverageValue', 'YES', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  653, 49, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  654, 49, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  655, 49, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO op_constr_t VALUES (
  656, 49, 'IS_LOOPED',   'TheTargetAttribute',             NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  657, 49, 'IS_LOOPED',   'TheOutputAttribute',             NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  658, 49,        'IN',   'TheTargetAttribute',  'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  659, 49,        'IN',   'TheOutputAttribute',  'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  660, 49, 'SAME_TYPE',   'TheTargetAttribute',  'TheOutputAttribute', NULL, NULL);

INSERT INTO op_cond_t VALUES (
  661, 49, 'HAS_NULLS', 'TheTargetAttribute', NULL, NULL, NULL);

INSERT INTO op_assert_t VALUES (
  662, 49, 'NOT_NULL', 'TheOutputAttribute', NULL, NULL, NULL);

-------------------------------------------------------
INSERT INTO operator_t VALUES (50, 'AssignStochasticValue',  'YES', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  663, 50, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  664, 50, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  665, 50, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO op_constr_t VALUES (
  666, 50, 'IS_LOOPED',   'TheTargetAttribute',             NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  667, 50, 'IS_LOOPED',   'TheOutputAttribute',             NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  668, 50,        'IN',   'TheTargetAttribute',     'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  669, 50,        'IN',   'TheOutputAttribute',     'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  670, 50, 'SAME_TYPE',   'TheTargetAttribute',  'TheOutputAttribute',  NULL, NULL);

INSERT INTO op_cond_t VALUES (
  671, 50, 'HAS_NULLS', 'TheTargetAttribute', NULL, NULL, NULL);

INSERT INTO op_assert_t VALUES (
  672, 50, 'NOT_NULL', 'TheOutputAttribute', NULL, NULL, NULL);

-------------------------------------------------------
INSERT INTO operator_t VALUES (53, 'MissingValuesWithRegressionSVM', 'YES', 'NO', 'NO', NULL);

INSERT INTO op_params_t VALUES (
  673, 53, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  674, 53, 1,    1,       'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  675, 53, 1, NULL,  'ThePredictingAttributes',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  676, 53, 1,    1,               'KernelType',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  677, 53, 0,    1,               'SampleSize',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  678, 53, 1,    1,          'LossFunctionPos',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  679, 53, 1,    1,          'LossFunctionNeg',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  680, 53, 1,    1,                        'C',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  681, 53, 1,    1,                  'Epsilon',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  682, 53, 1,    1,       'TheOutputAttribute', 'OUT',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  683, 53, 0,    1,                'UseDB_SVM',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  684, 53, 0,    1,                   'TheKey',  'IN',  'BA', NULL);

INSERT INTO op_constr_t VALUES (
  685, 53, 'IS_LOOPED', 'TheTargetAttribute',      NULL, NULL, NULL);
INSERT INTO op_constr_t VALUES (
  686, 53, 'IS_LOOPED', 'ThePredictingAttributes', NULL, NULL, NULL);
INSERT INTO op_constr_t VALUES (
  687, 53, 'IS_LOOPED',        'KernelType',       NULL, NULL, NULL);
INSERT INTO op_constr_t VALUES (
  688, 53, 'IS_LOOPED',        'SampleSize',       NULL, NULL, NULL);
INSERT INTO op_constr_t VALUES (
  689, 53, 'IS_LOOPED',   'LossFunctionPos',       NULL, NULL, NULL);
INSERT INTO op_constr_t VALUES (
  690, 53, 'IS_LOOPED',   'LossFunctionNeg',       NULL, NULL, NULL);
INSERT INTO op_constr_t VALUES (
  691, 53, 'IS_LOOPED',                 'C',       NULL, NULL, NULL);
INSERT INTO op_constr_t VALUES (
  692, 53, 'IS_LOOPED',           'Epsilon',       NULL, NULL, NULL);
INSERT INTO op_constr_t VALUES (
  693, 53, 'IS_LOOPED','TheOutputAttribute',       NULL, NULL, NULL);
INSERT INTO op_constr_t VALUES (
  694, 53, 'IS_LOOPED',         'UseDB_SVM',       NULL, NULL, NULL);
INSERT INTO op_constr_t VALUES (
  695, 53, 'IS_LOOPED',            'TheKey',       NULL, NULL, NULL);

INSERT INTO op_constr_t VALUES (
  696, 53,        'IN',       'TheTargetAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  697, 53,        'IN',  'ThePredictingAttributes', 'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  698, 53,        'IN',       'TheOutputAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  699, 53, 'SAME_TYPE',       'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  700, 53,      'TYPE',  'ThePredictingAttributes',  'NOMINAL',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  701, 53,      'TYPE',  'ThePredictingAttributes',  'BINARY',            NULL, NULL);
INSERT INTO op_constr_t VALUES (
  702, 53,      'TYPE',  'ThePredictingAttributes',  'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  703, 53,      'TYPE',               'SampleSize',  'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  704, 53,      'TYPE',          'LossFunctionPos',  'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  705, 53,      'TYPE',          'LossFunctionNeg',  'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  706, 53,      'TYPE',                        'C',  'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  707, 53,      'TYPE',                  'Epsilon',  'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  708, 53,        'GE',               'SampleSize',          0,           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  709, 53,        'GE',          'LossFunctionPos',          0,           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  710, 53,        'GE',          'LossFunctionNeg',          0,           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  711, 53,        'GE',                        'C',          0,           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  712, 53,        'GE',                  'Epsilon',          0,           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  713, 53,    'ONE_OF',               'KernelType',
    'dot polynomial neural radial anova', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  714, 53,        'IN',                   'TheKey', 'TheInputConcept',    NULL, NULL);

INSERT INTO op_cond_t VALUES (
  715, 53, 'HAS_NULLS',     'TheTargetAttribute',      NULL, NULL, NULL);
INSERT INTO op_cond_t VALUES (
  716, 53, 'HAS_VALUES', 'TheTargetAttribute',      NULL, NULL, NULL);
INSERT INTO op_cond_t VALUES (
  717, 53, 'NOT_NULL',      'ThePredictingAttributes', NULL, NULL, NULL);

INSERT INTO op_assert_t VALUES (
  718, 53, 'NOT_NULL', 'TheOutputAttribute',      NULL, NULL, NULL);
INSERT INTO op_assert_t VALUES (
  719, 53, 'NOT_NULL', 'ThePredictingAttributes', NULL, NULL, NULL);

-------------------------------------------------------
INSERT INTO operator_t VALUES (63, 'SupportVectorMachineForRegression', 'YES', 'NO', 'NO', NULL);

INSERT INTO op_params_t VALUES (
  720, 63, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  721, 63, 1,    1,       'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  722, 63, 1, NULL,  'ThePredictingAttributes',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  723, 63, 1,    1,               'KernelType',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  724, 63, 0,    1,               'SampleSize',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  725, 63, 1,    1,          'LossFunctionPos',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  726, 63, 1,    1,          'LossFunctionNeg',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  727, 63, 1,    1,                        'C',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  728, 63, 1,    1,                  'Epsilon',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  729, 63, 1,    1,       'TheOutputAttribute', 'OUT',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  730, 63, 0,    1,                'UseDB_SVM',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  731, 63, 0,    1,                   'TheKey',  'IN',  'BA', NULL);

INSERT INTO op_constr_t VALUES (
  732, 63, 'IS_LOOPED', 'TheTargetAttribute', NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  733, 63, 'IS_LOOPED', 'ThePredictingAttributes', NULL, NULL, NULL);
INSERT INTO op_constr_t VALUES (
  734, 63, 'IS_LOOPED',        'KernelType',  NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  735, 63, 'IS_LOOPED',        'SampleSize',  NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  736, 63, 'IS_LOOPED',   'LossFunctionPos',  NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  737, 63, 'IS_LOOPED',   'LossFunctionNeg',  NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  738, 63, 'IS_LOOPED',                 'C',  NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  739, 63, 'IS_LOOPED',           'Epsilon',  NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  740, 63, 'IS_LOOPED','TheOutputAttribute',  NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  741, 63, 'IS_LOOPED',         'UseDB_SVM',  NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  742, 63, 'IS_LOOPED',            'TheKey',  NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  743, 63,        'IN',       'TheTargetAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  744, 63,        'IN',  'ThePredictingAttributes', 'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  745, 63,        'IN',       'TheOutputAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  746, 63, 'SAME_TYPE',       'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  747, 63,      'TYPE',  'ThePredictingAttributes',  'NOMINAL',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  748, 63,      'TYPE',  'ThePredictingAttributes',  'BINARY',            NULL, NULL);
INSERT INTO op_constr_t VALUES (
  749, 63,      'TYPE',  'ThePredictingAttributes',  'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  750, 63,      'TYPE',               'SampleSize',  'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  751, 63,      'TYPE',          'LossFunctionPos',  'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  752, 63,      'TYPE',          'LossFunctionNeg',  'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  753, 63,      'TYPE',                        'C',  'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  754, 63,      'TYPE',                  'Epsilon',  'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  755, 63,        'GE',               'SampleSize',          0,           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  756, 63,        'GE',          'LossFunctionPos',          0,           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  757, 63,        'GE',          'LossFunctionNeg',          0,           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  758, 63,        'GE',                        'C',          0,           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  759, 63,        'GE',                  'Epsilon',          0,           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  760, 63,    'ONE_OF',               'KernelType',
    'dot polynomial neural radial anova', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  761, 63,        'IN',                   'TheKey', 'TheInputConcept',    NULL, NULL);

INSERT INTO op_cond_t VALUES (
  762, 63, 'HAS_NULLS',          'TheTargetAttribute', NULL, NULL, NULL);
INSERT INTO op_cond_t VALUES (
  763, 63, 'HAS_VALUES',         'TheTargetAttribute', NULL, NULL, NULL);
INSERT INTO op_cond_t VALUES (
  764, 63, 'NOT_NULL',      'ThePredictingAttributes', NULL, NULL, NULL);

INSERT INTO op_assert_t VALUES (
  765, 63, 'NOT_NULL', 'TheOutputAttribute',      NULL, NULL, NULL);
INSERT INTO op_assert_t VALUES (
  766, 63, 'NOT_NULL', 'ThePredictingAttributes', NULL, NULL, NULL);

-- assertions for estimation of statistics:
INSERT INTO op_assert_t VALUES (
  767, 63, 'VL_FROM', 'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);

-------------------------------------------------------
INSERT INTO operator_t VALUES (67, 'Windowing', 'NO', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  768,   67,    1,    1,     'TheInputConcept',   'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  769,   67,    1,    1,      'TimeBaseAttrib',   'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  770,   67,    1,    1,     'ValueBaseAttrib',   'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  771,   67,    1,    1,          'WindowSize',   'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  772,   67,    1,    1,   'OutputTimeStartBA',  'OUT',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  773,   67,    1,    1,     'OutputTimeEndBA',  'OUT',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  774,   67,    1,    1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO op_constr_t VALUES (
  775, 67,        'IN',   'TimeBaseAttrib',    'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  776, 67,        'IN',   'ValueBaseAttrib',   'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  777, 67,        'IN',   'OutputTimeStartBA', 'TheOutputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  778, 67,        'IN',   'OutputTimeEndBA',   'TheOutputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  779, 67,  'CREATE_BY',  'ValueBaseAttrib',        'WindowSize', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  780, 67,      'TYPE',   'TimeBaseAttrib',                'TIME', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  781, 67, 'SAME_TYPE',   'OutputTimeStartBA',   'TimeBaseAttrib', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  782, 67, 'SAME_TYPE',   'OutputTimeEndBA',     'TimeBaseAttrib', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  783, 67,      'TYPE',   'WindowSize',                 'NUMERIC', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  784, 67,        'GE',   'WindowSize',                        1,  NULL, NULL);

INSERT INTO op_cond_t VALUES (
  785, 67, 'NOT_NULL', 'TimeBaseAttrib',  NULL, NULL, NULL);
INSERT INTO op_cond_t VALUES (
  786, 67, 'UNIQUE',   'TimeBaseAttrib',  NULL, NULL, NULL);
INSERT INTO op_cond_t VALUES (
  787, 67, 'ORDERED',  'TimeBaseAttrib', 'INC', NULL, NULL);

INSERT INTO op_assert_t VALUES (
  788, 67, 'REL_N_1', 'TheOutputConcept',    'TheInputConcept',   NULL, NULL);
-- an n:1 relationship from output to input will model the foreign key relationship that holds
INSERT INTO op_assert_t VALUES (
  789, 67, 'REL_N_K', 'OutputTimeStartBA', NULL, NULL, NULL);
-- the key on the "many-side" is given by the start time index in the output
INSERT INTO op_assert_t VALUES (
  790, 67, 'REL_1_K',  'TimeBaseAttrib', NULL, NULL, NULL);
-- the key on the "one-side" is given by the time attribute in the input
INSERT INTO op_assert_t VALUES (
  791, 67, 'NOT_NULL', 'OutputTimeStartBA',  NULL,             NULL, NULL);
INSERT INTO op_assert_t VALUES (
  792, 67, 'UNIQUE',   'OutputTimeStartBA',  NULL,             NULL, NULL);
INSERT INTO op_assert_t VALUES (
  793, 67, 'ORDERED',  'OutputTimeStartBA',  'INC',            NULL, NULL);
INSERT INTO op_assert_t VALUES (
  794, 67, 'NOT_NULL', 'OutputTimeEndBA',    NULL,             NULL, NULL);
INSERT INTO op_assert_t VALUES (
  795, 67, 'UNIQUE',   'OutputTimeEndBA',    NULL,             NULL, NULL);
INSERT INTO op_assert_t VALUES (
  796, 67, 'ORDERED',  'OutputTimeEndBA',    'INC',            NULL, NULL);
INSERT INTO op_assert_t VALUES (
  797, 67, 'LT',       'OutputTimeStartBA', 'OutputTimeEndBA', NULL, NULL);

-- assertions for estimation of statistics:
INSERT INTO op_assert_t VALUES (
  798, 67, 'SZ_DIV_BY', 'WindowSize', NULL, NULL, NULL);
INSERT INTO op_assert_t VALUES (
  799, 67, 'VL_FROM',   'ValueBaseAttrib', NULL, NULL, NULL);
INSERT INTO op_assert_t VALUES (
  800, 67, 'MM_FROM',   'ValueBaseAttrib', NULL, NULL, NULL);
INSERT INTO op_assert_t VALUES (
  801, 67, 'MM_FROM',   'TimeBaseAttrib', 'OutputTimeStartBA', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  802, 67, 'MM_FROM',   'TimeBaseAttrib', 'OutputTimeEndBA', NULL, NULL);
  
-------------------------------------------------------
INSERT INTO operator_t VALUES (68, 'SignalToSymbolProcessing', 'NO', 'NO', 'NO', NULL);

INSERT INTO op_params_t VALUES (
  803,   68,    1,    1,     'TheInputConcept',   'IN',  'CON', NULL);
INSERT INTO op_params_t VALUES (
  804,   68,    1,    1,         'InputTimeBA',   'IN',   'BA', NULL);
INSERT INTO op_params_t VALUES (
  805,   68,    1,    1,        'InputValueBA',   'IN',   'BA', NULL);
INSERT INTO op_params_t VALUES (
  806,   68,    1,    1,           'Tolerance',   'IN',    'V', NULL);
INSERT INTO op_params_t VALUES (
  807,   68,    1,    1,      'AverageValueBA',   'OUT',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  808,   68,    1,    1,     'IncreaseValueBA',   'OUT',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  809,   68,    1,    1,   'OutputTimeStartBA',   'OUT',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  810,   68,    1,    1,     'OutputTimeEndBA',   'OUT',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  811,   68,    1,    1,    'TheOutputConcept',   'OUT', 'CON', NULL);

INSERT INTO op_constr_t VALUES (
  812, 68,        'IN',   'InputTimeBA',       'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  813, 68,        'IN',   'InputValueBA',      'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  814, 68,        'IN',   'AverageValueBA',    'TheOutputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  815, 68,        'IN',   'IncreaseValueBA',   'TheOutputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  816, 68,        'IN',   'OutputTimeStartBA', 'TheOutputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  817, 68,        'IN',   'OutputTimeEndBA',   'TheOutputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  818, 68,      'TYPE',   'InputTimeBA',                  'TIME',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  819, 68,      'TYPE',   'InputValueBA',              'NOMINAL',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  820, 68,      'TYPE',   'InputValueBA',               'BINARY',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  821, 68,      'TYPE',   'InputValueBA',              'NUMERIC',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  822, 68, 'SAME_TYPE',   'OutputTimeStartBA',     'InputTimeBA',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  823, 68, 'SAME_TYPE',   'OutputTimeEndBA',       'InputTimeBA',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  824, 68, 'SAME_TYPE',   'AverageValueBA',       'InputValueBA',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  825, 68, 'SAME_TYPE',   'IncreaseValueBA',      'InputValueBA',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  826, 68,      'TYPE',   'Tolerance',                  'NUMERIC', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  827, 68,        'GE',   'Tolerance',                          1, NULL, NULL);

INSERT INTO op_cond_t VALUES (
  828, 68, 'NOT_NULL', 'InputTimeBA',  NULL,  NULL, NULL);
INSERT INTO op_cond_t VALUES (
  829, 68, 'UNIQUE',   'InputTimeBA',  NULL,  NULL, NULL);
INSERT INTO op_cond_t VALUES (
  830, 68, 'ORDERED',  'InputTimeBA',  'INC', NULL, NULL);
INSERT INTO op_cond_t VALUES (
  831, 68, 'NOT_NULL', 'InputValueBA', 'INC', NULL, NULL);

INSERT INTO op_assert_t VALUES (
  832, 68, 'NOT_NULL', 'OutputTimeStartBA', NULL,              NULL, NULL);
INSERT INTO op_assert_t VALUES (
  833, 68, 'UNIQUE',   'OutputTimeStartBA', NULL,              NULL, NULL);
INSERT INTO op_assert_t VALUES (
  834, 68, 'ORDERED',  'OutputTimeStartBA', 'INC',             NULL, NULL);
INSERT INTO op_assert_t VALUES (
  835, 68, 'NOT_NULL', 'OutputTimeEndBA',   NULL,              NULL, NULL);
INSERT INTO op_assert_t VALUES (
  836, 68, 'UNIQUE',   'OutputTimeEndBA',   NULL,              NULL, NULL);
INSERT INTO op_assert_t VALUES (
  837, 68, 'ORDERED',  'OutputTimeEndBA',   'INC',             NULL, NULL);
INSERT INTO op_assert_t VALUES (
  838, 68, 'LT',       'OutputTimeStartBA', 'OutputTimeEndBA', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  839, 68, 'NOT_NULL', 'AverageValueBA',    NULL,              NULL, NULL);
INSERT INTO op_assert_t VALUES (
  840, 68, 'NOT_NULL', 'IncreaseValueBA',   NULL,              NULL, NULL);

-------------------------------------------------------
INSERT INTO operator_t VALUES (70, 'SimpleMovingFunction', 'NO', 'NO', 'NO', NULL);

INSERT INTO op_params_t VALUES (
  841,   70,    1,    1,     'TheInputConcept',   'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  842,   70,    1,    1,         'InputTimeBA',   'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  843,   70,    1,    1,        'InputValueBA',   'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  844,   70,    1,    1,          'WindowSize',   'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  845,   70,    1,    1,            'Distance',   'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  846,   70,    1,    1,   'OutputTimeStartBA',  'OUT',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  847,   70,    1,    1,     'OutputTimeEndBA',  'OUT',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  848,   70,    1,    1,       'OutputValueBA',  'OUT',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  849,   70,    1,    1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO op_constr_t VALUES (
  850, 70,        'IN',   'InputTimeBA',       'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  851, 70,        'IN',   'InputValueBA',      'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  852, 70,        'IN',   'OutputTimeStartBA', 'TheOutputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  853, 70,        'IN',   'OutputTimeEndBA',   'TheOutputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  854, 70,        'IN',   'OutputValueBA',     'TheOutputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  855, 70,      'TYPE',   'InputTimeBA',                   'TIME', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  856, 70,      'TYPE',   'InputValueBA',              'NOMINAL',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  857, 70,      'TYPE',   'InputValueBA',               'BINARY',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  858, 70,      'TYPE',   'InputValueBA',              'NUMERIC',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  859, 70, 'SAME_TYPE',   'OutputTimeStartBA',      'InputTimeBA', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  860, 70, 'SAME_TYPE',   'OutputTimeEndBA',        'InputTimeBA', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  861, 70, 'SAME_TYPE',   'InputValueBA',         'OutputValueBA', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  862, 70,      'TYPE',   'WindowSize',                 'NUMERIC', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  863, 70,      'TYPE',   'Distance',                   'NUMERIC', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  864, 70,        'GE',   'WindowSize',                        1,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  865, 70,        'GE',   'Distance',                          1,  NULL, NULL);

INSERT INTO op_cond_t VALUES (
  866, 70, 'NOT_NULL', 'InputTimeBA',  NULL,  NULL, NULL);
INSERT INTO op_cond_t VALUES (
  867, 70, 'UNIQUE',   'InputTimeBA',  NULL,  NULL, NULL);
INSERT INTO op_cond_t VALUES (
  868, 70, 'ORDERED',  'InputTimeBA',  'INC', NULL, NULL);
INSERT INTO op_cond_t VALUES (
  869, 70, 'NOT_NULL', 'InputValueBA', 'INC', NULL, NULL);

INSERT INTO op_assert_t VALUES (
  870, 70, 'NOT_NULL', 'OutputTimeStartBA', NULL,              NULL, NULL);
INSERT INTO op_assert_t VALUES (
  871, 70, 'UNIQUE',   'OutputTimeStartBA', NULL,              NULL, NULL);
INSERT INTO op_assert_t VALUES (
  872, 70, 'ORDERED',  'OutputTimeStartBA', 'INC',             NULL, NULL);
INSERT INTO op_assert_t VALUES (
  873, 70, 'NOT_NULL', 'OutputTimeEndBA',   NULL,              NULL, NULL);
INSERT INTO op_assert_t VALUES (
  874, 70, 'UNIQUE',   'OutputTimeEndBA',   NULL,              NULL, NULL);
INSERT INTO op_assert_t VALUES (
  875, 70, 'ORDERED',  'OutputTimeEndBA',   'INC',             NULL, NULL);
INSERT INTO op_assert_t VALUES (
  876, 70, 'LT',       'OutputTimeStartBA', 'OutputTimeEndBA', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  877, 70, 'NOT_NULL', 'OutputValueBA',     NULL,              NULL, NULL);

-------------------------------------------------------
INSERT INTO operator_t VALUES (71, 'WeightedMovingFunction', 'NO', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  878,   71,    1,    1,     'TheInputConcept',   'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  879,   71,    1,    1,         'InputTimeBA',   'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  880,   71,    1,    1,        'InputValueBA',   'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  881,   71,    1, NULL,             'Weights',   'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  882,   71,    1,    1,            'Distance',   'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  883,   71,    1,    1,   'OutputTimeStartBA',  'OUT',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  884,   71,    1,    1,     'OutputTimeEndBA',  'OUT',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  885,   71,    1,    1,       'OutputValueBA',  'OUT',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  886,   71,    1,    1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO op_constr_t VALUES (
  887, 71,        'IN',   'InputTimeBA',       'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  888, 71,        'IN',   'InputValueBA',      'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  889, 71,        'IN',   'OutputTimeStartBA', 'TheOutputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  890, 71,        'IN',   'OutputTimeEndBA',   'TheOutputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  891, 71,        'IN',   'OutputValueBA',     'TheOutputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  892, 71,      'TYPE',   'InputTimeBA',                   'TIME', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  893, 71,      'TYPE',   'InputValueBA',              'NOMINAL',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  894, 71,      'TYPE',   'InputValueBA',               'BINARY',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  895, 71,      'TYPE',   'InputValueBA',              'NUMERIC',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  896, 71, 'SAME_TYPE',   'OutputTimeStartBA',     'InputTimeBA',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  897, 71, 'SAME_TYPE',   'OutputTimeEndBA',       'InputTimeBA',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  898, 71, 'SAME_TYPE',   'InputValueBA',         'OutputValueBA', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  899, 71,      'TYPE',   'Weights',                   'NUMERIC',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  900, 71,      'TYPE',   'Distance',                  'NUMERIC',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  901, 71,       'SUM',   'Weights',                           1,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  902, 71,        'GE',   'Distance',                          1,  NULL, NULL);

INSERT INTO op_cond_t VALUES (
  903, 71, 'NOT_NULL', 'InputTimeBA',  NULL,  NULL, NULL);
INSERT INTO op_cond_t VALUES (
  904, 71, 'UNIQUE',   'InputTimeBA',  NULL,  NULL, NULL);
INSERT INTO op_cond_t VALUES (
  905, 71, 'ORDERED',  'InputTimeBA',  'INC', NULL, NULL);
INSERT INTO op_cond_t VALUES (
  906, 71, 'NOT_NULL', 'InputValueBA', 'INC', NULL, NULL);

INSERT INTO op_assert_t VALUES (
  907, 71, 'NOT_NULL', 'OutputTimeStartBA', NULL,              NULL, NULL);
INSERT INTO op_assert_t VALUES (
  908, 71, 'UNIQUE',   'OutputTimeStartBA', NULL,              NULL, NULL);
INSERT INTO op_assert_t VALUES (
  909, 71, 'ORDERED',  'OutputTimeStartBA', 'INC',             NULL, NULL);
INSERT INTO op_assert_t VALUES (
  910, 71, 'NOT_NULL', 'OutputTimeEndBA',   NULL,              NULL, NULL);
INSERT INTO op_assert_t VALUES (
  911, 71, 'UNIQUE',   'OutputTimeEndBA',   NULL,              NULL, NULL);
INSERT INTO op_assert_t VALUES (
  912, 71, 'ORDERED',  'OutputTimeEndBA',   'INC',             NULL, NULL);
INSERT INTO op_assert_t VALUES (
  913, 71, 'LT',       'OutputTimeStartBA', 'OutputTimeEndBA', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  914, 71, 'NOT_NULL', 'OutputValueBA',     NULL,              NULL, NULL);

-------------------------------------------------------
INSERT INTO operator_t VALUES (72, 'ExponentialMovingFunction', 'NO', 'NO', 'NO', NULL);

INSERT INTO op_params_t VALUES (
  915,   72,    1,    1,     'TheInputConcept',   'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  916,   72,    1,    1,         'InputTimeBA',   'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  917,   72,    1,    1,        'InputValueBA',   'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  918,   72,    1,    1,          'HeadWeight',   'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  919,   72,    1,    1,          'TailWeight',   'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  920,   72,    1,    1,            'Distance',   'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  921,   72,    1,    1,        'OutputTimeBA',  'OUT',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  922,   72,    1,    1,       'OutputValueBA',  'OUT',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  923,   72,    1,    1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO op_constr_t VALUES (
  924, 72,        'IN',   'InputTimeBA',       'TheInputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  925, 72,        'IN',   'InputValueBA',      'TheInputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  926, 72,        'IN',   'OutputTimeBA',     'TheOutputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  927, 72,        'IN',   'OutputValueBA',    'TheOutputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  928, 72,      'TYPE',   'InputTimeBA',                  'TIME', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  929, 72,      'TYPE',   'InputValueBA',              'NOMINAL',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  930, 72,      'TYPE',   'InputValueBA',               'BINARY',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  931, 72,      'TYPE',   'InputValueBA',              'NUMERIC',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  932, 72, 'SAME_TYPE',   'OutputTimeBA',          'InputTimeBA', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  933, 72, 'SAME_TYPE',   'InputValueBA',        'OutputValueBA', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  934, 72,      'TYPE',   'HeadWeight',                'NUMERIC', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  935, 72,      'TYPE',   'TailWeight',                'NUMERIC', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  936, 72,      'TYPE',   'Distance',                  'NUMERIC', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  937, 72,       'SUM',   'HeadWeight,TailWeight',             1, NULL, NULL);
INSERT INTO op_constr_t VALUES (
  938, 72,        'GE',   'Distance',                          1, NULL, NULL);

INSERT INTO op_cond_t VALUES (
  939, 72, 'NOT_NULL', 'InputTimeBA',  NULL,  NULL, NULL);
INSERT INTO op_cond_t VALUES (
  940, 72, 'UNIQUE',   'InputTimeBA',  NULL,  NULL, NULL);
INSERT INTO op_cond_t VALUES (
  941, 72, 'ORDERED',  'InputTimeBA',  'INC', NULL, NULL);
INSERT INTO op_cond_t VALUES (
  942, 72, 'NOT_NULL', 'InputValueBA', 'INC', NULL, NULL);

INSERT INTO op_assert_t VALUES (
  943, 72, 'NOT_NULL', 'OutputTimeBA',  NULL,  NULL, NULL);
INSERT INTO op_assert_t VALUES (
  944, 72, 'UNIQUE',   'OutputTimeBA',  NULL,  NULL, NULL);
INSERT INTO op_assert_t VALUES (
  945, 72, 'ORDERED',  'OutputTimeBA',  'INC', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  946, 72, 'NOT_NULL', 'OutputValueBA', NULL,  NULL, NULL);

-------------------------------------------------------
INSERT INTO operator_t VALUES (73, 'ComputeSVMError', 'NO', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  947, 73, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  948, 73, 1,    1,       'TheTargetValueAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  949, 73, 1,    1,   'ThePredictedValueAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  950, 73, 0,    1,          'LossFunctionPos',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  951, 73, 0,    1,          'LossFunctionNeg',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  952, 73, 1,    1,                        'C',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  953, 73, 1,    1,                  'Epsilon',  'IN',   'V', NULL);

INSERT INTO op_constr_t VALUES (
  954, 73,        'IN',      'TheTargetValueAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  955, 73,        'IN',   'ThePredictedValueAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  956, 73,       'TYPE',     'TheTargetValueAttribute',  'NOMINAL',            NULL, NULL);
INSERT INTO op_constr_t VALUES (
  957, 73,       'TYPE',     'TheTargetValueAttribute',  'BINARY',            NULL, NULL);
INSERT INTO op_constr_t VALUES (
  958, 73,       'TYPE',     'TheTargetValueAttribute',  'NUMERIC',            NULL, NULL);
INSERT INTO op_constr_t VALUES (
  959, 73,       'TYPE',  'ThePredictedValueAttribute',  'NOMINAL',            NULL, NULL);
INSERT INTO op_constr_t VALUES (
  960, 73,       'TYPE',  'ThePredictedValueAttribute',  'BINARY',            NULL, NULL);
INSERT INTO op_constr_t VALUES (
  961, 73,       'TYPE',  'ThePredictedValueAttribute',  'NUMERIC',            NULL, NULL);
INSERT INTO op_constr_t VALUES (
  962, 73,       'TYPE',         'LossFunctionPos',  'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  963, 73,       'TYPE',         'LossFunctionNeg',  'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  964, 73,       'TYPE',                       'C',  'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  965, 73,       'TYPE',                 'Epsilon',  'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  966, 73,         'GE',         'LossFunctionPos',          0,           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  967, 73,         'GE',         'LossFunctionNeg',          0,           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  968, 73,         'GE',                       'C',          0,           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  969, 73,         'GE',                 'Epsilon',          0,           NULL, NULL);

INSERT INTO op_cond_t VALUES (
  970, 73, 'NOT_NULL',      'ThePredictedValueAttribute', NULL, NULL, NULL);

-- no assertions
-------------------------------------------------------
INSERT INTO operator_t VALUES (74, 'Unsegment', 'NO', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  971,   74,    1,      1,    'TheInputConcept',    'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  972,   74,    1,      1,    'UnsegmentAttribute', 'OUT',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  973,   74,    1,      1,    'TheOutputConcept',   'OUT', 'CON', NULL);

-- constraint: 'UnsegmentAttribute' in 'TheOutputConcept' or pseudo-BA,
--       In one of the preceding steps: Segment by 'UnsegmentAttribute'
INSERT INTO op_constr_t VALUES (
  974, 74,        'IN',   'UnsegmentAttribute', 'TheOutputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  975, 74, 'SAME_FEAT',   'TheOutputConcept',   'TheInputConcept',  NULL, NULL);
  
-- no conditions

INSERT INTO op_assert_t VALUES (
  976,  74, 'SUBSET', 'TheInputConcept', 'TheOutputConcept', NULL, NULL); 
-- input is subset of output
INSERT INTO op_assert_t VALUES (
  977,  74, 'NOT_NULL', 'UnsegmentAttribute', NULL, NULL, NULL); 

-------------------------------------------------------

INSERT INTO operator_t VALUES (76, 'JoinByKey', 'NO', 'NO', 'YES', NULL);

-- (the operator is not applied in loops but 
--  uses the loop mechanism for parameter specification)

INSERT INTO op_params_t VALUES (
  978,   76,    2,   NULL,    'TheConcepts',        'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  979,   76,    2,   NULL,    'TheKeys',            'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  980,   76,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  981,   76,    0,   NULL,    'MapInput',              'IN', 'FEA', NULL);
INSERT INTO op_params_t VALUES (
  982,   76,    0,   NULL,    'MapOutput',            'OUT', 'FEA', NULL);

INSERT INTO op_constr_t VALUES (
  983, 76,   'IN',        'TheKeys',   'TheConcepts',      NULL, NULL);
INSERT INTO op_constr_t VALUES (
  984, 76,   'IN',        'MapInput',  'TheConcepts',      NULL, NULL);
INSERT INTO op_constr_t VALUES (
  985, 76, 'COORD', 'MapInput',  'MapOutput',	 NULL, NULL);
INSERT INTO op_constr_t VALUES (
  986, 76, 'COORD', 'TheKeys', 'TheConcepts',	 NULL, NULL);
INSERT INTO op_constr_t VALUES (
  987, 76, 'ALL_EXCEPT',   'TheKeys',   'TheOutputConcept',	 NULL, NULL);
INSERT INTO op_constr_t VALUES (
  988, 76, 'ALL_EXCEPT',   'MapInput',  'TheOutputConcept',	 NULL, NULL);
INSERT INTO op_constr_t VALUES (
  989, 76, 'MATCHBYCON',   'TheKeys',   NULL,	 NULL, NULL);
INSERT INTO op_constr_t VALUES (
  990, 76, 'RENAME_OUT',  'MapInput',  'MapOutput',	 NULL, NULL);
INSERT INTO op_constr_t VALUES (
  991, 76, 'NO_COMMON',  'TheConcepts',  NULL,	 NULL, NULL);


-- no conditions
INSERT INTO op_assert_t VALUES (
  992, 76, 'PROJ',     'TheConcepts', 'TheOutputConcept', NULL, NULL); 
-- theConcepts are projs of output

INSERT INTO op_assert_t VALUES (
  993, 76, 'SZ_BY_REL', 'TheConcepts', 'TheOutputConcept', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  994, 76, 'MM_UNCH', 'TheConcepts', 'TheOutputConcept', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  995, 76, 'VL_UNCH', 'TheConcepts', 'TheOutputConcept', NULL, NULL);
  
-------------------------------------------------------
INSERT INTO operator_t VALUES (77, 'SpecifiedStatistics', 'NO', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  996,   77,    1,   1,    'TheInputConcept',          'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  997,   77,    0,   NULL, 'GroupBy',                  'IN', 'BA',  NULL);
INSERT INTO op_params_t VALUES (
  998,   77,    0,   NULL, 'AttributesComputeSum',     'IN', 'BA',  NULL);
INSERT INTO op_params_t VALUES (
  999,   77,    0,   NULL, 'AttributesComputeCount',   'IN', 'BA',  NULL);
INSERT INTO op_params_t VALUES (
  1000,   77,    0,   NULL, 'AttributesComputeUnique',  'IN', 'BA',  NULL);
INSERT INTO op_params_t VALUES (
  1001,   77,    0,   NULL, 'AttributesComputeMin',     'IN', 'BA',  NULL);
INSERT INTO op_params_t VALUES (
  1002,   77,    0,   NULL, 'AttributesComputeMax',     'IN', 'BA',  NULL);
INSERT INTO op_params_t VALUES (
  1003,   77,    0,   NULL, 'AttributesComputeAvg',     'IN', 'BA',  NULL);
INSERT INTO op_params_t VALUES (
  1004,   77,    0,   NULL, 'AttributesComputeDistrib', 'IN', 'BA',  NULL);
INSERT INTO op_params_t VALUES (
  1005,   77,    0,   NULL, 'DistribValues',            'IN', 'V',   NULL);
INSERT INTO op_params_t VALUES (
  1006,   77,    1,      1, 'TheOutputConcept',        'OUT', 'CON', NULL);

INSERT INTO op_constr_t VALUES (
  1007,  77,  'IN',   'GroupBy',                  'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1008,  77,  'IN',   'GroupBy',                  'TheOutputConcept',   NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1009,  77,  'IN',   'AttributesComputeSum',     'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1010,  77,  'IN',   'AttributesComputeCount',   'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1011,  77,  'IN',   'AttributesComputeUnique',  'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1012,  77,  'IN',   'AttributesComputeDistrib', 'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1013,  77,  'IN',   'AttributesComputeMin',     'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1014,  77,  'IN',   'AttributesComputeMax',     'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1015,  77,  'IN',   'AttributesComputeAvg',     'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1016,  77, 'COORD', 'AttributesComputeDistrib', 'DistribValues',      NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1017,  77,  'TYPE', 'AttributesComputeSum',     'NUMERIC',            NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1018,  77,  'TYPE', 'AttributesComputeAvg',     'NUMERIC',            NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1019,  77,  'TYPE', 'AttributesComputeMin',     'NUMERIC',            NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1020,  77,  'TYPE', 'AttributesComputeMax',     'NUMERIC',            NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1021,  77,  'CR_SUFFIX', 'AttributesComputeMax',     'MAX',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1022,  77,  'CR_SUFFIX', 'AttributesComputeSum',     'SUM',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1023,  77,  'CR_SUFFIX', 'AttributesComputeMin',     'MIN',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1024,  77,  'CR_SUFFIX', 'AttributesComputeAvg',     'AVG',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1025,  77,  'CR_SUFFIX', 'AttributesComputeUnique',  'UNIQUE',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1026,  77,  'CR_SUFFIX', 'AttributesComputeCount',   'COUNT',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1027,  77,  'OUT_TYPE', 'AttributesComputeMax',     'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1028,  77,  'OUT_TYPE', 'AttributesComputeSum',     'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1029,  77,  'OUT_TYPE', 'AttributesComputeMin',     'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1030,  77,  'OUT_TYPE', 'AttributesComputeAvg',    'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1031,  77,  'OUT_TYPE', 'AttributesComputeUnique',  'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1032,  77,  'OUT_TYPE', 'AttributesComputeCount',   'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1033,  77,  'OUT_TYPE', 'AttributesComputeDistrib', 'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1034,  77,  'CREATE_BY', 'AttributesComputeDistrib',   'DistribValues',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1035,  77,  'USE_VALS',  'DistribValues',    'AttributesComputeDistrib', NULL, NULL);

-- no conditions

INSERT INTO op_assert_t VALUES (
  1036, 77, 'REL_N_1', 'TheInputConcept',    'TheOutputConcept',   NULL, NULL);
-- an n:1 relationship from input to output exists (if there are any group-by attributes)
INSERT INTO op_assert_t VALUES (
  1037, 77, 'REL_N_K', 'GroupBy',            NULL, NULL, NULL);
-- the keys on the "many-side" are given by the GroupBy attributes
INSERT INTO op_assert_t VALUES (
  1038, 77, 'REL_1_K', 'GroupBy',            NULL, NULL, NULL);
-- the keys on the "one-side" are given by the GroupBy attributes

-- assertions for estimation of statistics:
INSERT INTO op_assert_t VALUES (
  1039, 77, 'SZ_BY_VL', 'GroupBy', NULL, NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1040, 77, 'VF_BY_AGG', 'GroupBy', NULL, NULL, NULL);

-------------------------------------------------------
-- INSERT INTO operator_t VALUES (82, 'PredictionWithDecisionTree','YES','NO','NO',NULL);

-- INSERT INTO op_params_t VALUES (
--   1041, 82, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
-- INSERT INTO op_params_t VALUES (
--   1042, 82, 1,    1,       'TheTargetAttribute',  'IN',  'BA', NULL);
-- INSERT INTO op_params_t VALUES (
--   1043, 82, 1, NULL,  'ThePredictingAttributes',  'IN',  'BA', NULL);
-- INSERT INTO op_params_t VALUES (
--   1044, 82, 1,    1,               'SampleSize',  'IN',   'V', NULL);
-- INSERT INTO op_params_t VALUES (
--   1045, 82, 1,    1,       'TheOutputAttribute', 'OUT',  'BA', NULL);
-- INSERT INTO op_params_t VALUES (
--   1046, 82, 1,    1,               'PruningConf',  'IN',   'V', NULL);

--- Constraints

-- INSERT INTO op_constr_t VALUES (
--   1047, 82, 'IS_LOOPED',       'TheTargetAttribute',  NULL, NULL, NULL);
-- INSERT INTO op_constr_t VALUES (
--   1048, 82, 'IS_LOOPED',  'ThePredictingAttributes',  NULL, NULL, NULL);
-- INSERT INTO op_constr_t VALUES (
--   1049, 82, 'IS_LOOPED',               'SampleSize',  NULL, NULL, NULL);
-- INSERT INTO op_constr_t VALUES (
--   1050, 82, 'IS_LOOPED',       'TheOutputAttribute',  NULL, NULL, NULL);
-- INSERT INTO op_constr_t VALUES (
--   1051, 82, 'IS_LOOPED',               'PruningConf', NULL, NULL, NULL);
-- 
-- INSERT INTO op_constr_t VALUES (
--   1052, 82,        'IN',       'TheTargetAttribute', 'TheInputConcept',    NULL, NULL);
-- INSERT INTO op_constr_t VALUES (
--   1053, 82,        'IN',  'ThePredictingAttributes', 'TheInputConcept',    NULL, NULL);
-- INSERT INTO op_constr_t VALUES (
--   1054, 82,        'IN',       'TheOutputAttribute', 'TheInputConcept',    NULL, NULL);
-- INSERT INTO op_constr_t VALUES (
--   1055, 82, 'SAME_TYPE',       'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
-- INSERT INTO op_constr_t VALUES (
--   1056, 82,      'TYPE',  'ThePredictingAttributes',  'NOMINAL',            NULL, NULL);
-- INSERT INTO op_constr_t VALUES (
--   1057, 82,      'TYPE',  'ThePredictingAttributes',  'NUMERIC',        NULL, NULL);
-- INSERT INTO op_constr_t VALUES (
--   1058, 82,      'TYPE',  'ThePredictingAttributes',  'BINARY',        NULL, NULL);
-- INSERT INTO op_constr_t VALUES (
--   1059, 82,      'TYPE',  'TheTargetAttribute',  'NOMINAL',            NULL, NULL);
-- INSERT INTO op_constr_t VALUES (
--   1060, 82,      'TYPE',               'SampleSize',  'NUMERIC',           NULL, NULL);
-- INSERT INTO op_constr_t VALUES (
--   1061, 82,      'TYPE',               'PruningConf',  'NUMERIC',           NULL, NULL);
-- 
-- conditions

-- INSERT INTO op_cond_t VALUES (
--   1062, 82, 'HAS_NULLS',     'TheTargetAttribute',      NULL, NULL, NULL);
-- INSERT INTO op_cond_t VALUES (
--   1063, 82, 'HAS_VALUES', 'TheTargetAttribute',      NULL, NULL, NULL);
-- INSERT INTO op_cond_t VALUES (
--   1064, 82, 'NOT_NULL',      'ThePredictingAttributes', NULL, NULL, NULL);
-- 
-- assertions

-- INSERT INTO op_assert_t VALUES (
--   1065, 82, 'NOT_NULL', 'TheOutputAttribute',      NULL, NULL, NULL);
-- INSERT INTO op_assert_t VALUES (
--   1066, 82, 'NOT_NULL', 'ThePredictingAttributes', NULL, NULL, NULL);

-------------------------------------------------------
INSERT INTO operator_t VALUES (84, 'Apriori', 'NO', 'NO', 'NO', NULL);

INSERT INTO op_params_t VALUES (
1067, 84, 1, 1, 'TheInputConcept',  'IN',  'CON', NULL );
INSERT INTO op_params_t VALUES (
1068, 84, 1, 1, 'TheOutputConcept', 'OUT', 'CON', NULL );
INSERT INTO op_params_t VALUES (
1069, 84, 1, 1, 'CustID',           'IN',  'BA',  NULL );
INSERT INTO op_params_t VALUES (
1070, 84, 1, 1, 'TransID',          'IN',  'BA',  NULL );
INSERT INTO op_params_t VALUES (
1071, 84, 1, 1, 'Item',             'IN',  'BA',  NULL );
INSERT INTO op_params_t VALUES (
1072, 84, 1, 1, 'MinSupport',       'IN',  'V',   NULL );
INSERT INTO op_params_t VALUES (
1073, 84, 1, 1, 'MinConfidence',    'IN',  'V',   NULL );
INSERT INTO op_params_t VALUES (
1074, 84, 1, 1, 'SampleSize',       'IN',  'V',   NULL );
INSERT INTO op_params_t VALUES (
1075, 84, 1, 1, 'PremiseBA',       'OUT', 'BA',   NULL );
INSERT INTO op_params_t VALUES (
1076, 84, 1, 1, 'ConclusionBA',    'OUT', 'BA',   NULL );

INSERT INTO op_constr_t VALUES (
  1077, 84,        'IN',   'CustID',       'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1078, 84,        'IN',   'TransID',      'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1079, 84,        'IN',   'Item',         'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1080, 84,        'IN',   'PremiseBA',    'TheOutputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1081, 84,        'IN',   'ConclusionBA', 'TheOutputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1082, 84,        'TYPE', 'PremiseBA',    'NOMINAL',          NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1083, 84,        'TYPE', 'ConclusionBA', 'NOMINAL',          NULL, NULL );
INSERT INTO op_constr_t VALUES (
  1084, 84, 'GE', 'MinSupport',    0, NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1085, 84, 'GE', 'MinConfidence',    0, NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1086, 84, 'LE', 'MinConfidence',    1, NULL, NULL);

-- further constraints still missing
-- conditions still missing
-- assertions still missing
-------------------------------------------------------
INSERT INTO operator_t VALUES (85, 'StatisticalFeatureSelection','NO','NO','NO',NULL);

-- Parameters

INSERT INTO op_params_t VALUES (
  1087, 85, 1,    1,          'TheInputConcept',  'IN',  'CON', NULL);
INSERT INTO op_params_t VALUES (
  1088, 85, 1,    NULL,       'TheAttributes',    'IN',   'BA', NULL);
INSERT INTO op_params_t VALUES (
  1089, 85, 1,    1,               'SampleSize',  'IN',    'V', NULL);
INSERT INTO op_params_t VALUES (
  1090, 85, 1,    1,       'TheOutputConcept',   'OUT',  'CON', NULL);
INSERT INTO op_params_t VALUES (
  1091, 85, 1,    1,               'Threshold',   'IN',    'V', NULL);

-- Constraints

INSERT INTO op_constr_t VALUES (
  1092, 85,      'IN',    'TheAttributes',  'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1093, 85,      'TYPE',  'TheAttributes',  'NOMINAL',             NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1094, 85,      'TYPE',  'TheAttributes',  'NUMERIC',         NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1095, 85,      'TYPE',  'TheAttributes',  'BINARY',            NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1096, 85,      'TYPE',  'SampleSize',     'NUMERIC',            NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1097, 85,      'TYPE',  'Threshold',      'NUMERIC',            NULL, NULL);

INSERT INTO op_constr_t VALUES (
  1098, 85, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);

-- conditions still missing

INSERT INTO op_assert_t VALUES (
  1099, 85, 'PROJ', 'TheOutputConcept', 'TheInputConcept', NULL, NULL); 
-- output is proj of input

-- assertions for estimation of statistics:
INSERT INTO op_assert_t VALUES (
  1100, 85, 'NO_CHANGE', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);
  
-------------------------------------------------------
INSERT INTO operator_t VALUES (86, 'GeneticFeatureSelection','NO','NO','NO',NULL);

-- Parameters

INSERT INTO op_params_t VALUES (
  1101, 86, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1102, 86, 1,    NULL,       'TheAttributes',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1103, 86, 1,    1,       'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1104, 86, 1,    1,               'SampleSize',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  1105, 86, 1,    1,       'TheOutputConcept', 'OUT',  'CON', NULL);
INSERT INTO op_params_t VALUES (
  1106, 86, 1,    1,               'PopDim',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  1107, 86, 1,    1,               'StepNum',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  1108, 86, 1,    1,               'ProbMut',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  1109, 86, 1,    1,               'ProbCross',  'IN',   'V', NULL);

-- Constraints

INSERT INTO op_constr_t VALUES (
  1110, 86,        'IN',  'TheAttributes',       'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1111, 86,        'IN',  'TheTargetAttribute',  'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1112, 86,      'TYPE',  'TheTargetAttribute',  'NOMINAL',       NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1113, 86,      'TYPE',  'TheAttributes',       'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1114, 86,      'TYPE',  'TheAttributes',       'BINARY',       NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1115, 86,      'TYPE',  'TheAttributes',       'NOMINAL',          NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1116, 86,      'TYPE',  'SampleSize',          'NUMERIC',          NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1117, 86,      'TYPE',  'PopDim',              'NUMERIC',          NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1118, 86,      'TYPE',  'StepNum',             'NUMERIC',          NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1119, 86,      'TYPE',  'ProbMut',             'NUMERIC',          NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1120, 86,      'TYPE',  'ProbCross',           'NUMERIC',          NULL, NULL);

INSERT INTO op_constr_t VALUES (
  1121, 86, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);

-- conditions still missing

INSERT INTO op_assert_t VALUES (
  1122, 86, 'PROJ', 'TheOutputConcept', 'TheInputConcept', NULL, NULL); 
-- output is proj of input

-- assertions for estimation of statistics:
INSERT INTO op_assert_t VALUES (
  1123, 86, 'NO_CHANGE', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);

-------------------------------------------------------
INSERT INTO operator_t VALUES (87, 'SGFeatureSelection','NO','NO','NO',NULL);

-- Parameters

INSERT INTO op_params_t VALUES (
  1124, 87, 1,    1,       'TheInputConcept',  'IN',  'CON', NULL);
INSERT INTO op_params_t VALUES (
  1125, 87, 1,    NULL,    'TheAttributes',    'IN',   'BA', NULL);
INSERT INTO op_params_t VALUES (
  1126, 87, 1,    1,       'TheTargetAttribute', 'IN', 'BA', NULL);
INSERT INTO op_params_t VALUES (
  1127, 87, 1,    1,       'SampleSize',       'IN',   'V',  NULL);
INSERT INTO op_params_t VALUES (
  1128, 87, 1,    1,       'TheOutputConcept', 'OUT',  'CON', NULL);
INSERT INTO op_params_t VALUES (
  1129, 87, 1,    1,       'Threshold',        'IN',   'V',  NULL);
INSERT INTO op_params_t VALUES (
  1130, 87, 1,    1,       'PopDim',           'IN',   'V',  NULL);
INSERT INTO op_params_t VALUES (
  1131, 87, 1,    1,       'StepNum',          'IN',   'V',  NULL);
INSERT INTO op_params_t VALUES (
  1132, 87, 1,    1,       'ProbMut',          'IN',   'V',  NULL);
INSERT INTO op_params_t VALUES (
  1133, 87, 1,    1,       'ProbCross',        'IN',   'V',  NULL);

-- Constraints

INSERT INTO op_constr_t VALUES (
  1134, 87,        'IN',  'TheAttributes',       'TheInputConcept',   NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1135, 87,        'IN',  'TheTargetAttribute',  'TheInputConcept',   NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1136, 87,      'TYPE',  'TheTargetAttribute',  'NOMINAL',        NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1137, 87,      'TYPE',  'TheAttributes',       'NOMINAL',            NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1138, 87,      'TYPE',  'TheAttributes',       'NUMERIC',        NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1139, 87,      'TYPE',  'TheAttributes',       'BINARY',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1140, 87,      'TYPE',  'SampleSize',          'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1141, 87,      'TYPE',  'PopDim',              'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1142, 87,      'TYPE',  'StepNum',             'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1143, 87,      'TYPE',  'ProbMut',             'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1144, 87,      'TYPE',  'ProbCross',           'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1145, 87,      'TYPE',  'Threshold',           'NUMERIC',           NULL, NULL);

INSERT INTO op_constr_t VALUES (
  1146, 87, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);

-- conditions still missing

INSERT INTO op_assert_t VALUES (
  1147, 87, 'PROJ', 'TheOutputConcept', 'TheInputConcept', NULL, NULL); 
-- output is proj of input

-- assertions for estimation of statistics:
INSERT INTO op_assert_t VALUES (
  1148, 87, 'NO_CHANGE', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);

-------------------------------------------------------

INSERT INTO operator_t VALUES (88, 'FeatureSelectionWithSVM', 'NO', 'NO', 'NO', NULL);

INSERT INTO op_params_t VALUES (
  1149, 88, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1150, 88, 1,    1,       'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1151, 88, 1, NULL,            'TheAttributes',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1152, 88, 1,    1,               'KernelType',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  1153, 88, 1,    1,                        'C',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  1154, 88, 1,    1,                  'Epsilon',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  1155, 88, 1,    1,          'SearchDirection',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  1156, 88, 1,    1,      'PositiveTargetValue',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  1157, 88, 1,    1,                   'TheKey',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1158, 88, 1,    1,       'TheOutputConcept',   'OUT', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1159, 88, 0,    1,               'SampleSize',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  1160, 88, 0,    1,                'UseDB_SVM',  'IN',   'V', NULL);

INSERT INTO op_constr_t VALUES (
  1161, 88,        'IN',       'TheTargetAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1162, 88,        'IN',            'TheAttributes', 'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1163, 88, 'SAME_TYPE',       'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1164, 88,      'TYPE',                        'C',  'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1165, 88,      'TYPE',                  'Epsilon',  'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1166, 88,      'TYPE',               'SampleSize',  'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1167, 88,        'GE',                        'C',          0,           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1168, 88,        'GE',                  'Epsilon',          0,           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1169, 88,        'GE',               'SampleSize',          0,           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1170, 88,    'ONE_OF',               'KernelType',   'dot polynomial neural radial anova', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1171, 88,    'ONE_OF',          'SearchDirection',   'backward forward', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1172, 88,    'ONE_OF',                'UseDB_SVM',      'true false',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1173, 88,        'IN',                   'TheKey', 'TheInputConcept',    NULL, NULL);

INSERT INTO op_constr_t VALUES (
  1174, 88, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);

-- no conditions

INSERT INTO op_assert_t VALUES (
  1175, 88, 'PROJ', 'TheOutputConcept', 'TheInputConcept', NULL, NULL);
-- output is proj of input

-- assertions for estimation of statistics:
INSERT INTO op_assert_t VALUES (
  1176, 88, 'NO_CHANGE', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);

-------------------------------------------------------

INSERT INTO operator_t VALUES (89, 'SupportVectorMachineForClassification', 'YES', 'NO', 'NO', NULL);

INSERT INTO op_params_t VALUES (
  1177, 89, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1178, 89, 1,    1,       'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1179, 89, 1, NULL,  'ThePredictingAttributes',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1180, 89, 1,    1,               'KernelType',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  1181, 89, 0,    1,               'SampleSize',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  1182, 89, 1,    1,                        'C',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  1183, 89, 1,    1,                  'Epsilon',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  1184, 89, 1,    1,       'TheOutputAttribute', 'OUT',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1185, 89, 1,    1,      'PositiveTargetValue',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  1186, 89, 0,    1,                'UseDB_SVM',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  1187, 89, 0,    1,                   'TheKey',  'IN',  'BA', NULL);

INSERT INTO op_constr_t VALUES (
  1188, 89, 'IS_LOOPED',  'TheTargetAttribute',      NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1189, 89, 'IS_LOOPED',  'ThePredictingAttributes', NULL, NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1190, 89, 'IS_LOOPED',         'KernelType',       NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1191, 89, 'IS_LOOPED',         'SampleSize',       NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1192, 89, 'IS_LOOPED',                  'C',       NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1193, 89, 'IS_LOOPED',            'Epsilon',       NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1194, 89, 'IS_LOOPED', 'TheOutputAttribute',       NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1195, 89, 'IS_LOOPED', 'PositiveTargetValue',      NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1196, 89, 'IS_LOOPED',         'UseDB_SVM',        NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1197, 89, 'IS_LOOPED',            'TheKey',        NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1198, 89,        'IN',       'TheTargetAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1199, 89,        'IN',  'ThePredictingAttributes', 'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1200, 89,        'IN',       'TheOutputAttribute', 'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1201, 89, 'SAME_TYPE',       'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1202, 89,      'TYPE',  'ThePredictingAttributes',  'NOMINAL',            NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1203, 89,      'TYPE',  'ThePredictingAttributes',  'BINARY',            NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1204, 89,      'TYPE',  'ThePredictingAttributes',  'NUMERIC',            NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1205, 89,      'TYPE',               'SampleSize',  'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1206, 89,      'TYPE',                        'C',  'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1207, 89,      'TYPE',                  'Epsilon',  'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1208, 89,        'GE',               'SampleSize',          0,           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1209, 89,        'GE',                        'C',          0,           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1210, 89,        'GE',                  'Epsilon',          0,           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1211, 89,    'ONE_OF',               'KernelType',
    'dot polynomial neural radial anova', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1212, 89,        'IN',                   'TheKey', 'TheInputConcept',    NULL, NULL);

INSERT INTO op_cond_t VALUES (
  1213, 89, 'HAS_NULLS',          'TheTargetAttribute', NULL, NULL, NULL);
INSERT INTO op_cond_t VALUES (
  1214, 89, 'HAS_VALUES',         'TheTargetAttribute', NULL, NULL, NULL);
INSERT INTO op_cond_t VALUES (
  1215, 89, 'NOT_NULL',      'ThePredictingAttributes', NULL, NULL, NULL);

INSERT INTO op_assert_t VALUES (
  1216, 89, 'NOT_NULL', 'TheOutputAttribute',      NULL, NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1217, 89, 'NOT_NULL', 'ThePredictingAttributes', NULL, NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1218, 89, 'VL_FROM',  'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
  
-------------------------------------------------------
INSERT INTO operator_t VALUES (90, 'GenericFeatureConstruction', 'YES', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  1219, 90, 1,    1,           'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1220, 90, 1,    1,        'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1221, 90, 1,    1,                'SQL_String',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  1222, 90, 1,    1,        'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO op_constr_t VALUES (
  1223, 90,         'IN', 'TheTargetAttribute',  'TheInputConcept',     NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1224, 90,         'IN', 'TheOutputAttribute',  'TheInputConcept',     NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1225, 90,  'SAME_TYPE', 'TheOutputAttribute',  'TheTargetAttribute',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1226, 90, 'IS_LOOPED',  'TheTargetAttribute',  NULL,                  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1227, 90, 'IS_LOOPED',  'SQL_String',          NULL,                  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1228, 90, 'IS_LOOPED',  'TheOutputAttribute',  NULL,                  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1229, 90,      'TYPE',  'SQL_String',          'NOMINAL',             NULL, NULL);

-- no conditions

INSERT INTO op_assert_t VALUES (
  1230, 90, 'MV_FROM',   'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
  
-------------------------------------------------------
INSERT INTO operator_t VALUES (91, 'UnionByKey', 'NO', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  1231,	91,	2,	NULL,	'TheConcepts',		'IN',	'CON',	NULL);
INSERT INTO op_params_t VALUES (
  1232,	91,	2,	NULL,	'TheKeys',		'IN',	'BA',	NULL);
INSERT INTO op_params_t VALUES (
  1233,	91,	0,	NULL,	'MapInput',		'IN',	'FEA',	NULL);
INSERT INTO op_params_t VALUES (
  1234,	91,	0,	NULL,	'MapOutput',		'OUT',	'FEA',	NULL);
INSERT INTO op_params_t VALUES (
  1235,	91,	1,	1,	'TheOutputConcept',	'OUT',	'CON',	NULL);

INSERT INTO op_constr_t VALUES (
  1236, 91,   'IN',       'TheKeys',    'TheConcepts',      NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1237, 91,   'IN',       'MapInput',   'TheConcepts',      NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1238, 91,'COORD', 'MapInput',   'MapOutput',        NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1239, 91,'COORD', 'TheKeys',  'TheConcepts',        NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1240, 91, 'ALL_EXCEPT',   'TheKeys',   'TheOutputConcept',	 NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1241, 91, 'ALL_EXCEPT',   'MapInput',  'TheOutputConcept',	 NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1242, 91, 'MATCHBYCON',   'TheKeys',   NULL,	 NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1243, 91, 'RENAME_OUT',  'MapInput',  'MapOutput',	 NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1244, 91, 'NO_COMMON',  'TheConcepts',  NULL,	 NULL, NULL);

-- no conditions
 
INSERT INTO op_assert_t VALUES (
  1245, 91, 'PROJ',     'TheConcepts', 'TheOutputConcept', NULL, NULL); 
-- TheConcepts are projs of output

INSERT INTO op_assert_t VALUES (
  1246, 91, 'MM_UNCH', 'TheConcepts', 'TheOutputConcept', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1247, 91, 'VL_UNCH', 'TheConcepts', 'TheOutputConcept', NULL, NULL);
  
-------------------------------------------------------
INSERT INTO operator_t VALUES (92, 'TimeIntervalManualDiscretization', 'NO', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  1248,	92,	1,	1,	'TheInputConcept',	'IN',	'CON',	NULL);
INSERT INTO op_params_t VALUES (
  1249,	92,	1,	1,	'TheTargetAttribute',	'IN',	'BA',	NULL);
INSERT INTO op_params_t VALUES (
  1250,	92,	1,	NULL,	'IntervalStart',	'IN',	'V',	NULL);
INSERT INTO op_params_t VALUES (
  1251,	92,	1,	NULL,	'IntervalEnd',		'IN',	'V',	NULL);
INSERT INTO op_params_t VALUES (
  1252,	92,	1,	NULL,	'MapTo',		'IN',	'V',	NULL);
INSERT INTO op_params_t VALUES (
  1253,	92,	1,	NULL,	'StartIncExc',		'IN',	'V',	NULL);
INSERT INTO op_params_t VALUES (
  1254,	92,	1,	NULL,	'EndIncExc',		'IN',	'V',	NULL);
INSERT INTO op_params_t VALUES (
  1255,	92,	1,	1,	'DefaultValue',		'IN',	'V',	NULL);
INSERT INTO op_params_t VALUES (
  1256,	92,	1,	1,	'TimeFormat',		'IN',	'V',	NULL);
INSERT INTO op_params_t VALUES (
  1257,	92,	1,	1,	'TheOutputAttribute',	'OUT',	'BA',	NULL);

INSERT INTO op_constr_t VALUES (
  1258, 92,   'IN',     'TheTargetAttribute', 'TheInputConcept',      NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1259, 92,   'IN',     'TheOutputAttribute', 'TheInputConcept',      NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1260, 92,   'TYPE',   'TheTargetAttribute',  'TIME',                NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1261, 92,   'TYPE',	'IntervalStart',    'TIME',                NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1262, 92,   'TYPE',	'IntervalEnd',      'TIME',                NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1263, 92,   'TYPE',	'MapTo',            'NOMINAL',             NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1264, 92,   'TYPE',	'StartIncExc',      'NOMINAL',          NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1265, 92,   'TYPE',	'EndIncExc',        'NOMINAL',          NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1266, 92, 'COORD', 'IntervalStart',    'IntervalEnd',         NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1267, 92, 'COORD', 'IntervalEnd',      'StartIncExc',         NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1268, 92, 'COORD', 'StartIncExc',      'EndIncExc',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1269, 92, 'COORD', 'EndIncExc',        'MapTo',               NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1270, 92,   'TYPE',	'DefaultValue',     'NOMINAL',             NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1271, 92,   'TYPE',	'TimeFormat',       'NOMINAL',             NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1272, 92,   'TYPE',   'TheOutputAttribute',  'NOMINAL',          NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1273, 92,   'ONE_OF', 'StartIncExc',         'I E',                 NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1274, 92,   'ONE_OF', 'EndIncExc',           'I E',                 NULL, NULL);

-- conditions still missing

INSERT INTO op_assert_t VALUES (
  1275, 92, 'VL_BY_PAR', 'TheOutputAttribute', 'MapTo', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1276, 92, 'VL_ADD', 'TheOutputAttribute', 'DefaultValue', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1277, 92, 'MV_FROM', 'TheTargetAttribute', 'TheOutputAttribute',  NULL, NULL);
  
-------------------------------------------------------
INSERT INTO operator_t VALUES (93, 'NumericalIntervalManualDiscretization', 'NO', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  1278,	93,	1,	1,	'TheInputConcept',	'IN',	'CON',	NULL);
INSERT INTO op_params_t VALUES (
  1279,	93,	1,	1,	'TheTargetAttribute',	'IN',	'BA',	NULL);
INSERT INTO op_params_t VALUES (
  1280,	93,	1,	NULL,	'IntervalStart',	'IN',	'V',	NULL);
INSERT INTO op_params_t VALUES (
  1281,	93,	1,	NULL,	'IntervalEnd',		'IN',	'V',	NULL);
INSERT INTO op_params_t VALUES (
  1282,	93,	1,	NULL,	'MapTo',		'IN',	'V',	NULL);
INSERT INTO op_params_t VALUES (
  1283,	93,	1,	NULL,	'StartIncExc',		'IN',	'V',	NULL);
INSERT INTO op_params_t VALUES (
  1284,	93,	1,	NULL,	'EndIncExc',		'IN',	'V',	NULL);
INSERT INTO op_params_t VALUES (
  1285,	93,	1,	1,	'DefaultValue',		'IN',	'V',	NULL);
INSERT INTO op_params_t VALUES (
  1286,	93,	1,	1,	'TheOutputAttribute',	'OUT',	'BA',	NULL);

INSERT INTO op_constr_t VALUES (
  1287, 93,   'IN',     'TheTargetAttribute', 'TheInputConcept',      NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1288, 93,   'IN',     'TheOutputAttribute', 'TheInputConcept',      NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1289, 93,   'ONE_OF', 'StartIncExc',         'I E',                 NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1290, 93,   'ONE_OF', 'EndIncExc',           'I E',                 NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1291, 93,   'TYPE',   'TheTargetAttribute',  'NUMERIC',             NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1292, 93,   'TYPE',	'IntervalStart',    'NOMINAL',             NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1293, 93,   'TYPE',	'IntervalEnd',      'NOMINAL',             NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1294, 93,   'TYPE',	'MapTo',            'NOMINAL',             NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1295, 93,   'TYPE',	'StartIncExc',      'NOMINAL',          NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1296, 93,   'TYPE',	'EndIncExc',        'NOMINAL',          NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1297, 93, 'COORD', 'IntervalStart',    'IntervalEnd',         NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1298, 93, 'COORD', 'IntervalEnd',      'StartIncExc',         NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1299, 93, 'COORD', 'StartIncExc',      'EndIncExc',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1300, 93, 'COORD', 'EndIncExc',        'MapTo',               NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1301, 93,   'TYPE',	'DefaultValue',     'NOMINAL',             NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1302, 93,   'TYPE',   'TheOutputAttribute',  'NOMINAL',          NULL, NULL);

-- conditions still missing
INSERT INTO op_assert_t VALUES (
  1303, 93, 'VL_BY_PAR', 'TheOutputAttribute', 'MapTo', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1304, 93, 'VL_ADD', 'TheOutputAttribute', 'DefaultValue', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1305, 93, 'MV_FROM',   'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);

----------------------------------------------------------------------
---------------------- M4 Operators from UEP -------------------------
----------------------------------------------------------------------

-------------------------------------------------------
-- WP16: 1.1.1
INSERT INTO operator_t VALUES (95, 'EquidistantDiscretizationGivenWidth', 'YES', 'NO', 'YES', 
NULL);

INSERT INTO op_params_t VALUES (
  1306, 95, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1307, 95, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1308, 95, 0,   1,  'StartPoint',          'IN',  'V',  NULL);   
INSERT INTO op_params_t VALUES (
  1309, 95, 0,   1,  'EndPoint',            'IN',  'V',  NULL);   
INSERT INTO op_params_t VALUES (  
  1310, 95, 1,   1,  'IntervalWidth',       'IN',  'V',  NULL);  
INSERT INTO op_params_t VALUES (  
  1311, 95, 1,   1,   'ClosedTo',           'IN',  'V',  NULL);  
INSERT INTO op_params_t VALUES (
  1312, 95, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO op_constr_t VALUES (
  1313, 95, 'IN',        'TheTargetAttribute', 'TheInputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1314, 95, 'IN',        'TheOutputAttribute', 'TheInputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1315, 95, 'TYPE',      'TheTargetAttribute', 'NUMERIC',         NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1316, 95, 'ONE_OF',    'ClosedTo',           'left right',      NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1317, 95, 'TYPE',      'IntervalWidth',      'NUMERIC',         NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1318, 95, 'GT',        'IntervalWidth',      0,                 NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1319, 95, 'TYPE',      'StartPoint',         'NUMERIC',         NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1320, 95, 'TYPE',      'EndPoint',           'NUMERIC',         NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1321, 95, 'GT',        'EndPoint',           'StartPoint',      NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1322, 95, 'TYPE',      'TheOutputAttribute', 'NOMINAL',      NULL, NULL);

INSERT INTO op_assert_t VALUES (
  1323, 95, 'MV_FROM',   'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
  
INSERT INTO docu_t VALUES (
  1324, 95, 'OPERATOR', 
'This operator divides the range of TheTargetAttribute into intervals with given width IntWidth starting at StartPoint and ending at EndPoint. The first and the last interval cover also the out of range values. Values of TheOutputAattribute can be specified in Labels ');


-------------------------------------------------------
-- WP16: 1.1.2
INSERT INTO operator_t VALUES (96, 'EquidistantDiscretizationGivenNoOfIntervals', 'YES', 'NO', 'YES', 
NULL);

INSERT INTO op_params_t VALUES (
  1325, 96, 1,   1,  'TheInputConcept',    'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1326, 96, 1,   1,  'TheTargetAttribute', 'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (  
  1327, 96, 1,   1,  'NoOfIntervals',      'IN',   'V', NULL);  
INSERT INTO op_params_t VALUES (  
  1328, 96, 1,   1,  'ClosedTo',           'IN',   'V', NULL);  
INSERT INTO op_params_t VALUES (
  1329, 96, 0, NULL, 'Labels',             'IN',   'V', NULL);    
INSERT INTO op_params_t VALUES (
  1330, 96, 1,   1,  'TheOutputAttribute', 'OUT', 'BA', NULL);

INSERT INTO op_constr_t VALUES (
  1331, 96, 'IN',   'TheTargetAttribute',  'TheInputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1332, 96, 'IN',   'TheOutputAttribute',  'TheInputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1333, 96, 'TYPE', 'TheTargetAttribute',  'NUMERIC',         NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1334, 96,  'ONE_OF',  'ClosedTo',        'left right',      NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1335, 96, 'TYPE', 'NoOfIntervals',       'NUMERIC',         NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1336, 96, 'GT', 'NoOfIntervals',         1,                 NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1337, 96, 'TYPE', 'Labels',              'NOMINAL',      NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1338, 96, 'TYPE', 'TheOutputAttribute',  'NOMINAL',      NULL, NULL);

INSERT INTO op_assert_t VALUES (
  1339, 96, 'VL_BY_PAR', 'TheOutputAttribute', 'Labels', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1340, 96, 'VL_BY_SYM', 'TheOutputAttribute', 'NoOfIntervals', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1341, 96, 'MV_FROM',   'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
  
INSERT INTO docu_t VALUES (
  1342, 96, 'OPERATOR', 
'This operator divides the range of TheTargetAttribute into given number of intervals NoOfIntervals with the same width. The first and the last interval cover also the out of range values. Values of TheOutputAattribute can be specified in Labels.');


-------------------------------------------------------
-- WP16: 1.1.3
INSERT INTO operator_t VALUES (97, 'EquifrequentDiscretizationGivenCardinality', 'YES', 'NO', 'YES', 
NULL);

INSERT INTO op_params_t VALUES (
  1343, 97, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1344, 97, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1345, 97, 1,   1,  'Cardinality', 'IN',  'V',  NULL);   
INSERT INTO op_params_t VALUES (  
  1346, 97, 1,   1,  'CardinalityType', 'IN',  'V',  NULL);  
INSERT INTO op_params_t VALUES (  
  1347, 97, 1,   1,   'ClosedTo', 'IN',  'V',  NULL);  
INSERT INTO op_params_t VALUES (
  1348, 97, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO op_constr_t VALUES (
  1349, 97, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1350, 97, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1351, 97, 'TYPE', 'TheTargetAttribute', 'NUMERIC', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1352, 97,  'ONE_OF',  'ClosedTo', 'left right',
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1353, 97, 'TYPE', 'Cardinality', 'NUMERIC', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1354, 97, 'GT', 'Cardinality', 0, 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1355, 97, 'ONE_OF', 'CardinalityType', 'absolute relative', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1356, 97, 'TYPE', 'TheOutputAttribute', 'NOMINAL', 
NULL, NULL);

INSERT INTO op_cond_t VALUES (
  1357, 97, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);

INSERT INTO op_assert_t VALUES (
  1358, 97, 'MV_FROM',   'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);

INSERT INTO docu_t VALUES (
  1359, 97, 'OPERATOR', 
'This operator divides the range of TheTargetAttribute into intervals with given cardinality Cardinality (number of examples with values within the interval). The first and the last interval cover also the out of range values. Values of TheOutputAattribute can be specified in Labels (this makes sense only if CardinalityType is relative.');


-------------------------------------------------------
-- WP16: 1.1.4
INSERT INTO operator_t VALUES (98, 'EquifrequentDiscretizationGivenNoOfIntervals', 'YES', 'NO', 'YES', 
NULL);

INSERT INTO op_params_t VALUES (
  1360, 98, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1361, 98, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (  
  1362, 98, 1,   1,  'NoOfIntervals', 'IN',  'V',  NULL);  
INSERT INTO op_params_t VALUES (  
  1363, 98, 1,   1,   'ClosedTo', 'IN',  'V',  NULL);  
INSERT INTO op_params_t VALUES (
  1364, 98, 0,   NULL,   'Labels', 'IN',  'V',  NULL);    
INSERT INTO op_params_t VALUES (
  1365, 98, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);
 
INSERT INTO op_constr_t VALUES (
  1366, 98, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1367, 98, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1368, 98, 'TYPE', 'TheTargetAttribute', 'NUMERIC', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1369, 98,  'ONE_OF',  'ClosedTo', 'left right',
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1370, 98, 'TYPE', 'NoOfIntervals', 'NUMERIC', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1371, 98, 'GT', 'NoOfIntervals', 1, 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1372, 98, 'TYPE', 'Labels', 'NOMINAL', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1373, 98, 'TYPE', 'TheOutputAttribute', 'NOMINAL', 
NULL, NULL);

INSERT INTO op_cond_t VALUES (
  1374, 98, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);

INSERT INTO op_assert_t VALUES (
  1375, 98, 'VL_BY_PAR', 'TheOutputAttribute', 'Labels', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1376, 98, 'VL_BY_SYM', 'TheOutputAttribute', 'NoOfIntervals', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1377, 98, 'MV_FROM',   'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
  
INSERT INTO docu_t VALUES (
  1378, 98, 'OPERATOR', 
'This operator divides the range of TheTargetAttribute into given number of intervals NoOfIntervals. The intervals have the same cardinality (number of examples with values within the interval). The first and the last interval cover also the out of range values. Values of TheOutputAattribute can be specified in Labels.');


-------------------------------------------------------
-- WP16: 1.1.5
INSERT INTO operator_t VALUES (99, 'UserDefinedDiscretization', 'NO', 'NO', 'YES', 
NULL);

INSERT INTO op_params_t VALUES (
  1379, 99, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1380, 99, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (  
  1381, 99, 1,   1,   'ClosedTo', 'IN',  'V',  NULL);  
INSERT INTO op_params_t VALUES (  
  1382, 99, 1,   NULL,   'TheCutpoints', 'IN',  'V',  NULL);    
INSERT INTO op_params_t VALUES (
  1383, 99, 0,   NULL,   'Labels', 'IN',  'V',  NULL);    
INSERT INTO op_params_t VALUES (
  1384, 99, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);
 
INSERT INTO op_constr_t VALUES (
  1385, 99, 'IN',   'TheTargetAttribute',  'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1386, 99, 'IN',   'TheOutputAttribute',  'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1387, 99, 'TYPE', 'TheTargetAttribute', 'NUMERIC',             NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1388, 99,  'ONE_OF',  'ClosedTo', 'left right',                NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1389, 99, 'TYPE', 'TheCutpoints', 'NUMERIC',                   NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1390, 99, 'ORDERED', 'TheCutpoints', 'INC',                    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1391, 99, 'COORD', 'TheCutpoints',    'Labels',          NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1392, 99, 'TYPE', 'Labels', 'NOMINAL',                      NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1393, 99, 'TYPE', 'TheOutputAttribute', 'NOMINAL',          NULL, NULL);

INSERT INTO op_assert_t VALUES (
  1394, 99, 'VL_BY_PAR', 'TheOutputAttribute', 'Labels', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1395, 99, 'MV_FROM',   'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
  
INSERT INTO docu_t VALUES (
  1396, 99, 'OPERATOR', 
'This operator divides the range of TheTargetAttribute into intervals according to user given cutpoints TheCutpoints. Values of TheOutputAttribute can be specified in Labels.');


-------------------------------------------------------
-- WP16: 1.2.1
INSERT INTO operator_t VALUES (100, 'ImplicitErrorBasedDiscretization', 'YES', 'NO', 'NO', 
NULL);

INSERT INTO op_params_t VALUES (
  1397, 100, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1398, 100, 1,   1,  'TheClassAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1399, 100, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);  
INSERT INTO op_params_t VALUES (  
  1400, 100, 1,   1,   'FullMerge', 'IN',  'V',  NULL);      
INSERT INTO op_params_t VALUES (  
  1401, 100, 1,   1,   'ClosedTo', 'IN',  'V',  NULL);  
INSERT INTO op_params_t VALUES (  
  1402, 100, 0,   1,   'SampleSize', 'IN',  'V',  NULL);  
INSERT INTO op_params_t VALUES (
  1403, 100, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);
 
INSERT INTO op_constr_t VALUES (
  1404, 100, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1405, 100, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1406, 100, 'TYPE', 'TheTargetAttribute', 'NUMERIC', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1407, 100, 'IN',   'TheClassAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1408, 100, 'TYPE', 'TheClassAttribute', 'NOMINAL', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1409, 100,  'ONE_OF',  'FullMerge', 'yes no',
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1410, 100,  'ONE_OF',  'ClosedTo', 'left right',
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1411, 100, 'TYPE', 'SampleSize', 'NUMERIC', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1412, 100, 'GT', 'SampleSize', 0, 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1413, 100, 'TYPE', 'TheOutputAttribute', 'NOMINAL', 
NULL, NULL);

INSERT INTO op_cond_t VALUES (
  1414, 100, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);
INSERT INTO op_cond_t VALUES (
  1415, 100, 'NOT_NULL', 'TheClassAttribute', 
NULL, NULL, NULL);

INSERT INTO op_assert_t VALUES (
  1416, 100, 'MV_FROM',   'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);

INSERT INTO docu_t VALUES (
  1417, 100, 'OPERATOR', 
'This operator divides the range of TheTargetAttribute into intervals by merging subsequent values with the same majority class (or classes) given in TheClassAttribute. The resulting intervals  minimize the classification error. If FullMerge is set to yes, then an interval with two or more majority classes is merged with its neighbour, if both intervals share the same majority class.');



-------------------------------------------------------
-- WP16: 2.1.1
INSERT INTO operator_t VALUES (101, 'GroupingGivenMinCardinality', 'YES', 'NO', 'YES', 
NULL);

INSERT INTO op_params_t VALUES (
  1418, 101, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1419, 101, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1420, 101, 1,   1,  'MinCardinality', 'IN',  'V',  NULL);   
INSERT INTO op_params_t VALUES (  
  1421, 101, 1,   1,  'MinCardinalityType', 'IN',  'V',  NULL);  
INSERT INTO op_params_t VALUES (
  1422, 101, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO op_constr_t VALUES (
  1423, 101, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1424, 101, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1425, 101, 'TYPE', 'TheTargetAttribute', 'NOMINAL', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1426, 101, 'TYPE', 'MinCardinality', 'NUMERIC', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1427, 101, 'GT', 'MinCardinality', 0, 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1428, 101, 'ONE_OF', 'MinCardinalityType', 'absolute relative', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1429, 101, 'TYPE', 'TheOutputAttribute', 'NOMINAL', 
NULL, NULL);

INSERT INTO op_cond_t VALUES (
  1430, 101, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);

INSERT INTO op_assert_t VALUES (
  1431, 101, 'MV_FROM',   'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);

INSERT INTO docu_t VALUES (
  1432, 101, 'OPERATOR', 
'This operator groups values of TheTargetAttribute by iteratively merging in each step two groups with the lowest frequencies until all groups have the cardinality (number of examples with values within the interval) at least MinCardinality.');


-------------------------------------------------------
-- WP16: 2.1.2
INSERT INTO operator_t VALUES (102, 'GroupingGivenNoOfGroups', 'YES', 'NO', 'YES', 
NULL);

INSERT INTO op_params_t VALUES (
  1433, 102, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1434, 102, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (  
  1435, 102, 1,   1,  'NoOfGroups', 'IN',  'V',  NULL);  
INSERT INTO op_params_t VALUES (
  1436, 102, 0,   NULL,   'Labels', 'IN',  'V',  NULL);       
INSERT INTO op_params_t VALUES (
  1437, 102, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO op_constr_t VALUES (
  1438, 102, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1439, 102, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1440, 102, 'TYPE', 'TheTargetAttribute', 'NOMINAL', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1441, 102, 'TYPE', 'NoOfGroups', 'NUMERIC', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1442, 102, 'GT', 'NoOfGroups', 1, 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1443, 102, 'TYPE', 'Labels', 'NOMINAL', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1444, 102, 'TYPE', 'TheOutputAttribute', 'NOMINAL', 
NULL, NULL);

INSERT INTO op_cond_t VALUES (
  1445, 102, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);

INSERT INTO op_assert_t VALUES (
  1446, 102, 'VL_BY_PAR', 'TheOutputAttribute', 'Labels', NULL, NULL);
  
INSERT INTO op_assert_t VALUES (
  1447, 102, 'MV_FROM',   'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
  
INSERT INTO docu_t VALUES (
  1448, 102, 'OPERATOR', 
'This operator groups values of TheTargetAttribute by iteratively  merging in each step two groups with the lowest frequencies until the number of groups NoOfGroups is reached. Values of TheOutputAttribute can be specified in Labels.');


-------------------------------------------------------
-- WP16: 2.1.3
INSERT INTO operator_t VALUES (103, 'UserDefinedGrouping', 'NO', 'NO', 'YES', 
NULL);

INSERT INTO op_params_t VALUES (
  1449, 103, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1450, 103, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (  
  1451, 103, 1,   NULL,  'TheGroupings', 'IN',  'V',  NULL);  
INSERT INTO op_params_t VALUES (
  1452, 103, 0,   NULL,   'Labels', 'IN',  'V',  NULL);       
INSERT INTO op_params_t VALUES (
  1453, 103, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO op_constr_t VALUES (
  1454, 103, 'IN',   'TheTargetAttribute',  'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1455, 103, 'IN',   'TheOutputAttribute',  'TheInputConcept',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1456, 103, 'TYPE', 'TheTargetAttribute', 'NOMINAL', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1457, 103, 'TYPE', 'TheGroupings', 'NOMINAL', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1458, 103, 'TYPE', 'Labels', 'NOMINAL', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1459, 103, 'COORD', 'TheGroupings',    'Labels',    NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1460, 103, 'TYPE', 'TheOutputAttribute', 'NOMINAL',    NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1461, 103, 'USE_VALS', 'TheGroupings', 'TheTargetAttribute', NULL, NULL);

-- no conditions 

INSERT INTO op_assert_t VALUES (
  1462, 103, 'VL_BY_PAR', 'TheOutputAttribute', 'Labels', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1463, 103, 'MV_FROM',   'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
  
INSERT INTO docu_t VALUES (
  1464, 103, 'OPERATOR', 
'This operator creates groups of TheTargetAttribute according to specifications given by the user in TheGroupings. Values not specified for grouping retain their original values. Values of TheOutputAttribute can be specified in Labels.');


-------------------------------------------------------
-- WP16: 2.1.4
INSERT INTO operator_t VALUES (104, 'UserDefinedGroupingWithDefaultValue', 'YES', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  1465, 104, 1,   1,     'TheInputConcept',  'IN', 'CON',  NULL);
INSERT INTO op_params_t VALUES (
  1466, 104, 1,   1,  'TheTargetAttribute',  'IN',  'BA',  NULL);
INSERT INTO op_params_t VALUES (  
  1467, 104, 0,   1,             'Default',  'IN',   'V',  NULL);    
INSERT INTO op_params_t VALUES (  
  1468, 104, 1,   NULL,     'TheGroupings',  'IN',   'V',  NULL);  
INSERT INTO op_params_t VALUES (
  1469, 104, 0,   NULL,           'Labels',  'IN',   'V',  NULL);       
INSERT INTO op_params_t VALUES (
  1470, 104, 1,   1,  'TheOutputAttribute', 'OUT',  'BA',  NULL);

INSERT INTO op_constr_t VALUES (
  1471, 104, 'IN',   'TheTargetAttribute',  'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1472, 104, 'IN',   'TheOutputAttribute',  'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1473, 104, 'TYPE', 'TheTargetAttribute',  'NOMINAL',       NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1474, 104, 'TYPE', 'Default',             'NOMINAL',       NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1475, 104, 'TYPE', 'TheGroupings',        'NOMINAL',       NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1476, 104, 'TYPE', 'Labels',              'NOMINAL',       NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1477, 104, 'COORD', 'TheGroupings', 'Labels',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1478, 104, 'TYPE', 'TheOutputAttribute',  'NOMINAL',       NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1479, 104, 'USE_VALS', 'TheGroupings', 'TheTargetAttribute', NULL, NULL);

-- no conditions 

INSERT INTO op_assert_t VALUES (
  1480, 104, 'VL_BY_PAR', 'TheOutputAttribute', 'Labels', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1481, 104, 'VL_ADD', 'TheOutputAttribute', 'Default', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1482, 104, 'MV_FROM',   'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
  
INSERT INTO docu_t VALUES (
  1483, 104, 'OPERATOR', 
'This operator creates groups of TheTargetAttribute according to specifications given by the user in TheGroupings. Values not specified for grouping are grouped into default group Default. Values of TheOutputAttribute can be specified in Labels.');


-------------------------------------------------------
-- WP16: 1.2.2
INSERT INTO operator_t VALUES (105, 'ErrorBasedDiscretizationGivenMinCardinality', 'YES', 'NO', 'NO', NULL);

INSERT INTO op_params_t VALUES (
  1484, 105, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1485, 105, 1,   1,  'TheClassAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1486, 105, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);  
INSERT INTO op_params_t VALUES (
  1487, 105, 1,   1,  'MinCardinality', 'IN',  'V',  NULL);   
INSERT INTO op_params_t VALUES (  
  1488, 105, 1,   1,  'MinCardinalityType', 'IN',  'V',  NULL);        
INSERT INTO op_params_t VALUES (  
  1489, 105, 1,   1,   'ClosedTo', 'IN',  'V',  NULL);  
INSERT INTO op_params_t VALUES (  
  1490, 105, 0,   1,   'SampleSize', 'IN',  'V',  NULL);  
INSERT INTO op_params_t VALUES (
  1491, 105, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);
 
INSERT INTO op_constr_t VALUES (
  1492, 105, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1493, 105, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1494, 105, 'TYPE', 'TheTargetAttribute', 'NUMERIC', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1495, 105, 'IN',   'TheClassAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1496, 105, 'TYPE', 'TheClassAttribute', 'NOMINAL', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1497, 105,  'ONE_OF',  'ClosedTo', 'left right',
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1498, 105, 'TYPE', 'MinCardinality', 'NUMERIC', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1499, 105, 'GT', 'MinCardinality', 0, 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1500, 105, 'ONE_OF', 'MinCardinalityType', 'absolute relative', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1501, 105, 'TYPE', 'SampleSize', 'NUMERIC', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1502, 105, 'GT', 'SampleSize', 0, 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1503, 105, 'TYPE', 'TheOutputAttribute', 'NOMINAL', 
NULL, NULL);

-- If CardinalityType is 'relative', then Cardinality < 0.5

INSERT INTO op_cond_t VALUES (
  1504, 105, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);
INSERT INTO op_cond_t VALUES (
  1505, 105, 'NOT_NULL', 'TheClassAttribute', 
NULL, NULL, NULL);
-- If CardinalityType is 'absolute', then Cardinality < TheTargetAttribute.allNumber/2

INSERT INTO op_assert_t VALUES (
  1506, 105, 'MV_FROM',   'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
  
INSERT INTO docu_t VALUES (
  1507, 105, 'OPERATOR', 
'This operator divides the range of TheTargetAttribute into intervals with cardinality greater or equal to MinCardinality. The numeric attribute is divided into intervals with respect to TheClassAttribute, but unlike the implicit discretization, intervals with single majority class are further merged if they do not have the required cardinality. This will increase the classification error.');


-------------------------------------------------------
-- WP16: 1.2.3
INSERT INTO operator_t VALUES (106, 'ErrorBasedDiscretizationGivenNoOfIntervals', 'YES', 'NO', 'NO', NULL);

INSERT INTO op_params_t VALUES (
  1508, 106, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1509, 106, 1,   1,  'TheClassAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1510, 106, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);  
INSERT INTO op_params_t VALUES (  
  1511, 106, 1,   1,  'NoOfIntervals', 'IN',  'V',  NULL);       
INSERT INTO op_params_t VALUES (  
  1512, 106, 1,   1,   'ClosedTo', 'IN',  'V',  NULL);  
INSERT INTO op_params_t VALUES (  
  1513, 106, 0,   1,   'SampleSize', 'IN',  'V',  NULL);  
INSERT INTO op_params_t VALUES (
  1514, 106, 0,   NULL,   'Labels', 'IN',  'V',  NULL);      
INSERT INTO op_params_t VALUES (
  1515, 106, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);
 
INSERT INTO op_constr_t VALUES (
  1516, 106, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1517, 106, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1518, 106, 'TYPE', 'TheTargetAttribute', 'NUMERIC', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1519, 106, 'IN',   'TheClassAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1520, 106, 'TYPE', 'TheClassAttribute', 'NOMINAL', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1521, 106,  'ONE_OF',  'ClosedTo', 'left right',
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1522, 106, 'TYPE', 'NoOfIntervals', 'NUMERIC', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1523, 106, 'GT', 'NoOfIntervals', 1, 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1524, 106, 'TYPE', 'SampleSize', 'NUMERIC', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1525, 106, 'GT', 'SampleSize', 0, 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1526, 106, 'TYPE', 'Labels', 'NOMINAL', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1527, 106, 'TYPE', 'TheOutputAttribute', 'NOMINAL', 
NULL, NULL);

INSERT INTO op_cond_t VALUES (
  1528, 106, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);
INSERT INTO op_cond_t VALUES (
  1529, 106, 'NOT_NULL', 'TheClassAttribute', 
NULL, NULL, NULL);
-- INSERT INTO op_cond_t VALUES (2369, 106, 'LT', 'NoOfIntervals', TheTargetAttribute.unique, NULL, NULL);

INSERT INTO op_assert_t VALUES (
  1530, 106, 'VL_BY_PAR', 'TheOutputAttribute', 'Labels', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1531, 106, 'VL_BY_SYM', 'TheOutputAttribute', 'NoOfIntervals', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1532, 106, 'MV_FROM',   'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
  
INSERT INTO docu_t VALUES (
  1533, 106, 'OPERATOR', 
'This operator divides the range of TheTargetAttribute into at most NoOfIntervals intervals. The numeric attribute is divided into intervals with respect to TheClassAttribute, but unlike the implicit discretization, if the number of interval exceeds NoOfIntervals, intervals are further merged. This will increase the classification error. Values of TheOutputAttribute can be specified in Labels.');


-------------------------------------------------------
-- WP16: 2.2.1
INSERT INTO operator_t VALUES (107, 'ImplicitErrorBasedGrouping', 'YES', 'NO', 'NO', 
NULL);

INSERT INTO op_params_t VALUES (
  1534, 107, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1535, 107, 1,   1,  'TheClassAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1536, 107, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);  
INSERT INTO op_params_t VALUES (  
  1537, 107, 1,   1,   'FullMerge', 'IN',  'V',  NULL);      
INSERT INTO op_params_t VALUES (  
  1538, 107, 0,   1,   'SampleSize', 'IN',  'V',  NULL);  
INSERT INTO op_params_t VALUES (
  1539, 107, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);
 
INSERT INTO op_constr_t VALUES (
  1540, 107, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1541, 107, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1542, 107, 'TYPE', 'TheTargetAttribute', 'NOMINAL', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1543, 107, 'IN',   'TheClassAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1544, 107, 'TYPE', 'TheClassAttribute', 'NOMINAL', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1545, 107,  'ONE_OF',  'FullMerge', 'yes no',
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1546, 107, 'TYPE', 'SampleSize', 'NUMERIC', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1547, 107, 'GT', 'SampleSize', 0, 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1548, 107, 'TYPE', 'TheOutputAttribute', 'NOMINAL', 
NULL, NULL);

INSERT INTO op_cond_t VALUES (
  1549, 107, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);
INSERT INTO op_cond_t VALUES (
  1550, 107, 'NOT_NULL', 'TheClassAttribute', 
NULL, NULL, NULL);

INSERT INTO op_assert_t VALUES (
  1551, 107, 'MV_FROM',   'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
  
INSERT INTO docu_t VALUES (
  1552, 107, 'OPERATOR', 
'This operator merges the values of TheTargetAttribute into groups with the same majority class (or classes) given in TheClassAttribute. If FullMerge is set to yes, then a group with two or more majority classes is merged with a group that have the same majority class. The resulting grouping  minimize the classification error.');


-------------------------------------------------------
-- WP16: 2.2.2
INSERT INTO operator_t VALUES (108, 'ErrorBasedGroupingGivenMinCardinality', 'YES', 'NO', 'NO', 
NULL);

INSERT INTO op_params_t VALUES (
  1553, 108, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1554, 108, 1,   1,  'TheClassAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1555, 108, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);  
INSERT INTO op_params_t VALUES (
  1556, 108, 1,   1,  'MinCardinality', 'IN',  'V',  NULL);   
INSERT INTO op_params_t VALUES (  
  1557, 108, 1,   1,  'MinCardinalityType', 'IN',  'V',  NULL);        
INSERT INTO op_params_t VALUES (  
  1558, 108, 0,   1,   'SampleSize', 'IN',  'V',  NULL);  
INSERT INTO op_params_t VALUES (
  1559, 108, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);
 
INSERT INTO op_constr_t VALUES (
  1560, 108, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1561, 108, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1562, 108, 'TYPE', 'TheTargetAttribute', 'NOMINAL', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1563, 108, 'IN',   'TheClassAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1564, 108, 'TYPE', 'TheClassAttribute', 'NOMINAL', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1565, 108, 'TYPE', 'MinCardinality', 'NUMERIC', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1566, 108, 'GT', 'MinCardinality', 0, 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1567, 108, 'ONE_OF', 'MinCardinalityType', 'absolute relative', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1568, 108, 'TYPE', 'SampleSize', 'NUMERIC', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1569, 108, 'GT', 'SampleSize', 0, 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1570, 108, 'TYPE', 'TheOutputAttribute', 'NOMINAL', 
NULL, NULL);
-- If CardinalityType is 'relative', then Cardinality < 0.5

INSERT INTO op_cond_t VALUES (
  1571, 108, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);
INSERT INTO op_cond_t VALUES (
  1572, 108, 'NOT_NULL', 'TheClassAttribute', 
NULL, NULL, NULL);
-- If CardinalityType is 'absolute', then Cardinality < TheTargetAttribute.allNumber/2

INSERT INTO op_assert_t VALUES (
  1573, 108, 'MV_FROM',   'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
  
INSERT INTO docu_t VALUES (
  1574, 108, 'OPERATOR', 
'This operator merges the values of TheTargetAttribute into groups with the cardinality above given threshold MinCardinality. The grouping is performed with respect to TheClassAttribute, but unlike implicit grouping, groups with single majority class are further merged if they do not have the required cardinality. This will increase the classification error.');


-------------------------------------------------------
-- WP16: 2.2.3
INSERT INTO operator_t VALUES (109, 'ErrorBasedGroupingGivenNoOfGroups', 'YES', 'NO', 'NO', 
NULL);

INSERT INTO op_params_t VALUES (
  1575, 109, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1576, 109, 1,   1,  'TheClassAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1577, 109, 1,   1,  'TheTargetAttribute',  'IN',  'BA', NULL);  
INSERT INTO op_params_t VALUES (  
  1578, 109, 1,   1,  'NoOfGroups', 'IN',  'V',  NULL);       
INSERT INTO op_params_t VALUES (  
  1579, 109, 0,   1,   'SampleSize', 'IN',  'V',  NULL);  
INSERT INTO op_params_t VALUES (
  1580, 109, 0,   NULL,   'Labels', 'IN',  'V',  NULL);      
INSERT INTO op_params_t VALUES (
  1581, 109, 1,   1,  'TheOutputAttribute', 'OUT',  'BA', NULL);
 
INSERT INTO op_constr_t VALUES (
  1582, 109, 'IN',   'TheTargetAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1583, 109, 'IN',   'TheOutputAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1584, 109, 'TYPE', 'TheTargetAttribute', 'NOMINAL', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1585, 109, 'IN',   'TheClassAttribute',  'TheInputConcept',    
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1586, 109, 'TYPE', 'TheClassAttribute', 'NOMINAL', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1587, 109, 'TYPE', 'NoOfGroups', 'NUMERIC', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1588, 109, 'GT', 'NoOfGroups', 1, 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1589, 109, 'TYPE', 'SampleSize', 'NUMERIC', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1590, 109, 'GT', 'SampleSize', 0, 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1591, 109, 'TYPE', 'Labels', 'NOMINAL', 
NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1592, 109, 'TYPE', 'TheOutputAttribute', 'NOMINAL', 
NULL, NULL);

INSERT INTO op_cond_t VALUES (
  1593, 109, 'NOT_NULL', 'TheTargetAttribute', 
NULL, NULL, NULL);
INSERT INTO op_cond_t VALUES (
  1594, 109, 'NOT_NULL', 'TheClassAttribute', 
NULL, NULL, NULL);
-- INSERT INTO op_cond_t VALUES (2717, 109, 'LT', 'NoOfGroups', TheTargetAttribute.unique, NULL, NULL);

INSERT INTO op_assert_t VALUES (
  1595, 109, 'VL_BY_PAR', 'TheOutputAttribute', 'Labels', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1596, 109, 'VL_BY_SYM', 'TheOutputAttribute', 'NoOfGroups', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1597, 109, 'MV_FROM',   'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
  
INSERT INTO docu_t VALUES (
  1598, 109, 'OPERATOR', 
'This operator merges the values of TheTargetAttribute into at most  NoOfGropus groups. The grouping is performed with respect to TheClassAttribute, but unlike the implicit discretization, if the number of groups exceeds NoOfGroups, groups are further merged. Values of TheOutputAttribute can be specified in Labels.');



---------------------- M4 Operators from UEP--------------------------
----------------------------------------------------------------------

-------------------------------------------------------
-- WP14: 1.1
INSERT INTO operator_t VALUES (110, 'SimpleForwardFeatureSelectionGivenNoOfAttributes', 'NO', 'NO', 'YES', 
NULL);

INSERT INTO op_params_t VALUES (
  1599, 110, 1,   1,    'TheInputConcept',    'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (  
  1600, 110, 1,   1,    'NoOfAttributes',     'IN',   'V', NULL);   
INSERT INTO op_params_t VALUES (  
  1601, 110, 0,   1,    'SampleSize',         'IN',   'V', NULL);  
INSERT INTO op_params_t VALUES (
  1602, 110, 1,   NULL, 'TheAttributes',      'IN',  'BA', NULL);    
INSERT INTO op_params_t VALUES (
  1603, 110, 1,   1,    'TheClassAttribute',  'IN',  'BA', NULL);  
INSERT INTO op_params_t VALUES (
  1604, 110, 1,   1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO op_constr_t VALUES (
  1605, 110, 'IN',   'TheClassAttribute', 'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1606, 110, 'TYPE', 'TheClassAttribute', 'NOMINAL',       NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1607, 110, 'IN',   'TheAttributes',     'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1608, 110, 'TYPE', 'TheAttributes',     'NOMINAL',       NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1609, 110, 'TYPE', 'NoOfAttributes',    'NUMERIC',          NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1610, 110, 'GT',   'NoOfAttributes',    0,                  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1611, 110, 'TYPE', 'SampleSize',       'NUMERIC',           NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1612, 110, 'GT',   'SampleSize',        0,                  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1613, 110, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);

-- INSERT INTO op_cond_t VALUES (2762, 110, 'LT', 'NoOfAttributes', TheInputConcept.NoOfCollumns, NULL, NULL);
INSERT INTO op_cond_t VALUES (
  1614, 110, 'NOT_NULL', 'TheAttributes',     NULL, NULL, NULL);
INSERT INTO op_cond_t VALUES (
  1615, 110, 'NOT_NULL', 'TheClassAttribute', NULL, NULL, NULL);

INSERT INTO op_assert_t VALUES (
  1616, 110, 'PROJ', 'TheOutputConcept', 'TheInputConcept', NULL, NULL); 
-- output is proj of input

-- assertions for estimation of statistics:
INSERT INTO op_assert_t VALUES (
  1617, 110, 'NO_CHANGE', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);

INSERT INTO docu_t VALUES (
  1618, 110, 'OPERATOR', 
'This operator adds one feature a time starting from empty set until the required number of features NoOfAttributes is reached. The attributes are selected with respect to TheClassAttribute, the group optimises the information dependence criterion. Use this operator if only a small number of original attributes is to be selected. The selection is done from the set of TheAttributes, attributes not specified in this set are selected automatically.');


-------------------------------------------------------
-- WP14: 1.2
INSERT INTO operator_t VALUES (111, 'SimpleBackwardFeatureSelectionGivenNoOfAttributes', 'NO', 'NO', 'NO', 
NULL);

INSERT INTO op_params_t VALUES (
  1619, 111,    1,      1,    'TheInputConcept',   'IN', 'CON',  NULL);
INSERT INTO op_params_t VALUES (  
  1620, 111, 1,   1,          'NoOfAttributes',    'IN',   'V',  NULL);   
INSERT INTO op_params_t VALUES (  
  1621, 111, 0,   1,          'SampleSize',        'IN',   'V',  NULL);  
INSERT INTO op_params_t VALUES (
  1622, 111, 1,   NULL,       'TheAttributes',     'IN',  'BA',  NULL);    
INSERT INTO op_params_t VALUES (
  1623, 111, 1,   1,          'TheClassAttribute', 'IN',  'BA',  NULL);  
INSERT INTO op_params_t VALUES (
  1624, 111, 1,   1,          'TheOutputConcept',  'OUT', 'CON', NULL);
  
INSERT INTO op_constr_t VALUES (
  1625, 111, 'IN',   'TheClassAttribute',  'TheInputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1626, 111, 'TYPE', 'TheClassAttribute',  'NOMINAL',      NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1627, 111, 'IN',   'TheAttributes',      'TheInputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1628, 111, 'TYPE', 'TheAttributes',      'NOMINAL',      NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1629, 111, 'TYPE', 'NoOfAttributes',     'NUMERIC',         NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1630, 111, 'GT',   'NoOfAttributes',     0,                 NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1631, 111, 'TYPE', 'SampleSize',         'NUMERIC',         NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1632, 111, 'GT',   'SampleSize',         0,                 NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1633, 111, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);

-- INSERT INTO op_cond_t VALUES (2812, 111, 'LT', 'NoOfIntervals', TheInputConcept.NoOfCollumns, NULL, NULL);
INSERT INTO op_cond_t VALUES (
  1634, 111, 'NOT_NULL', 'TheAttributes',     NULL, NULL, NULL);
INSERT INTO op_cond_t VALUES (
  1635, 111, 'NOT_NULL', 'TheClassAttribute', NULL, NULL, NULL);

INSERT INTO op_assert_t VALUES (
  1636, 111, 'PROJ', 'TheOutputConcept', 'TheInputConcept', NULL, NULL);
-- output is proj of input

-- assertions for estimation of statistics:
INSERT INTO op_assert_t VALUES (
  1637, 111, 'NO_CHANGE', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);
  
INSERT INTO docu_t VALUES (
  1638, 111, 'OPERATOR', 
'This operator removes one feature a time starting from all attributes until the required number of features NoOfAttributes is reached. The attributes are selected with respect to TheClassAttribute, the group optimises the information dependence criterion. Use this operator if  a large number of original attributes is to be selected. The selection is done from the set of TheAttributes, attributes not specified in this set are selected automatically.');


-------------------------------------------------------
-- WP14: 1.3
INSERT INTO operator_t VALUES (112, 'FloatingForwardFeatureSelectionGivenNoOfAttributes', 'NO', 'NO', 'NO', 
NULL);

INSERT INTO op_params_t VALUES (
  1639, 112, 1,   1,     'TheInputConcept',   'IN',  'CON', NULL);
INSERT INTO op_params_t VALUES (  
  1640, 112, 1,   1,     'NoOfAttributes',    'IN',    'V', NULL);   
INSERT INTO op_params_t VALUES (  
  1641, 112, 0,   1,     'SampleSize',        'IN',    'V', NULL);  
INSERT INTO op_params_t VALUES (
  1642, 112, 1,   NULL,  'TheAttributes',     'IN',  'BA', NULL);    
INSERT INTO op_params_t VALUES (
  1643, 112, 1,   1,     'TheClassAttribute', 'IN',  'BA', NULL);  
INSERT INTO op_params_t VALUES (
  1644, 112, 1,   1,     'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO op_constr_t VALUES (
  1645, 112, 'IN',   'TheClassAttribute',  'TheInputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1646, 112, 'TYPE', 'TheClassAttribute',  'NOMINAL', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1647, 112, 'IN',   'TheAttributes',      'TheInputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1648, 112, 'TYPE', 'TheAttributes',      'NOMINAL', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1649, 112, 'TYPE', 'NoOfAttributes',     'NUMERIC', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1650, 112, 'GT',   'NoOfAttributes',             0, NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1651, 112, 'TYPE', 'SampleSize',         'NUMERIC', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1652, 112, 'GT', 'SampleSize',                   0, NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1653, 112, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);

-- INSERT INTO op_cond_t VALUES (2862, 112, 'LT', 'NoOfIntervals', TheInputConcept.NoOfCollumns, NULL, NULL);
INSERT INTO op_cond_t VALUES (
  1654, 112, 'NOT_NULL', 'TheAttributes', 
NULL, NULL, NULL);
INSERT INTO op_cond_t VALUES (
  1655, 112, 'NOT_NULL', 'TheClassAttribute', 
NULL, NULL, NULL);

INSERT INTO op_assert_t VALUES (
  1656, 112, 'PROJ', 'TheOutputConcept', 'TheInputConcept', NULL, NULL); 
-- output is proj of input

-- assertions for estimation of statistics:
INSERT INTO op_assert_t VALUES (
  1657, 112, 'NO_CHANGE', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);
  
INSERT INTO docu_t VALUES (
  1658, 112, 'OPERATOR', 
'This operator adds one feature a time starting from empty set until the required number of features NoOfAttributes is reached. The attributes are selected with respect to TheClassAttribute, the group optimises the information dependence criterion. Unlike the simple operator, after adding a feature a check is performed if another feature should be removed. Use this operator if only a small number of original attributes is to be selected. The selection is done from the set of TheAttributes, attributes not specified in this set are selected automatically.');


-------------------------------------------------------
-- WP14: 1.4
INSERT INTO operator_t VALUES (113, 'FloatingBackwardFeatureSelectionGivenNoOfAttributes', 'NO', 'NO', 'NO', 
NULL);

INSERT INTO op_params_t VALUES (
  1659, 113, 1,   1,    'TheInputConcept',   'IN', 'CON',  NULL);
INSERT INTO op_params_t VALUES (  
  1660, 113, 1,   1,    'NoOfAttributes',    'IN',  'V',   NULL);   
INSERT INTO op_params_t VALUES (  
  1661, 113, 0,   1,    'SampleSize',        'IN',  'V',   NULL);  
INSERT INTO op_params_t VALUES (
  1662, 113, 1,   NULL, 'TheAttributes',     'IN', 'BA',  NULL);    
INSERT INTO op_params_t VALUES (
  1663, 113, 1,   1,    'TheClassAttribute', 'IN', 'BA',  NULL);  
INSERT INTO op_params_t VALUES (
  1664, 113, 1,   1,    'TheOutputConcept',  'OUT', 'CON', NULL);
  
INSERT INTO op_constr_t VALUES (
  1665, 113, 'IN',   'TheClassAttribute',  'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1666, 113, 'TYPE', 'TheClassAttribute',  'NOMINAL',       NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1667, 113, 'IN',   'TheAttributes',      'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1668, 113, 'TYPE', 'TheAttributes',      'NOMINAL',       NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1669, 113, 'TYPE', 'NoOfAttributes',     'NUMERIC',          NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1670, 113, 'GT', 'NoOfAttributes',       0,                  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1671, 113, 'TYPE', 'SampleSize',         'NUMERIC',          NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1672, 113, 'GT', 'SampleSize',           0,                  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1673, 113, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);

-- INSERT INTO op_cond_t VALUES (2912, 113, 'LT', 'NoOfAttributes', TheInputConcept.NoOfCollumns, NULL, NULL);
INSERT INTO op_cond_t VALUES (
  1674, 113, 'NOT_NULL', 'TheAttributes', 
NULL, NULL, NULL);
INSERT INTO op_cond_t VALUES (
  1675, 113, 'NOT_NULL', 'TheClassAttribute', 
NULL, NULL, NULL);

INSERT INTO op_assert_t VALUES (
  1676, 113, 'PROJ', 'TheOutputConcept', 'TheInputConcept', NULL, NULL); 
-- output is proj of input

-- assertions for estimation of statistics:
INSERT INTO op_assert_t VALUES (
  1677, 113, 'NO_CHANGE', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);
  
INSERT INTO docu_t VALUES (
  1678, 113, 'OPERATOR', 
'This operator removes one feature a time starting from all attributes until the required number of features NoOfAttributes is reached. The attributes are selected with respect to TheClassAttribute, the group optimises the information dependence criterion. Unlike the simple operator, after removing a feature a check is performed if another feature should be added. Use this operator if  a large number of original attributes is to be selected. The selection is done from the set of TheAttributes, attributes not specified in this set are selected automatically.');

-------------------------------------------------------
-- WP14: 1.5
INSERT INTO operator_t VALUES (114, 'UserDefinedFeatureSelection', 'NO', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  1679, 114,    1,      1,    'TheInputConcept',        'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1680, 114,    1,      1,    'TheOutputConcept',      'OUT', 'CON', NULL);
INSERT INTO op_params_t VALUES (  
  1681, 114,    1,   NULL,    'TheSelectedAttributes', 'OUT',  'BA', NULL);   
  
INSERT INTO op_constr_t VALUES (
  1682, 114, 'IN',   'TheOutputConcept',       'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1683, 114, 'IN',   'TheSelectedAttributes',  'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1684, 114, 'IN',   'TheSelectedAttributes',  'TheOutputConcept', NULL, NULL);

INSERT INTO op_assert_t VALUES (
  1685, 114, 'PROJ', 'TheOutputConcept', 'TheInputConcept', NULL, NULL); 
-- output is proj of input

-- assertions for estimation of statistics:
INSERT INTO op_assert_t VALUES (
  1686, 114, 'NO_CHANGE', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);
  
INSERT INTO docu_t VALUES (
  1687, 114, 'OPERATOR', 
'This operator selects the attributes TheSelectedAttributes given by the user.');

-------------------------------------------------------
INSERT INTO operator_t VALUES (115, 'FeatureConstructionWithTFIDF', 'NO', 'NO', 'NO', NULL);

INSERT INTO op_params_t VALUES (
  1688, 115, 1,    1,	    'TheInputConcept',        'IN',  'CON', NULL);
INSERT INTO op_params_t VALUES (
  1689, 115, 1,    1,           'TheTimeStamp',           'OUT', 'BA',  NULL);
INSERT INTO op_params_t VALUES (
  1690, 115, 1,    1,           'TheKey',                 'OUT', 'BA',  NULL);
INSERT INTO op_params_t VALUES (
  1691, 115, 1,    1,           'TheOutputConcept',       'OUT', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1692, 115, 1,    NULL,        'TheSelectedAttributes',  'OUT', 'BA',  NULL);

INSERT INTO op_constr_t VALUES (
  1693, 115,        'IN',      'TheTimeStamp',          'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1694, 115,        'IN',      'TheKey',                'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1695, 115,        'IN',      'TheSelectedAttributes', 'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1696, 115,        'IN',      'TheTimeStamp',          'TheOutputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1697, 115,        'IN',      'TheKey',                'TheOutputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1698, 115,        'IN',      'TheSelectedAttributes', 'TheOutputConcept', NULL, NULL);

INSERT INTO op_assert_t VALUES (
  1699, 115, 'PROJ', 'TheOutputConcept', 'TheInputConcept', NULL, NULL); 
-- output is proj of input

--------------------------------------------------------------------------------------------------------------
INSERT INTO operator_t VALUES (116, 'EvaluateAdvantageOfTFIDFTransformation', 'NO', 'NO', 'NO', NULL);

INSERT INTO op_params_t VALUES (
  1700, 116, 1,    1,          'TheInputConcept',        'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1701, 116, 1,    1,          'TheTimeStamp',           'IN', 'BA',  NULL); 
INSERT INTO op_params_t VALUES (
  1702, 116, 1,    1,          'TheKey',                 'IN', 'BA',  NULL); 
INSERT INTO op_params_t VALUES (
  1703, 116, 1,    NULL,       'TheSelectedAttributes',  'IN', 'BA',  NULL); 

INSERT INTO op_constr_t VALUES (
  1704, 116,        'IN',     'TheTimeStamp',          'TheInputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1705, 116,        'IN',     'TheKey',                'TheInputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1706, 116,        'IN',     'TheSelectedAttributes', 'TheInputConcept', NULL, NULL);

--------------------------------------------------------------------------------------------------------------

INSERT INTO operator_t VALUES (117, 'Union', 'NO', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  1707,	117,	1,	1,	'TheInputConcept',	'IN',	'CON',	NULL);
INSERT INTO op_params_t VALUES (
  1708,	117,	1,	NULL,	'FurtherConcepts',	'IN',	'CON',	NULL);
INSERT INTO op_params_t VALUES (
  1709,	117,	1,	1,	'DataMode',		'IN',	'V',	NULL);
INSERT INTO op_params_t VALUES (
  1710,	117,	1,	1,	'TheOutputConcept',	'OUT',	'CON',	NULL);


INSERT INTO op_constr_t VALUES (
  1711, 117, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1712, 117, 'SAME_FEAT', 'FurtherConcepts',  'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1713, 117,    'ONE_OF', 'DataMode',         'set multi-set',    NULL, NULL);

-- no conditions

INSERT INTO op_assert_t VALUES (
  1714, 117, 'SUBSET', 'TheInputConcept', 'TheOutputConcept', NULL, NULL); 
-- input is subset of output
INSERT INTO op_assert_t VALUES (
  1715, 117, 'SUBSET', 'FurtherConcepts', 'TheOutputConcept', NULL, NULL); 
-- furtherCons are subsets of output

INSERT INTO op_assert_t VALUES (
  1716, 117, 'SZ_ADD', 'TheInputConcept', 'FurtherConcepts', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1717, 117, 'MM_COMB', 'TheInputConcept, FurtherConcepts', 'TheOutputConcept', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1718, 117, 'VL_COMB', 'TheInputConcept, FurtherConcepts', 'TheOutputConcept', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1719, 117, 'MV_ADD', 'TheInputConcept, FurtherConcepts', 'TheOutputConcept', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1720, 117, 'VF_ADD', 'TheInputConcept, FurtherConcepts', 'TheOutputConcept', NULL, NULL);
  
--------------------------------------------------------------------------------------------------------------

INSERT INTO operator_t VALUES (118, 'Materialize', 'NO', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  1721,	118,	1,	1,	'TheInputConcept',	'IN',	'CON',	NULL);
INSERT INTO op_params_t VALUES (
  1722,	118,	0,	1,	'TableName',		'IN',	'V',	NULL);
INSERT INTO op_params_t VALUES (
  1723,	118,	1,	1,	'TheOutputConcept',	'OUT',	'CON',	NULL);

INSERT INTO op_constr_t VALUES (
  1724, 118, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);

-- no conditions

INSERT INTO op_assert_t VALUES (
  1725, 118, 'SUBSET', 'TheInputConcept', 'TheOutputConcept', NULL, NULL); 
-- input concept is subset of output concept 
-- (output is also subset of input but we want only one direction)  

INSERT INTO op_assert_t VALUES (
  1726, 118, 'NO_CHANGE', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);
  
--------------------------------------------------------------------------------------------------------------

INSERT INTO operator_t VALUES (119, 'DateToNumeric', 'YES', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  1727, 119, 1,    1,           'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1728, 119, 1,    1,        'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1729, 119, 1,    1,                'OutputFormat',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  1730, 119, 1,    1,        'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO op_constr_t VALUES (
  1731, 119,         'IN', 'TheTargetAttribute',  'TheInputConcept',     NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1732, 119,         'IN', 'TheOutputAttribute',  'TheInputConcept',     NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1733, 119,      'TYPE', 'TheOutputAttribute',   'TIME',             NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1734, 119, 'IS_LOOPED',  'TheTargetAttribute',  NULL,                  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1735, 119, 'IS_LOOPED',  'OutputFormat',        NULL,                  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1736, 119, 'IS_LOOPED',  'TheOutputAttribute',  NULL,                  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1737, 119,    'ONE_OF',  'OutputFormat',
    'Year_YYYY Year_YY Month_of_Year Day_of_Month Hour_of_Day Minute_of_Hour Second_of_Minute',
  NULL, NULL);

-- no conditions

INSERT INTO op_assert_t VALUES (
  1738, 119, 'MV_FROM',   'TheTargetAttribute', 'TheOutputAttribute', NULL, NULL);
  
-------------------------------------------------------
INSERT INTO operator_t VALUES (120, 'YaleModelApplier', 'YES', 'NO', 'NO', NULL);

INSERT INTO op_params_t VALUES (
  1739, 120, 1,    1,             'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1740, 120, 1, NULL,                  'PrimaryKey',  'IN', 'FEA', NULL);
INSERT INTO op_params_t VALUES (
  1741, 120, 1, NULL,        'PredictingAttributes',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1742, 120, 1,    1,                   'ModelFile',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  1743, 120, 1,    1,          'PredictedAttribute', 'OUT',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1744, 120, 1,    1,            'TheOutputConcept', 'OUT', 'CON', NULL);

INSERT INTO op_constr_t VALUES (
  1745, 120,         'IN', 'PrimaryKey',            'TheInputConcept',      NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1746, 120,         'IN', 'PredictingAttributes',  'TheInputConcept',      NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1747, 120,         'IN', 'PrimaryKey',            'TheOutputConcept',     NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1748, 120,         'IN', 'PredictingAttributes',  'TheOutputConcept',     NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1749, 120,         'IN', 'PredictedAttribute',    'TheOutputConcept',     NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1750, 120,      'TYPE', 'PredictedAttribute',     'NUMERIC',              NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1751, 120,      'TYPE', 'ModelFile',              'NOMINAL',              NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1752, 120, 'IS_LOOPED', 'ModelFile',               NULL,                  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1753, 120, 'IS_LOOPED', 'PredictedAttribute',      NULL,                  NULL, NULL);

-- no conditions
-- no assertions
-------------------------------------------------------

INSERT INTO operator_t VALUES (121, 'CreatePrimaryKey', 'NO', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  1754,	121,	1,	1,	'TheInputConcept',	'IN',	'CON',	NULL);
INSERT INTO op_params_t VALUES (
  1755,	121,	1,	1,	'AllowDuplicates',	'IN',	'V',	NULL);
INSERT INTO op_params_t VALUES (
  1756,	121,	1,	1,	'PrimaryKey',		'OUT',	'BA',	NULL);
INSERT INTO op_params_t VALUES (
  1757,	121,	1,	1,	'TheOutputConcept',	'OUT',	'CON',	NULL);

INSERT INTO op_constr_t VALUES (
  1758, 121, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1759, 121, 'IN',        'PrimaryKey',       'TheOutputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1760, 121, 'TYPE',      'PrimaryKey',       'NOMINAL',        NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1761, 121, 'ONE_OF',    'AllowDuplicates',  'true false',       NULL, NULL);
-- no conditions

INSERT INTO op_assert_t VALUES (
  1762, 121, 'PROJ', 'TheInputConcept', 'TheOutputConcept', NULL, NULL); 
-- input is proj of output

INSERT INTO op_assert_t VALUES (
  1763, 121, 'NOT_NULL',    'PrimaryKey', NULL, NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1764, 121, 'NO_CHANGE', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);

-------------------------------------------------------
INSERT INTO operator_t VALUES (122, 'Repeat', 'NO', 'YES','YES', NULL);

INSERT INTO op_params_t VALUES (
  1765,   122,    1,      1,     'TheInputConcept',   'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1766,   122,    1,      1,            'HowOften',   'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  1767,   122,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO op_constr_t VALUES (
  1768, 122, 'SAME_FEAT',  'TheOutputConcept',  'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1769, 122,        'GE',  'HowOften',                          1,  NULL, NULL);

-- no conditions

INSERT INTO op_assert_t VALUES (
  1770, 122, 'SUBSET', 'TheInputConcept', 'TheOutputConcept', NULL, NULL); 
-- input concept is subset of output concept 
-- (output is also subset of input but we want only one direction)  

INSERT INTO op_assert_t VALUES (
  1771, 122, 'NO_CHANGE', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);

-------------------------------------------------------

INSERT INTO operator_t VALUES (123, 'Pivotize', 'NO', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  1772, 123, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1773, 123, 1, NULL,       'TheIndexAttributes',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1774, 123, 1,    1,        'ThePivotAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1775, 123, 0, NULL,     'TheGroupByAttributes',  'IN', 'FEA', NULL);
INSERT INTO op_params_t VALUES (
  1776, 123, 1,    1,         'TheOutputConcept', 'OUT', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1777, 123, 1, NULL,              'IndexValues',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  1778, 123, 1,    1,      'AggregationOperator',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  1779, 123, 0,    1,               'NullOrZero',  'IN',   'V', NULL);


INSERT INTO op_constr_t VALUES (
  1780, 123, 'IN',   'TheIndexAttributes',  'TheInputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1781, 123, 'IN',    'ThePivotAttribute',  'TheInputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1782, 123, 'IN', 'TheGroupByAttributes',  'TheInputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1783, 123, 'IN', 'TheGroupByAttributes', 'TheOutputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1784, 123, 'CREATE_BY', 'ThePivotAttribute', 'IndexValues', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1785, 123, 'OUT_TYPE',  'ThePivotAttribute', 'NUMERIC', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1786, 123, 'ONE_OF','AggregationOperator', 'NONE SUM AVG MIN MAX COUNT', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1787, 123, 'ONE_OF','NullOrZero', 'Null Zero', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1788, 123, 'COORD', 'IndexValues', 'TheIndexAttributes', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1789, 123, 'USE_VALS', 'IndexValues', 'TheIndexAttributes', NULL, NULL);

-- no conditions

INSERT INTO op_assert_t VALUES (
  1790, 123, 'REL_N_1', 'TheInputConcept',    'TheOutputConcept',   NULL, NULL);
-- an n:1 relationship from input to output exists (if there are any group-by attributes)
INSERT INTO op_assert_t VALUES (
  1791, 123, 'REL_N_K', 'TheGroupByAttributes', NULL, NULL, NULL);
-- the keys on the "many-side" are given by the GroupBy attributes 
INSERT INTO op_assert_t VALUES (
  1792, 123, 'REL_1_K',  'TheGroupByAttributes', NULL, NULL, NULL);
-- the keys on the "one-side" are given by the GroupBy attributes

INSERT INTO op_assert_t VALUES (
  1793, 123, 'SZ_BY_VL', 'TheGroupByAttributes', NULL, NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1794, 123, 'VF_BY_AGG','TheGroupByAttributes', NULL, NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1795, 123, 'VL_FROM', 'ThePivotAttribute', NULL, NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1796, 123, 'MM_FROM', 'ThePivotAttribute', NULL, NULL, NULL);
  
-------------------------------------------------------

INSERT INTO operator_t VALUES (124, 'PrepareForYale', 'NO', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
 1797, 124, 1,    1,    'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
 1798, 124, 0,    1,    'QueryFilePrefix',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
 1799, 124, 1,    1, 'ExperimentFileName',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
 1800, 124, 0,    1,           'TheLabel',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
 1801, 124, 0,    1,      'ThePrimaryKey',  'IN',  'BA', NULL);

INSERT INTO op_constr_t VALUES (
  1802, 124, 'IN',      'TheLabel', 'TheInputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1803, 124, 'IN', 'ThePrimaryKey', 'TheInputConcept', NULL, NULL);

-- no conditions
-- no assertions

-------------------------------------------------------
INSERT INTO operator_t VALUES (125, 'RemoveDuplicates', 'NO', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  1804,   125,    1,      1,    'TheInputConcept',    'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1805,   125,    1,      1,    'TheOutputConcept',  'OUT', 'CON', NULL);

INSERT INTO op_constr_t VALUES (
  1806, 125, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);

-- no conditions

INSERT INTO op_assert_t VALUES (
  1807, 125, 'SUBSET', 'TheOutputConcept', 'TheInputConcept', NULL, NULL); 
-- output is subset of input

-------------------------------------------------------

INSERT INTO operator_t VALUES (126, 'Binarify', 'YES', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  1808, 126, 1,    1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1809, 126, 1,    1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1810, 126, 1,    1,  'TheOutputAttribute', 'OUT',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1811, 126, 1,    1,         'TargetValue',  'IN',   'V', NULL);

INSERT INTO op_constr_t VALUES (
  1812, 126, 'IS_LOOPED',   'TargetValue',               NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1813, 126, 'IS_LOOPED',   'TheOutputAttribute',        NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1814, 126,        'IN',   'TheTargetAttribute',  'TheInputConcept',     NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1815, 126,        'IN',   'TheOutputAttribute',  'TheInputConcept',     NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1816, 126,      'TYPE',   'TheOutputAttribute',  'BINARY',              NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1817, 126,  'USE_VALS',   'TargetValue', 'TheTargetAttribute', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1818, 126,  'CR_SUFFIX', 'TheTargetAttribute',  'Flag',           NULL, NULL);

-- no conditions

INSERT INTO op_assert_t VALUES (
  1819, 126, 'GE',       'TheOutputAttribute', '0', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1820, 126, 'LE',       'TheOutputAttribute', '1', NULL, NULL);

INSERT INTO op_assert_t VALUES (
  1821, 126, 'NOT_NULL', 'TheOutputAttribute', NULL, NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1822, 126, 'MIN_FROM', 'TheOutputAttribute', '0', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1823, 126, 'MAX_FROM', 'TheOutputAttribute', '1', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1824, 126, 'VL_BY_LIST', 'TheOutputAttribute', '0 1', NULL, NULL);
  
-------------------------------------------------------

INSERT INTO operator_t VALUES (127, 'ReversePivotize', 'NO', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  1825, 127, 1,    1,          'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1826, 127, 1, NULL,    'ThePivotizedAttributes', 'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1827, 127, 0, 1,              'TheKeyAttribute', 'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1828, 127, 1,    1,         'TheOutputConcept', 'OUT', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1829, 127, 1, NULL,              'IndexValues',  'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  1830, 127, 1, 1,        'OutputPivotAttribute', 'OUT',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1831, 127, 1, NULL,    'OutputIndexAttributes', 'OUT',  'BA', NULL);


INSERT INTO op_constr_t VALUES (
  1832, 127, 'IN',   'ThePivotizedAttributes',  'TheInputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1833, 127, 'IN',          'TheKeyAttribute',  'TheInputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1834, 127, 'IN',          'TheKeyAttribute', 'TheOutputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1835, 127, 'IN',     'OutputPivotAttribute', 'TheOutputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1836, 127, 'IN',    'OutputIndexAttributes', 'TheOutputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1837, 127, 'ALL_EXCEPT', 'ThePivotizedAttributes', 'TheOutputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1838, 127, 'COORD',      'IndexValues', 'ThePivotizedAttributes', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1839, 127, 'SAME_TYPE', 'OutputPivotAttribute', 'ThePivotizedAttributes', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1840, 127, 'TYPE',     'OutputIndexAttributes', 'NOMINAL', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1841, 127, 'TYPE',     'IndexValues', 'NOMINAL', NULL, NULL);
  

-- no conditions

INSERT INTO op_assert_t VALUES (
  1842, 127, 'REL_N_1', 'TheOutputConcept',    'TheInputConcept',   NULL, NULL);
-- an n:1 relationship from output to input exists (if there is a key attribute)
INSERT INTO op_assert_t VALUES (
  1843, 127, 'REL_N_K', 'TheKeyAttribute', NULL, NULL, NULL);
-- the key on the "many-side" is given by the Key attribute 
INSERT INTO op_assert_t VALUES (
  1844, 127, 'REL_1_K',  'TheKeyAttribute', NULL, NULL, NULL);
-- the key on the "one-side" is given by the Key attribute

INSERT INTO op_assert_t VALUES (
  1845, 127, 'MM_COMB', 'ThePivotizedAttributes', 'OutputPivotAttribute', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1846, 127, 'VL_COMB', 'ThePivotizedAttributes', 'OutputPivotAttribute', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1847, 127, 'VL_BY_LIST', 'OutputIndexAttributes', 'IndexValues', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1848, 127, 'SZ_MULT_NO', 'ThePivotizedAttributes', NULL, NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1849, 127, 'VF_MULT_NO', 'TheKeyAttribute', 'ThePivotizedAttributes', NULL, NULL);
  
-------------------------------------------------------

INSERT INTO operator_t VALUES (128, 'MergeAttributes', 'NO', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  1850, 128, 1,    1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1851, 128, 1,    1,  'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1852, 128, 1,    1,    'AttributeToMerge',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1853, 128, 1,    1,  'TheOutputAttribute', 'OUT',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1854, 128, 1,    1,     'ClashResolvation', 'IN',   'V', NULL);

INSERT INTO op_constr_t VALUES (
  1855, 128,        'IN',   'TheTargetAttribute',  'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1856, 128,        'IN',     'AttributeToMerge',  'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1857, 128,        'IN',   'TheOutputAttribute',  'TheInputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1858, 128,      'TYPE',   'TheOutputAttribute',  'NOMINAL',      NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1859, 128,      'TYPE',   'TheTargetAttribute',  'NOMINAL',      NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1860, 128,      'TYPE',     'AttributeToMerge',  'NOMINAL',      NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1861, 128,    'ONE_OF',     'ClashResolvation', 'Priority ValueCombination',  NULL, NULL);

-- no conditions
INSERT INTO op_assert_t VALUES (
  1862, 128, 'MM_COMB', 'TheTargetAttribute, AttributeToMerge', 'TheOutputAttribute', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1863, 128, 'VL_COMB', 'TheTargetAttribute, AttributeToMerge', 'TheOutputAttribute', NULL, NULL);

-------------------------------------------------------

INSERT INTO operator_t VALUES (129, 'MaterializeWithPKs', 'NO', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  1864,	129,	1,	1,     'TheInputConcept',	'IN',	'CON',	NULL);
INSERT INTO op_params_t VALUES (
  1865,	129,	0,	1,	     'TableName',	'IN',	  'V',	NULL);
INSERT INTO op_params_t VALUES (
  1866,	129,	1,	1,    'TheOutputConcept',      'OUT',	'CON',	NULL);
INSERT INTO op_params_t VALUES (
  1867,	129,	1,   NULL,          'PrimaryKey',       'IN',	 'BA',	NULL);

INSERT INTO op_constr_t VALUES (
  1868, 129, 'SAME_FEAT', 'TheOutputConcept', 'TheInputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1869, 129, 'IN',        'PrimaryKey',       'TheInputConcept',  NULL, NULL);

-- no conditions

INSERT INTO op_assert_t VALUES (
  1870, 129, 'SUBSET', 'TheInputConcept', 'TheOutputConcept', NULL, NULL); 
INSERT INTO op_assert_t VALUES (
  1871, 129, 'NO_CHANGE', 'TheInputConcept', 'TheOutputConcept', NULL, NULL); 

-------------------------------------------------------

INSERT INTO operator_t VALUES (130, 'ReverseFeatureConstruction', 'YES', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  1872, 130, 1,    1,           'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1873, 130, 1,    1,        'TheTargetAttribute',  'IN',  'BA', NULL);
INSERT INTO op_params_t VALUES (
  1874, 130, 0,    1,        'OriginalOutputAttribute',   'IN',   'V', NULL);
INSERT INTO op_params_t VALUES (
  1875, 130, 1,    1,        'TheOutputAttribute', 'OUT',  'BA', NULL);

INSERT INTO op_constr_t VALUES (
  1876, 130,         'IN', 'TheTargetAttribute',  'TheInputConcept',     NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1877, 130,         'IN', 'TheOutputAttribute',  'TheInputConcept',     NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1878, 130,  'SAME_TYPE', 'TheOutputAttribute',  'TheTargetAttribute',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1879, 130,  'TYPE',      'OriginalOutputAttribute',   'NOMINAL',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1880, 130, 'IS_LOOPED',  'OriginalOutputAttribute',   NULL,                  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1881, 130, 'IS_LOOPED',  'TheTargetAttribute',  NULL,                  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1882, 130, 'IS_LOOPED',  'TheOutputAttribute',  NULL,                  NULL, NULL);

-- no operator group for this operator!

-- no conditions

INSERT INTO op_assert_t VALUES (
  1883, 130, 'VL_FROM', 'OriginalOutputAttribute', 'TheOutputAttribute', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1884, 130, 'VF_FROM', 'OriginalOutputAttribute', 'TheOutputAttribute', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1885, 130, 'MV_FROM', 'OriginalOutputAttribute', 'TheOutputAttribute', NULL, NULL);
INSERT INTO op_assert_t VALUES (
  1886, 130, 'MM_FROM', 'OriginalOutputAttribute', 'TheOutputAttribute', NULL, NULL);
  
-------------------------------------------------------

INSERT INTO operator_t VALUES (131, 'CreateManyToManyRelation', 'NO', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  1887, 131, 1,    1,     'TheFromConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1888, 131, 1,    1,       'TheToConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1889, 131, 1,    1,      'TheCrossTable',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1890, 131, 1, NULL,     'FromConceptKeys',  'IN', 'BA', NULL);
INSERT INTO op_params_t VALUES (
  1891, 131, 1, NULL,     'CrossToFromConceptKeys',  'IN', 'BA', NULL);
INSERT INTO op_params_t VALUES (
  1892, 131, 1, NULL,     'ToConceptKeys',  'IN', 'BA', NULL);
INSERT INTO op_params_t VALUES (
  1893, 131, 1, NULL,     'CrossToToConceptKeys',  'IN', 'BA', NULL);
INSERT INTO op_params_t VALUES (
  1894, 131, 0, 1,     'NameForCrossTable',  'IN', 'V', NULL);
INSERT INTO op_params_t VALUES (
  1895, 131, 1, 1, 'TheRelation', 'OUT', 'REL', NULL);

INSERT INTO op_constr_t VALUES (
  1896, 131, 'IN',     'FromConceptKeys',    'TheFromConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1897, 131, 'IN',     'ToConceptKeys',    'TheToConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1898, 131, 'IN',     'CrossToFromConceptKeys',  'TheCrossTable',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1899, 131, 'IN',     'CrossToToConceptKeys',    'TheCrossTable',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1900, 131, 'COORD',  'CrossToFromConceptKeys',  'FromConceptKeys', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1901, 131, 'COORD',  'CrossToToConceptKeys',     'ToConceptKeys', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1902, 131, 'FROMCON', 'TheRelation', 'TheFromConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1903, 131, 'TOCON',   'TheRelation', 'TheToConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1904, 131, 'CROSSCON',   'TheRelation', 'TheCrossTable', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1905, 131, 'FROMKEY', 'TheRelation', 'FromConceptKeys', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1906, 131, 'TOKEY',   'TheRelation', 'ToConceptKeys', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1907, 131, 'CR_FROMKEY', 'TheRelation', 'CrossToFromConceptKeys', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1908, 131, 'CR_TOKEY',   'TheRelation', 'CrossToToConceptKeys', NULL, NULL);

INSERT INTO op_cond_t VALUES (
  1909, 131, 'NOT_NULL', 'FromConceptKeys',  NULL, NULL, NULL);
-- INSERT INTO op_cond_t VALUES (
--  1910, 131, 'UNIQUE',   'FromConceptKeys',  NULL, NULL, NULL);
INSERT INTO op_cond_t VALUES (
  1911, 131, 'NOT_NULL', 'ToConceptKeys',  NULL, NULL, NULL);
-- INSERT INTO op_cond_t VALUES (
--   1912, 131, 'UNIQUE',   'ToConceptKeys',  NULL, NULL, NULL);
INSERT INTO op_cond_t VALUES (
  1913, 131, 'NOT_NULL', 'CrossToFromConceptKeys',  NULL, NULL, NULL);
INSERT INTO op_cond_t VALUES (
  1914, 131, 'NOT_NULL', 'CrossToToConceptKeys',  NULL, NULL, NULL);
  
-------------------------------------------------------

INSERT INTO operator_t VALUES (132, 'CreateOneToManyRelation', 'NO', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  1915, 132, 1,    1,     'TheFromConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1916, 132, 1,    1,       'TheToConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1917, 132, 1, NULL,     'FromConceptKeys',  'IN', 'BA', NULL);
INSERT INTO op_params_t VALUES (
  1918, 132, 1, NULL,     'ToConceptKeys',  'IN', 'BA', NULL);
INSERT INTO op_params_t VALUES (
  1919, 132, 1, 1, 'TheRelation', 'OUT', 'REL', NULL);

INSERT INTO op_constr_t VALUES (
  1920, 132, 'IN',     'FromConceptKeys',   'TheFromConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1921, 132, 'IN',     'ToConceptKeys',       'TheToConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1922, 132, 'COORD',  'FromConceptKeys',    'ToConceptKeys',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1923, 132, 'FROMCON', 'TheRelation', 'TheFromConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1924, 132, 'TOCON',   'TheRelation', 'TheToConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1925, 132, 'FROMKEY', 'TheRelation', 'FromConceptKeys', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1926, 132, 'TOKEY',   'TheRelation', 'ToConceptKeys', NULL, NULL);

INSERT INTO op_cond_t VALUES (
  1927, 132, 'NOT_NULL', 'FromConceptKeys',  NULL, NULL, NULL);
-- INSERT INTO op_cond_t VALUES (
--   1928, 132, 'UNIQUE',   'FromConceptKeys',  NULL, NULL, NULL);
INSERT INTO op_cond_t VALUES (
  1929, 132, 'NOT_NULL', 'ToConceptKeys',  NULL, NULL, NULL);
-- INSERT INTO op_cond_t VALUES (
--   1930, 132, 'UNIQUE',   'ToConceptKeys',  NULL, NULL, NULL);
  
-------------------------------------------------------

INSERT INTO operator_t VALUES (133, 'FeatureConstructionByRelation', 'YES', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  1931, 133, 1,   1,         'TheRelation',  'IN', 'REL', NULL);
INSERT INTO op_params_t VALUES (
  1932, 133, 1,   1,  'TheTargetAttribute',  'IN', 'BA', NULL);
INSERT INTO op_params_t VALUES (
  1933, 133, 1,   1,  'AggregationOperator', 'IN', 'V', NULL);
INSERT INTO op_params_t VALUES (
  1934, 133, 1,   1,   'TheOutputAttribute', 'OUT', 'BA', NULL);
INSERT INTO op_params_t VALUES (
  1935, 133, 1,   1,   'TheOutputConcept',   'OUT', 'CON', NULL);
  
INSERT INTO op_constr_t VALUES (
  1936, 133, 'IS_LOOPED',   'TheTargetAttribute',     NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1937, 133, 'IS_LOOPED',   'TheOutputAttribute',     NULL,  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1938, 133, 'IS_LOOPED',  'AggregationOperator',     NULL,  NULL, NULL);
  
-- the target attribute is IN the FromConcept of the input relation:
INSERT INTO op_constr_t VALUES (
  1939, 133, 'IN_RELFROM', 'TheTargetAttribute',  'TheRelation',  NULL, NULL);
  
-- features of the output concept are taken from the ToConcept of the input relation:
INSERT INTO op_constr_t VALUES (
  1940, 133, 'FEAT_RTO',   'TheRelation',   'TheOutputConcept',   NULL, NULL);
  
INSERT INTO op_constr_t VALUES (
  1941, 133, 'IN',   'TheOutputAttribute',  'TheOutputConcept',  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1942, 133, 'ONE_OF', 'AggregationOperator', 'SUM COUNT VALUE_OF', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1943, 133,   'TYPE',   'TheOutputAttribute',  'NUMERIC',     NULL, NULL);

INSERT INTO op_assert_t VALUES (
  1944, 133,  'PROJ_RELTO', 'TheRelation', 'TheOutputConcept', NULL, NULL); 
-- ToConcept of TheRelation is proj of output concept

INSERT INTO op_assert_t VALUES (
  1945, 133, 'NOT_NULL', 'TheOutputAttribute', NULL, NULL, NULL);
  
-------------------------------------------------------

INSERT INTO operator_t VALUES (134, 'AttributeDerivation', 'YES', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  1946, 134, 1,   1,     'TheInputConcept',  'IN', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1947, 134, 1,   1,          'ClassName',  'IN', 'V', NULL);
INSERT INTO op_params_t VALUES (
  1948, 134, 1,   1, 'TypeOfOutputAttribute',  'IN', 'V', NULL);
INSERT INTO op_params_t VALUES (
  1949, 134, 0,   NULL,   'TheTargetAttributes', 'IN', 'BA', NULL);
INSERT INTO op_params_t VALUES (
  1950, 134, 1,   1,   'TheOutputAttribute', 'OUT', 'BA', NULL);
INSERT INTO op_params_t VALUES (
  1951, 134, 1,   1,  'TheOutputConcept',   'OUT', 'CON', NULL);
  
INSERT INTO op_constr_t VALUES (
  1952, 134, 'SAME_FEAT', 'TheOutputConcept',  'TheInputConcept',     NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1953, 134,       'IN',  'TheOutputAttribute',  'TheOutputConcept',     NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1954, 134,       'IN',  'TheTargetAttributes',  'TheInputConcept',     NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1955, 134, 'IS_LOOPED',  'TypeOfOutputAttribute',  NULL,                  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1956, 134, 'IS_LOOPED',  'ClassName',          NULL,                  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1957, 134, 'IS_LOOPED',  'TheTargetAttributes',  NULL,                  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1958, 134, 'IS_LOOPED',  'TheOutputAttribute',  NULL,                  NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1959, 134,      'TYPE',  'ClassName',          'NOMINAL',             NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1960, 134,      'TYPE',  'TypeOfOutputAttribute',   'NOMINAL',             NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1961, 134,      'TYPE',  'TheOutputAttribute',  'TypeOfOutputAttribute',   NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1962, 134, 'ONE_OF',  'TypeOfOutputAttribute',  'NOMINAL NUMERIC TIME BINARY',       NULL, NULL);

-- no conditions

INSERT INTO op_assert_t VALUES (
  1963, 134, 'PROJ', 'TheInputConcept', 'TheOutputConcept', NULL, NULL); 
-- input is proj of output

INSERT INTO op_assert_t VALUES (
  1964, 134, 'NO_CHANGE', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);
  
-------------------------------------------------------
INSERT INTO operator_t VALUES (135, 'RemoveFeatures', 'NO', 'NO', 'YES', NULL);

INSERT INTO op_params_t VALUES (
  1965, 135, 1,    1,       'TheInputConcept',     'IN',  'CON', NULL);
INSERT INTO op_params_t VALUES (
  1966, 135, 1,    1,       'TheOutputConcept',    'OUT', 'CON', NULL);
INSERT INTO op_params_t VALUES (
  1967, 135, 1, NULL,       'FeaturesToRemove',    'IN',  'FEA', NULL);

INSERT INTO op_constr_t VALUES (
  1968, 135, 'IN',         'FeaturesToRemove', 'TheInputConcept', NULL, NULL);
INSERT INTO op_constr_t VALUES (
  1969, 135, 'ALL_EXCEPT', 'FeaturesToRemove', 'TheOutputConcept', NULL, NULL);

-- no conditions

INSERT INTO op_assert_t VALUES (
  1970, 135, 'PROJ', 'TheOutputConcept', 'TheInputConcept', NULL, NULL); 
-- output is proj of input

-- assertions for estimation of statistics:
INSERT INTO op_assert_t VALUES (
  1971, 135, 'NO_CHANGE', 'TheInputConcept', 'TheOutputConcept', NULL, NULL);
  
-------------------------------------------------------
----                Operator Groups                ----
-------------------------------------------------------

-- Top level groups:
INSERT INTO op_group_t VALUES (10, NULL, NULL, 'Feature Construction');
INSERT INTO op_group_t VALUES (11, NULL, NULL, 'Data Reduction');
INSERT INTO op_group_t VALUES (12, NULL, NULL, 'Propositionalisation');
INSERT INTO op_group_t VALUES (13, NULL, NULL, 'Data Cleaning');
INSERT INTO op_group_t VALUES (14, NULL, NULL, 'Changing Organisation');
INSERT INTO op_group_t VALUES (15, NULL, NULL, 'Time Series Preparation');
INSERT INTO op_group_t VALUES (16, NULL, NULL, 'Pseudo-Parallelism');
INSERT INTO op_group_t VALUES (17, NULL, NULL, 'Data Mining Step');
INSERT INTO op_group_t VALUES (18, NULL, NULL, 'Creating Relations');
INSERT INTO op_group_t VALUES (19, NULL, NULL, 'Evaluation');
INSERT INTO op_group_t VALUES (20, NULL, NULL, 'Miscellaneous');

-- Second level groups:
INSERT INTO op_group_t VALUES (21, 13, NULL, 'Handle Missing Values');
INSERT INTO op_group_t VALUES (22, 10, NULL, 'Discretisation');
INSERT INTO op_group_t VALUES (23, 10, NULL, 'Grouping');
INSERT INTO op_group_t VALUES (24, 10, NULL, 'Scaling');
INSERT INTO op_group_t VALUES (25, 11, NULL, 'Feature Selection');


-- Missing value operators:
INSERT INTO op_group_t VALUES (1972, 21, 46,  'Assign a default');
INSERT INTO op_group_t VALUES (1973, 21, 47,  'Assign modal');
INSERT INTO op_group_t VALUES (1974, 21, 48,  'Assign median');
INSERT INTO op_group_t VALUES (1975, 21, 49,  'Assign average');
INSERT INTO op_group_t VALUES (1976, 21, 50,  'Assign stochastic');
INSERT INTO op_group_t VALUES (1977, 21, 53,  'Learn with regression SVM');
INSERT INTO op_group_t VALUES (1978, 21, 38,  'Delete incomplete records');

-- Row selection and aggregation:
INSERT INTO op_group_t VALUES (1979, 11, 39,  'Row Selection - Query');
INSERT INTO op_group_t VALUES (1980, 11, 37,  'Row Selection - Random Sampling');
INSERT INTO op_group_t VALUES (1981, 11, 125, 'Remove duplicate rows');
INSERT INTO op_group_t VALUES (1982, 11, 77,  'SpecifiedStatistics');

-- Pseudo-parallel processing:
INSERT INTO op_group_t VALUES (1983, 16, 40,  'Segmentation - Stratified');
INSERT INTO op_group_t VALUES (1984, 16, 42,  'Segmentation - Partitioning');
INSERT INTO op_group_t VALUES (1985, 16, 74,  'Undo a Segmentation');
INSERT INTO op_group_t VALUES (1986, 16, 122, 'Clone Columnset');

-- Time Operators:
INSERT INTO op_group_t VALUES (1987, 15, 67, 'Windowing');
INSERT INTO op_group_t VALUES (1988, 15, 68, 'Signal To Symbol');
INSERT INTO op_group_t VALUES (1989, 15, 70, 'Moving function');
INSERT INTO op_group_t VALUES (1990, 15, 71, 'Weighted moving function');
INSERT INTO op_group_t VALUES (1991, 15, 72, 'Exponential moving function');

-- Propositionalisation:
INSERT INTO op_group_t VALUES (1992, 12, 34,  'MultiRelationalFeatureConstruction');
INSERT INTO op_group_t VALUES (1993, 12, 117, 'Union');
INSERT INTO op_group_t VALUES (1994, 12, 91,  'UnionByKey');
INSERT INTO op_group_t VALUES (1995, 12, 76,  'JoinByKey');

-- Feature Selection
INSERT INTO op_group_t VALUES (1996, 25, 43,  'FeatureSelectionByAttributes');
INSERT INTO op_group_t VALUES (1997, 25, 135, 'RemoveFeatures');
INSERT INTO op_group_t VALUES (1998, 25, 88,  'FeatureSelectionWithSVM');
INSERT INTO op_group_t VALUES (1999, 25, 110, 'SimpleForwardFeatureSelectionGivenNoOfAttributes');
INSERT INTO op_group_t VALUES (2000, 25, 111, 'SimpleBackwardFeatureSelectionGivenNoOfAttributes');
INSERT INTO op_group_t VALUES (2001, 25, 112, 'FloatingForwardFeatureSelectionGivenNoOfAttributes');
INSERT INTO op_group_t VALUES (2002, 25, 113, 'FloatingBackwardFeatureSelectionGivenNoOfAttributes');
INSERT INTO op_group_t VALUES (2003, 25, 114, 'UserDefinedFeatureSelection');

-- Feature Construction
INSERT INTO op_group_t VALUES (2004, 10, 90,  'GenericFeatureConstruction');
INSERT INTO op_group_t VALUES (2005, 10, 119, 'DateToNumeric');
INSERT INTO op_group_t VALUES (2006, 10, 128, 'MergeAttributes');
INSERT INTO op_group_t VALUES (2007, 10, 133, 'FeatureConstructionByRelation');
INSERT INTO op_group_t VALUES (2008, 10, 134, 'AttributeDerivation');
INSERT INTO op_group_t VALUES (2009, 10, 115, 'FeatureConstructionWithTFIDF');

---- Scaling
INSERT INTO op_group_t VALUES (2010, 24, 44,  'LinearScaling');
INSERT INTO op_group_t VALUES (2011, 24, 45,  'LogScaling');

---- Grouping
INSERT INTO op_group_t VALUES (2012, 23, 101, 'GroupingGivenMinCardinality');
INSERT INTO op_group_t VALUES (2013, 23, 102, 'GroupingGivenNoOfGroups');
INSERT INTO op_group_t VALUES (2014, 23, 103, 'UserDefinedGrouping');
INSERT INTO op_group_t VALUES (2015, 23, 104, 'UserDefinedGroupingWithDefaultValue');
INSERT INTO op_group_t VALUES (2016, 23, 108, 'ErrorBasedGroupingGivenMinCardinality');
INSERT INTO op_group_t VALUES (2017, 23, 109, 'ErrorBasedGroupingGivenNoOfGroups');
INSERT INTO op_group_t VALUES (2018, 23, 107, 'ImplicitErrorBasedGrouping');

---- Discretization
INSERT INTO op_group_t VALUES (2019, 22, 92,  'TimeIntervalManualDiscretization');
INSERT INTO op_group_t VALUES (2020, 22, 93,  'NumericalIntervalManualDiscretization');
INSERT INTO op_group_t VALUES (2021, 22, 95,  'EquidistantDiscretizationGivenWidth');
INSERT INTO op_group_t VALUES (2022, 22, 96,  'EquidistantDiscretizationGivenNoOfIntervals');
INSERT INTO op_group_t VALUES (2023, 22, 97,  'EquifrequentDiscretizationGivenCardinality');
INSERT INTO op_group_t VALUES (2024, 22, 98,  'EquifrequentDiscretizationGivenNoOfIntervals');
INSERT INTO op_group_t VALUES (2025, 22, 99,  'UserDefinedDiscretization');
INSERT INTO op_group_t VALUES (2026, 22, 100, 'ImplicitErrorBasedDiscretization');
INSERT INTO op_group_t VALUES (2027, 22, 105, 'ErrorBasedDiscretizationGivenMinCardinality');
INSERT INTO op_group_t VALUES (2028, 22, 106, 'ErrorBasedDiscretizationGivenNoOfIntervals');

-- Misc
INSERT INTO op_group_t VALUES (2029, 20, 118, 'Materialize');
INSERT INTO op_group_t VALUES (2030, 20, 129, 'MaterializeWithPKs');
-- INSERT INTO op_group_t VALUES (2031, 20, 130, 'MaterializeRelation');
INSERT INTO op_group_t VALUES (2032, 20, 120, 'Apply a Yale model');
INSERT INTO op_group_t VALUES (2033, 20, 121, 'Create a primary key');
INSERT INTO op_group_t VALUES (2034, 20, 124, 'Prepare a Yale experiment');

-- Changing organisation
INSERT INTO op_group_t VALUES (2035, 14, 123, 'Pivotize');
INSERT INTO op_group_t VALUES (2036, 14, 127, 'ReversePivotize');
INSERT INTO op_group_t VALUES (2037, 14, 126, 'Binarify');

-- Data Mining Step
INSERT INTO op_group_t VALUES (2038, 17, 84,  'Apriori');
INSERT INTO op_group_t VALUES (2039, 17, 89,  'SupportVectorMachineForClassification');
INSERT INTO op_group_t VALUES (2040, 17, 63,  'SupportVectorMachineForRegression');

-- Evaluation
INSERT INTO op_group_t VALUES (2041, 19, 73,  'ComputeSVMError');
INSERT INTO op_group_t VALUES (2042, 19, 116, 'EvaluateAdvantageOfTFIDFTransformation');

-- Relations
INSERT INTO op_group_t VALUES (2043, 18, 131, 'CreateManyToManyRelation');
INSERT INTO op_group_t VALUES (2044, 18, 132, 'CreateOneToManyRelation');

-- no operator group for op 130 'ReverseFeatureConstruction'!

-------------------------------------------------------
