#!/bin/sh

# Do not edit the first line of this file above unless you know what it means.
#
# Enter here the path to your MiningMart installation (or set it in
# an environment variable if you know how to do that). 

MMART_HOME=

# You may want to set here the maximum amount of memory Java uses.
#MAX_JAVA_MEMORY=128

# Do not edit anything below this line unless you know what you
# are doing.

if [ -z "${JAVA_HOME}" ] ; then
    echo "JAVA_HOME is not set. Edit $0 and/or your local startup files."
    exit 1
else
    JAVA=${JAVA_HOME}/bin/java
fi

if [ -z "${MAX_JAVA_MEMORY}" ] ; then
    MAX_JAVA_MEMORY=128
    echo "No maximum Java memory defined, using 128 Mb..."
fi


BUILD="${MMART_HOME}/build"
MMART_JAR="${MMART_HOME}/lib/mmart.jar"
MMART_CLASSPATH=""

if [ -d "${BUILD}" ] ; then
    MMART_CLASSPATH=${BUILD}
elif [ -f "${MMART_JAR}" ] ; then
    MMART_CLASSPATH=${MMART_JAR}
else
    echo "Neither ${BUILD} nor ${MMART_JAR} was found."
    echo "Try 'ant build' or 'ant jar' first or check the value of MMART_HOME!"
    exit 1
fi

CONFIG="${MMART_HOME}/config"
if [ ! -d "${CONFIG}" ] ; then
	echo "The config-folder ${CONFIG} was not found."
	exit 1
fi

for JAR in ${MMART_HOME}/lib/*.jar
do
CLASSPATH=${CLASSPATH}:${JAR}
done

for ZIP in ${MMART_HOME}/lib/*.zip
do
CLASSPATH=${CLASSPATH}:${ZIP}
done

CLASSPATH=${MMART_CLASSPATH}:${CONFIG}:${CLASSPATH}

echo "Starting MiningMart from '${MMART_HOME}', using classes from '${MMART_CLASSPATH}'..."

$JAVA \
        -Xmx${MAX_JAVA_MEMORY}m \
        -cp ${CLASSPATH} \
	edu.udo.cs.miningmart.gui.application.MiningMartApplication $@