/*
 * Decompiled with CFR 0.152.
 */
package libsvm;

import libsvm.Cache;
import libsvm.Kernel;
import libsvm.svm_parameter;
import libsvm.svm_problem;

class ONE_CLASS_Q
extends Kernel {
    private final Cache cache;
    private final float[] QD;

    ONE_CLASS_Q(svm_problem prob, svm_parameter param) {
        super(prob.l, prob.x, param);
        this.cache = new Cache(prob.l, (int)(param.cache_size * 1048576.0));
        this.QD = new float[prob.l];
        for (int i = 0; i < prob.l; ++i) {
            this.QD[i] = (float)this.kernel_function(i, i);
        }
    }

    float[] get_Q(int i, int len) {
        float[][] data = new float[1][];
        int start = this.cache.get_data(i, data, len);
        if (start < len) {
            for (int j = start; j < len; ++j) {
                data[0][j] = (float)this.kernel_function(i, j);
            }
        }
        return data[0];
    }

    float[] get_QD() {
        return this.QD;
    }

    void swap_index(int i, int j) {
        this.cache.swap_index(i, j);
        super.swap_index(i, j);
        float _ = this.QD[i];
        this.QD[i] = this.QD[j];
        this.QD[j] = _;
    }
}

