/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools.math;

public class WindowFunction {
    public static final String[] FUNCTIONS = new String[]{"None", "Hanning", "Hamming", "Blackman", "Blackman-Harris", "Bartlett", "Rectangle"};
    public static final int NONE = 0;
    public static final int HANNING = 1;
    public static final int HAMMING = 2;
    public static final int BLACKMAN = 3;
    public static final int BLACKMAN_HARRIS = 4;
    public static final int BARTLETT = 5;
    public static final int RECTANGLE = 6;
    private int type;
    private int length;

    public WindowFunction(int type, int maxIndex) {
        this.type = type;
        this.length = maxIndex;
    }

    public double getFactor(int n) {
        switch (this.type) {
            case 1: {
                return 0.5 - 0.5 * Math.cos(Math.PI * 2 * (double)n / (double)this.length);
            }
            case 2: {
                return 0.54 - 0.46 * Math.cos(Math.PI * 2 * (double)n / (double)this.length);
            }
            case 3: {
                return 0.42 - 0.5 * Math.cos(Math.PI * 2 * (double)n / (double)this.length) + 0.08 * Math.cos(Math.PI * 4 * (double)n / (double)this.length);
            }
            case 4: {
                return 0.35875 - 0.48829 * Math.cos(Math.PI * 2 * (double)n / (double)this.length) + 0.14128 * Math.cos(Math.PI * 4 * (double)n / (double)this.length) - 0.01168 * Math.cos(Math.PI * 6 * (double)n / (double)this.length);
            }
            case 5: {
                return 1.0 - Math.abs(2.0 * (double)(n - this.length / 2) / (double)this.length);
            }
        }
        return 1.0;
    }
}

