/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools.math;

import edu.udo.cs.yale.operator.ResultObjectAdapter;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;

public abstract class Averagable
extends ResultObjectAdapter
implements Cloneable,
Comparable {
    private double meanSum = Double.NaN;
    private double meanSquaredSum = Double.NaN;
    private int averageCount = 0;

    public abstract String getName();

    public abstract double getValue();

    public abstract double getVariance();

    protected abstract void cloneAveragable(Averagable var1);

    protected abstract void buildSingleAverage(Averagable var1);

    public final void buildAverage(Averagable averagable) {
        double value;
        if (!averagable.getClass().equals(this.getClass())) {
            throw new RuntimeException("Cannot build average of different averagable types (" + this.getClass().getName() + "/" + averagable.getClass().getName() + ").");
        }
        if (!averagable.getName().equals(this.getName())) {
            throw new RuntimeException("Cannot build average of different averagable types (" + this.getName() + "/" + averagable.getName() + ").");
        }
        if (this.averageCount == 0) {
            this.meanSum = value = this.getValue();
            this.meanSquaredSum = value * value;
            this.averageCount = 1;
        }
        value = averagable.getValue();
        this.meanSum += value;
        this.meanSquaredSum += value * value;
        ++this.averageCount;
        this.buildSingleAverage(averagable);
    }

    public double getStandardDeviation() {
        double variance = this.getVariance();
        if (Double.isNaN(variance)) {
            return Double.NaN;
        }
        return Math.sqrt(variance);
    }

    public double getMakroAverage() {
        return this.meanSum / (double)this.averageCount;
    }

    public double getMakroVariance() {
        double mean = this.getMakroAverage();
        return this.meanSquaredSum / (double)this.averageCount - mean * mean;
    }

    public double getMakroStandardDeviation() {
        return Math.sqrt(this.getMakroVariance());
    }

    public Object clone() {
        try {
            Class<?> clazz = this.getClass();
            Averagable clone = (Averagable)clazz.newInstance();
            clone.meanSum = this.meanSum;
            clone.meanSquaredSum = this.meanSquaredSum;
            clone.averageCount = this.averageCount;
            clone.cloneAveragable(this);
            return clone;
        }
        catch (Exception e) {
            LogService.logException("In Averagable.clone():", e);
            return null;
        }
    }

    public boolean formatPercent() {
        return false;
    }

    protected String formatValue(double value) {
        if (Double.isNaN(value)) {
            return "unknown";
        }
        if (this.formatPercent()) {
            return Tools.formatPercent(value);
        }
        return Tools.formatNumber(value);
    }

    protected String formatDeviation(double dev) {
        if (this.formatPercent()) {
            return Tools.formatPercent(dev);
        }
        return Tools.formatNumber(dev);
    }

    public String toString() {
        double makroAverage;
        String str = this.getName() + ": " + this.formatValue(this.getValue());
        double sd = this.getStandardDeviation();
        if (!Double.isNaN(sd)) {
            str = str + " +/- " + this.formatDeviation(sd);
        }
        if (this.averageCount > 0 && !Double.isNaN(makroAverage = this.getMakroAverage())) {
            str = str + " (makro avg: " + this.formatValue(makroAverage);
            sd = this.getMakroStandardDeviation();
            if (!Double.isNaN(sd)) {
                str = str + " +/- " + this.formatDeviation(sd);
            }
            str = str + ")";
        }
        return str;
    }

    public String toHTML() {
        return this.toString();
    }
}

