/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools.att;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Ontology;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.XMLException;
import edu.udo.cs.yale.tools.att.AttributeDataSources;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AttributeDataSource {
    public static final String[] KNOWN_TYPES = new String[]{"attribute", "label", "id", "weight", "batch", "cluster"};
    private File file;
    private int column;
    private Attribute attribute;
    private String attributeType;

    public AttributeDataSource(Attribute attribute, File file, int column, String attributeType) {
        this.attribute = attribute;
        this.file = file;
        this.column = column;
        this.attributeType = attributeType;
    }

    public void setAttribute(Attribute attribute) {
        this.attribute = attribute;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public int getColumn() {
        return this.column;
    }

    public File getFile() {
        return this.file;
    }

    public void setType(String type) {
        this.attributeType = type;
    }

    public String getType() {
        return this.attributeType;
    }

    public void setSource(File file, int column) {
        this.file = file;
        this.column = column;
    }

    public void writeXML(PrintWriter out, File defaultSource) throws IOException {
        String unit;
        out.println("  <" + this.attributeType);
        out.println("    name       =\"" + this.attribute.getName() + "\"");
        if (!this.getFile().equals(defaultSource)) {
            out.println("    sourcefile =\"" + this.getFile().getAbsolutePath() + "\"");
        }
        out.println("    sourcecol  =\"" + (this.getColumn() + 1) + "\"");
        out.println("    valuetype  =\"" + Ontology.ATTRIBUTE_VALUE_TYPE.mapIndex(this.attribute.getValueType()) + "\"");
        out.println("    blocktype  =\"" + Ontology.ATTRIBUTE_BLOCK_TYPE.mapIndex(this.attribute.getBlockType()) + "\"");
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(this.attribute.getValueType(), 1)) {
            out.print("    classes    =\"");
            Iterator i = this.attribute.getValues().iterator();
            boolean first = true;
            while (i.hasNext()) {
                if (!first) {
                    out.print(" ");
                }
                out.print(i.next());
                first = false;
            }
            out.println("\"");
        }
        if (Ontology.ATTRIBUTE_BLOCK_TYPE.isA(this.attribute.getBlockType(), 1)) {
            out.print("    blocknumber    =\"" + this.attribute.getBlockNumber() + "\"");
        }
        if ((unit = this.attribute.unitToString()).length() > 0) {
            out.print("    unit       =\"" + unit + "\"");
        }
        out.println("  />");
    }

    public static AttributeDataSources createAttributeDataSources(File attributeDescriptionFile, boolean sourceColRequired) throws XMLException, ParserConfigurationException, SAXException, IOException {
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(attributeDescriptionFile);
        Element attributeSet = document.getDocumentElement();
        if (!attributeSet.getTagName().equals("attributeset")) {
            throw new XMLException("Outer tag of attribute description file must be <attributeset>");
        }
        File defaultSource = null;
        if (attributeSet.getAttribute("default_source") != null) {
            defaultSource = Tools.getFile(attributeDescriptionFile.getParentFile(), attributeSet.getAttribute("default_source"));
        }
        LinkedList<AttributeDataSource> attributeDataSources = new LinkedList<AttributeDataSource>();
        NodeList attributes = attributeSet.getChildNodes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            int valueType;
            int lastSourceCol;
            int firstSourceCol;
            String file;
            String unit;
            String name;
            String type;
            int blockType;
            Element attributeTag;
            block37: {
                Attr blockTypeAttr;
                block36: {
                    Node node = attributes.item(i);
                    if (!(node instanceof Element)) continue;
                    attributeTag = (Element)node;
                    blockType = 1;
                    type = attributeTag.getTagName();
                    name = attributeTag.getAttribute("name");
                    if (!name.equals("attribute")) {
                        blockType = 3;
                    }
                    unit = attributeTag.getAttribute("unit");
                    file = null;
                    Attr fileAttr = attributeTag.getAttributeNode("sourcefile");
                    if (fileAttr != null) {
                        file = fileAttr.getValue();
                    }
                    firstSourceCol = -1;
                    Attr sourcecolAttr = attributeTag.getAttributeNode("sourcecol");
                    if (sourcecolAttr != null) {
                        if (sourcecolAttr.getValue().equals("none")) {
                            firstSourceCol = -1;
                        } else {
                            try {
                                firstSourceCol = Integer.parseInt(sourcecolAttr.getValue()) - 1;
                            }
                            catch (NumberFormatException e) {
                                throw new XMLException("Attribute sourcecol must be 'none' or an integer (was: '" + sourcecolAttr.getValue() + "')!");
                            }
                        }
                    }
                    lastSourceCol = -1;
                    Attr sourceEndAttr = attributeTag.getAttributeNode("sourcecol_end");
                    if (sourceEndAttr != null) {
                        try {
                            lastSourceCol = Integer.parseInt(sourceEndAttr.getValue()) - 1;
                        }
                        catch (NumberFormatException e) {
                            throw new XMLException("Attribute sourcecol_end must be 'none' or an integer (was: '" + sourceEndAttr.getValue() + "')!");
                        }
                    }
                    valueType = 0;
                    Attr valueTypeAttr = attributeTag.getAttributeNode("valuetype");
                    if (valueTypeAttr != null) {
                        try {
                            valueType = Integer.parseInt(valueTypeAttr.getValue());
                        }
                        catch (NumberFormatException e) {
                            valueType = Ontology.ATTRIBUTE_VALUE_TYPE.mapName(valueTypeAttr.getValue());
                            if (valueType >= 0) break block36;
                            throw new XMLException("valuetype must be an index number or a legal value type name (was: '" + valueTypeAttr.getValue() + "')");
                        }
                    }
                }
                if ((blockTypeAttr = attributeTag.getAttributeNode("blocktype")) != null) {
                    try {
                        blockType = Integer.parseInt(blockTypeAttr.getValue());
                    }
                    catch (NumberFormatException e) {
                        blockType = Ontology.ATTRIBUTE_BLOCK_TYPE.mapName(blockTypeAttr.getValue());
                        if (blockType >= 0) break block37;
                        throw new XMLException("blocktype must be an index number or a legal block type name (was: '" + blockTypeAttr.getValue() + "')");
                    }
                }
            }
            int blockNumber = -1;
            Attr blockNumberAttr = attributeTag.getAttributeNode("blocknumber");
            if (blockNumberAttr != null) {
                try {
                    blockNumber = Integer.parseInt(blockNumberAttr.getValue());
                }
                catch (NumberFormatException e) {
                    throw new XMLException("Illegal blocknumber for attribute '" + name + "': " + blockNumberAttr.getValue());
                }
                if (Ontology.ATTRIBUTE_BLOCK_TYPE.isA(blockType, 3) && blockNumber != -1) {
                    throw new XMLException("Cannot create an attribute '" + name + "' with block type 'single value' and blocknumber '" + blockNumber + "'. Blocknumbers should only be used for attributes which are part of a series.");
                }
            }
            LinkedList<String> classList = null;
            Attr classesAttr = attributeTag.getAttributeNode("classes");
            if (classesAttr != null) {
                classList = new LinkedList<String>();
                StringTokenizer tokenizer = new StringTokenizer(classesAttr.getValue());
                while (tokenizer.hasMoreTokens()) {
                    classList.add(tokenizer.nextToken());
                }
            }
            if (lastSourceCol == -1) {
                lastSourceCol = firstSourceCol;
            }
            if (sourceColRequired) {
                if (firstSourceCol < 0) {
                    throw new XMLException("sourcecol not defined for " + type + " '" + name + "'!");
                }
                if (lastSourceCol < firstSourceCol) {
                    throw new XMLException("sourcecol < sourcecol_end must hold.");
                }
            }
            for (int col = firstSourceCol; col <= lastSourceCol; ++col) {
                Attribute attribute;
                int thisBlockType = blockType;
                String theName = name;
                if (lastSourceCol > firstSourceCol) {
                    theName = name + "_" + (col + 1);
                    if (col == firstSourceCol && blockType == 1) {
                        thisBlockType = 7;
                    }
                    if (col == lastSourceCol && blockType == 1) {
                        thisBlockType = 8;
                    }
                }
                if ((attribute = AttributeFactory.createAttribute(theName, valueType, blockType, blockNumber, unit)).isNominal() && classList != null) {
                    Iterator c = classList.iterator();
                    while (c.hasNext()) {
                        attribute.mapString((String)c.next());
                    }
                }
                if (!attribute.isNominal() && classList != null && classList.size() != 0) {
                    LogService.logMessage("Ignoring classes for non-nominal attribute " + theName + ".", 4);
                }
                attributeDataSources.add(new AttributeDataSource(attribute, file != null ? Tools.getFile(attributeDescriptionFile.getParentFile(), file) : defaultSource, col, type));
            }
        }
        return new AttributeDataSources(attributeDataSources, defaultSource);
    }

    public String toString() {
        return this.attribute.getName() + " (" + this.attributeType + ") from " + this.file.getName() + " (" + this.column + ")";
    }
}

