/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools;

import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.tools.LogService;
import java.util.Random;
import weka.classifiers.Classifier;
import weka.classifiers.UpdateableClassifier;
import weka.classifiers.trees.UserClassifier;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class WekaLearnerCapabilities {
    private static final Instances[] dataSets = new Instances[9];

    public static boolean supportsCapability(Classifier engine, LearnerCapability lc) {
        if (engine instanceof UserClassifier) {
            if (lc == LearnerCapability.POLYNOMINAL_ATTRIBUTES) {
                return true;
            }
            if (lc == LearnerCapability.BINOMINAL_ATTRIBUTES) {
                return true;
            }
            if (lc == LearnerCapability.NUMERICAL_ATTRIBUTES) {
                return true;
            }
            if (lc == LearnerCapability.POLYNOMINAL_CLASS) {
                return true;
            }
            if (lc == LearnerCapability.BINOMINAL_CLASS) {
                return true;
            }
            return lc == LearnerCapability.NUMERICAL_CLASS;
        }
        try {
            if (lc == LearnerCapability.POLYNOMINAL_ATTRIBUTES) {
                if (WekaLearnerCapabilities.condition(engine, 6)) {
                    return true;
                }
                if (WekaLearnerCapabilities.condition(engine, 7)) {
                    return true;
                }
                return WekaLearnerCapabilities.condition(engine, 8);
            }
            if (lc == LearnerCapability.BINOMINAL_ATTRIBUTES) {
                if (WekaLearnerCapabilities.condition(engine, 3)) {
                    return true;
                }
                if (WekaLearnerCapabilities.condition(engine, 4)) {
                    return true;
                }
                return WekaLearnerCapabilities.condition(engine, 5);
            }
            if (lc == LearnerCapability.NUMERICAL_ATTRIBUTES) {
                if (WekaLearnerCapabilities.condition(engine, 0)) {
                    return true;
                }
                if (WekaLearnerCapabilities.condition(engine, 1)) {
                    return true;
                }
                return WekaLearnerCapabilities.condition(engine, 2);
            }
            if (lc == LearnerCapability.POLYNOMINAL_CLASS) {
                if (WekaLearnerCapabilities.condition(engine, 2)) {
                    return true;
                }
                if (WekaLearnerCapabilities.condition(engine, 5)) {
                    return true;
                }
                return WekaLearnerCapabilities.condition(engine, 8);
            }
            if (lc == LearnerCapability.BINOMINAL_CLASS) {
                if (WekaLearnerCapabilities.condition(engine, 1)) {
                    return true;
                }
                if (WekaLearnerCapabilities.condition(engine, 4)) {
                    return true;
                }
                return WekaLearnerCapabilities.condition(engine, 7);
            }
            if (lc == LearnerCapability.NUMERICAL_CLASS) {
                if (WekaLearnerCapabilities.condition(engine, 0)) {
                    return true;
                }
                if (WekaLearnerCapabilities.condition(engine, 3)) {
                    return true;
                }
                return WekaLearnerCapabilities.condition(engine, 6);
            }
            if (lc == LearnerCapability.UPDATABLE && engine instanceof UpdateableClassifier) {
                return true;
            }
        }
        catch (Exception e) {
            LogService.logMessage("WekaLearnerCapabilities: Error creating instance of classifier", 6);
            return false;
        }
        return false;
    }

    private static boolean condition(Classifier classifier, int i) throws Exception {
        try {
            classifier.buildClassifier(dataSets[i]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static Instances makeTestDataset(int seed, int numInstances, int numNominal, int numNumeric, int numClasses, boolean numericClass) throws Exception {
        int i;
        int numAttributes = numNominal + numNumeric + 1;
        Random random = new Random(seed);
        FastVector attributes = new FastVector(numAttributes);
        for (i = 0; i < numNominal; ++i) {
            FastVector nomStrings = new FastVector(i + 1);
            for (int j = 0; j <= i; ++j) {
                nomStrings.addElement((Object)("a" + (i + 1) + "l" + (j + 1)));
            }
            attributes.addElement((Object)new Attribute("Nominal" + (i + 1), nomStrings));
        }
        for (i = 0; i < numNumeric; ++i) {
            attributes.addElement((Object)new Attribute("Numeric" + (i + 1)));
        }
        if (numericClass) {
            attributes.addElement((Object)new Attribute("Class"));
        } else {
            FastVector nomStrings = new FastVector();
            for (int j = 0; j < numClasses; ++j) {
                nomStrings.addElement((Object)("cl" + (j + 1)));
            }
            attributes.addElement((Object)new Attribute("Class", nomStrings));
        }
        Instances data = new Instances("CheckSet", attributes, numInstances);
        data.setClassIndex(data.numAttributes() - 1);
        for (int i2 = 0; i2 < numInstances; ++i2) {
            Instance current = new Instance(numAttributes);
            current.setDataset(data);
            if (numericClass) {
                current.setClassValue((double)random.nextFloat() * 0.25 + (double)(Math.abs(random.nextInt()) % Math.max(2, numNominal)));
            } else {
                current.setClassValue((double)(Math.abs(random.nextInt()) % data.numClasses()));
            }
            double classVal = current.classValue();
            double newVal = 0.0;
            block10: for (int j = 0; j < numAttributes - 1; ++j) {
                switch (data.attribute(j).type()) {
                    case 0: {
                        newVal = classVal * 4.0 + (double)(random.nextFloat() * 1.0f) - 0.5;
                        current.setValue(j, newVal);
                        continue block10;
                    }
                    case 1: {
                        newVal = (double)random.nextFloat() < 0.2 ? (double)(Math.abs(random.nextInt()) % data.attribute(j).numValues()) : (double)((int)classVal % data.attribute(j).numValues());
                        current.setValue(j, newVal);
                        continue block10;
                    }
                    case 2: {
                        LogService.logMessage("WekaLearnerCapabilities: Huh? this bit isn't implemented yet", 6);
                    }
                }
            }
            data.add(current);
        }
        return data;
    }

    static {
        try {
            WekaLearnerCapabilities.dataSets[0] = WekaLearnerCapabilities.makeTestDataset(42, 1, 0, 2, 0, true);
            WekaLearnerCapabilities.dataSets[1] = WekaLearnerCapabilities.makeTestDataset(42, 1, 0, 2, 2, false);
            WekaLearnerCapabilities.dataSets[2] = WekaLearnerCapabilities.makeTestDataset(42, 1, 0, 2, 3, false);
            WekaLearnerCapabilities.dataSets[3] = WekaLearnerCapabilities.makeTestDataset(42, 1, 2, 0, 0, true);
            WekaLearnerCapabilities.dataSets[4] = WekaLearnerCapabilities.makeTestDataset(42, 1, 2, 0, 2, false);
            WekaLearnerCapabilities.dataSets[5] = WekaLearnerCapabilities.makeTestDataset(42, 1, 2, 0, 3, false);
            WekaLearnerCapabilities.dataSets[6] = WekaLearnerCapabilities.makeTestDataset(42, 1, 3, 0, 0, true);
            WekaLearnerCapabilities.dataSets[7] = WekaLearnerCapabilities.makeTestDataset(42, 1, 3, 0, 2, false);
            WekaLearnerCapabilities.dataSets[8] = WekaLearnerCapabilities.makeTestDataset(42, 1, 3, 0, 3, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

