/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.tools.Ontology;
import java.util.Enumeration;
import java.util.Iterator;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class WekaInstancesAdaptor
extends Instances {
    private ExampleSet exampleSet;
    private boolean labelKnown;
    private boolean associationLearning;

    public WekaInstancesAdaptor(String name, ExampleSet exampleSet, boolean labelKnown, boolean associationLearning) {
        super(name, WekaInstancesAdaptor.getAttributeVector(exampleSet, labelKnown ? exampleSet.getLabel() : exampleSet.getPredictedLabel()), 0);
        this.exampleSet = exampleSet;
        this.labelKnown = labelKnown;
        this.associationLearning = associationLearning;
        if (!associationLearning && (labelKnown ? exampleSet.getLabel() : exampleSet.getPredictedLabel()) != null) {
            this.setClassIndex(exampleSet.getNumberOfAttributes());
        } else {
            this.setClassIndex(-1);
        }
        if (associationLearning) {
            exampleSet.recalculateAllAttributeStatistics();
        }
    }

    public Enumeration enumerateInstances() {
        return new InstanceEnumeration(this, this.exampleSet.getExampleReader());
    }

    public Instance instance(int i) {
        return WekaInstancesAdaptor.toWekaInstance(this.exampleSet.getExample(i), this, this.exampleSet.getLabel(), this.labelKnown, this.associationLearning);
    }

    public int numInstances() {
        return this.exampleSet.getSize();
    }

    private static Instance toWekaInstance(Example example, Instances instances, Attribute label, boolean labelKnown, boolean associationLearning) {
        Instance instance = new Instance(example.getNumberOfAttributes() + (label != null ? 1 : 0));
        instance.setDataset(instances);
        Attribute weightAttribute = example.getAttribute("weight");
        if (weightAttribute != null) {
            instance.setWeight(example.getValue(weightAttribute));
        }
        for (int a = 0; a < example.getNumberOfAttributes(); ++a) {
            Attribute attribute = example.getAttribute(a);
            WekaInstancesAdaptor.setAttributeValue(instance, a, example, attribute, associationLearning);
        }
        if (label != null) {
            if (associationLearning) {
                WekaInstancesAdaptor.setAttributeValue(instance, example.getNumberOfAttributes(), example, label, associationLearning);
            } else if (!labelKnown) {
                instance.setClassMissing();
            } else {
                double v = example.getValue(label);
                if (Double.isNaN(v)) {
                    instance.setClassMissing();
                } else {
                    if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(label.getValueType(), 1)) {
                        try {
                            instance.setClassValue(label.mapIndex((int)v));
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Cannot set class value: " + e);
                        }
                    }
                    try {
                        instance.setClassValue(v);
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot set class value: " + e);
                    }
                }
            }
        }
        return instance;
    }

    private static void setAttributeValue(Instance instance, int index, Example example, Attribute attribute, boolean associationLearning) {
        double value = example.getValue(attribute);
        int mostFrequent = -1;
        if (associationLearning && attribute.isNominal()) {
            mostFrequent = attribute.mapString(attribute.getMode());
        }
        if (Double.isNaN(value)) {
            instance.setMissing(index);
        } else if (attribute.isNominal()) {
            if (associationLearning && value == (double)mostFrequent) {
                instance.setMissing(index);
            } else {
                try {
                    instance.setValue(index, example.getValueAsString(attribute));
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot set attribute value: " + e);
                }
            }
        } else {
            instance.setValue(index, value);
        }
    }

    private static FastVector getAttributeVector(ExampleSet exampleSet, Attribute label) {
        FastVector attributeVector = new FastVector(exampleSet.getNumberOfAttributes() + (label != null ? 1 : 0));
        for (int i = 0; i < exampleSet.getNumberOfAttributes(); ++i) {
            attributeVector.addElement((Object)WekaInstancesAdaptor.toWekaAttribute(exampleSet.getAttribute(i)));
        }
        if (label != null) {
            attributeVector.addElement((Object)WekaInstancesAdaptor.toWekaAttribute(label));
        }
        return attributeVector;
    }

    private static weka.core.Attribute toWekaAttribute(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        weka.core.Attribute result = null;
        if (Ontology.ATTRIBUTE_VALUE_TYPE.isA(attribute.getValueType(), 1)) {
            FastVector nominalValues = new FastVector(attribute.getValues().size());
            Iterator c = attribute.getValues().iterator();
            while (c.hasNext()) {
                nominalValues.addElement((Object)((String)c.next()));
            }
            result = new weka.core.Attribute(attribute.getName(), nominalValues);
        } else {
            result = new weka.core.Attribute(attribute.getName());
        }
        return result;
    }

    private class InstanceEnumeration
    implements Enumeration {
        private Instances instances;
        private ExampleReader reader;

        public InstanceEnumeration(Instances instances, ExampleReader reader) {
            this.instances = instances;
            this.reader = reader;
        }

        public Object nextElement() {
            return WekaInstancesAdaptor.toWekaInstance(this.reader.next(), this.instances, WekaInstancesAdaptor.this.exampleSet.getLabel(), WekaInstancesAdaptor.this.labelKnown, WekaInstancesAdaptor.this.associationLearning);
        }

        public boolean hasMoreElements() {
            return this.reader.hasNext();
        }
    }
}

