/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools;

import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.ParameterService;
import edu.udo.cs.yale.tools.plugin.Plugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class Tools {
    public static final String RESOURCE_PREFIX = "edu/udo/cs/yale/resources/";
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    private static final NumberFormat PERCENT_FORMAT = NumberFormat.getPercentInstance();
    public static final String[] TRUE_STRINGS = new String[]{"true", "on", "yes", "y"};
    public static final String[] FALSE_STRINGS = new String[]{"false", "off", "no", "n"};
    static /* synthetic */ Class class$edu$udo$cs$yale$tools$Tools;

    public static String formatPercent(double value) {
        int percentDigits = 2;
        try {
            String percentDigitsString = System.getProperty("yale.gui.fractiondigits.percent");
            percentDigits = Integer.parseInt(percentDigitsString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        PERCENT_FORMAT.setMaximumFractionDigits(percentDigits);
        PERCENT_FORMAT.setMinimumFractionDigits(percentDigits);
        return PERCENT_FORMAT.format(value);
    }

    public static String formatNumber(double value) {
        int numberDigits = 3;
        try {
            String numberDigitsString = System.getProperty("yale.gui.fractiondigits.numbers");
            numberDigits = Integer.parseInt(numberDigitsString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        NUMBER_FORMAT.setMaximumFractionDigits(numberDigits);
        NUMBER_FORMAT.setMinimumFractionDigits(numberDigits);
        return NUMBER_FORMAT.format(value);
    }

    public static String formatNumber(double value, int numberOfDigits) {
        NUMBER_FORMAT.setMaximumFractionDigits(numberOfDigits);
        NUMBER_FORMAT.setMinimumFractionDigits(numberOfDigits);
        return NUMBER_FORMAT.format(value);
    }

    public static final String ordinalNumber(int n) {
        if (n % 10 == 1 && n % 100 != 11) {
            return n + "st";
        }
        if (n % 10 == 2 && n % 100 != 12) {
            return n + "nd";
        }
        if (n % 10 == 3 && n % 100 != 13) {
            return n + "rd";
        }
        return n + "th";
    }

    public static String classNameWOPackage(Class c) {
        return c.getName().substring(c.getName().lastIndexOf(".") + 1);
    }

    public static String readOutput(BufferedReader in) throws IOException {
        StringBuffer output = new StringBuffer();
        String line = "";
        while ((line = in.readLine()) != null) {
            output.append(line);
            output.append("\n");
        }
        return output.toString();
    }

    public static File getFile(File parent, String name) {
        File file = new File(name);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(parent, name);
    }

    public static boolean mkdir(File dir) {
        if (dir == null) {
            return true;
        }
        if (dir.exists()) {
            return true;
        }
        File parent = dir.getParentFile();
        if (parent == null) {
            return true;
        }
        if (!parent.exists() && !Tools.mkdir(parent)) {
            return false;
        }
        return dir.mkdir();
    }

    public static void waitForProcess(Operator operator, Process process, String name) throws OperatorException {
        try {
            LogService.logMessage("Waiting for process '" + name + "' to die.", 0);
            int value = process.waitFor();
            if (value != 0) {
                throw new UserError(operator, 306, new Object[]{name, new Integer(value)});
            }
            LogService.logMessage("Process '" + name + "' terminated successfully.", 2);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted waiting for process '" + name + "' to die.", e);
        }
    }

    public static void sendEmail(String address, String subject, String content) {
        try {
            String command = ParameterService.getProperty("yale.tools.sendmail.command");
            LogService.logMessage("Executing '" + command + "'", 0);
            Process sendmail = Runtime.getRuntime().exec(new String[]{command, address});
            PrintStream out = new PrintStream(sendmail.getOutputStream());
            out.println("Subject: " + subject);
            out.println("From: Yale");
            out.println("To: " + address);
            out.println();
            out.println(content);
            out.close();
            Tools.waitForProcess(null, sendmail, command);
        }
        catch (Throwable e) {
            LogService.logException("Cannot send mail to " + address, e);
        }
    }

    public static InputStream openResource(String name) throws IOException {
        return Tools.getResource(name).openStream();
    }

    public static URL getResource(String name) {
        return Tools.getResource((class$edu$udo$cs$yale$tools$Tools == null ? (class$edu$udo$cs$yale$tools$Tools = Tools.class$("edu.udo.cs.yale.tools.Tools")) : class$edu$udo$cs$yale$tools$Tools).getClassLoader(), name);
    }

    public static URL getResource(ClassLoader loader, String name) {
        return loader.getResource(RESOURCE_PREFIX + name);
    }

    public static String readTextFile(File file) throws IOException {
        return Tools.readTextFile(new FileReader(file));
    }

    public static String readTextFile(Reader r) throws IOException {
        StringBuffer contents = new StringBuffer();
        BufferedReader reader = new BufferedReader(r);
        String line = "";
        while ((line = reader.readLine()) != null) {
            contents.append(line + "\n");
        }
        reader.close();
        return contents.toString();
    }

    public static boolean booleanValue(String string, boolean deflt) {
        int i;
        if (string == null) {
            return deflt;
        }
        string = string.toLowerCase().trim();
        for (i = 0; i < TRUE_STRINGS.length; ++i) {
            if (!TRUE_STRINGS[i].equals(string)) continue;
            return true;
        }
        for (i = 0; i < FALSE_STRINGS.length; ++i) {
            if (!FALSE_STRINGS[i].equals(string)) continue;
            return false;
        }
        return deflt;
    }

    public static File findSourceFile(StackTraceElement e) {
        try {
            Class<?> clazz = Class.forName(e.getClassName());
            while (clazz.getDeclaringClass() != null) {
                clazz = clazz.getDeclaringClass();
            }
            String filename = clazz.getName().replace('.', File.separatorChar);
            return ParameterService.getSourceFile(filename + ".java");
        }
        catch (Throwable t) {
            String filename = e.getClassName().replace('.', File.separatorChar);
            return ParameterService.getSourceFile(filename + ".java");
        }
    }

    public static Process launchFileEditor(File file, int line) throws IOException {
        String editor = System.getProperty("yale.tools.editor");
        if (editor == null) {
            throw new IOException("Property 'yale.tools.editor' undefined.");
        }
        editor = editor.replaceAll("%f", file.getAbsolutePath());
        editor = editor.replaceAll("%l", line + "");
        return Runtime.getRuntime().exec(editor);
    }

    public static String escapeHTML(String string) {
        if (string == null) {
            return "null";
        }
        string = string.replaceAll("<", "&lt;");
        string = string.replaceAll(">", "&gt;");
        return string;
    }

    public static void findImplementationsInJar(JarFile jar, Class superClass, List implementations) {
        Tools.findImplementationsInJar((class$edu$udo$cs$yale$tools$Tools == null ? (class$edu$udo$cs$yale$tools$Tools = Tools.class$("edu.udo.cs.yale.tools.Tools")) : class$edu$udo$cs$yale$tools$Tools).getClassLoader(), jar, superClass, implementations);
    }

    public static void findImplementationsInJar(ClassLoader loader, JarFile jar, Class superClass, List implementations) {
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            String name = entry.getName();
            int dotClass = name.lastIndexOf(".class");
            if (dotClass < 0) continue;
            name = name.substring(0, dotClass);
            name = name.replaceAll("/", "\\.");
            try {
                Class<?> c = loader.loadClass(name);
                if (!superClass.isAssignableFrom(c) || Modifier.isAbstract(c.getModifiers())) continue;
                implementations.add(name);
            }
            catch (Throwable t) {}
        }
    }

    public static Class classForName(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            Iterator i = Plugin.getAllPlugins().iterator();
            while (i.hasNext()) {
                Plugin p = (Plugin)i.next();
                try {
                    return p.getClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            throw new ClassNotFoundException(className);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

