/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools;

import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.operator.ResultObject;
import edu.udo.cs.yale.tools.LogService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.GregorianCalendar;

public class ResultService {
    private static PrintStream out = System.out;

    public static void init(String filename) {
        if (filename == null) {
            LogService.logMessage("No filename given for result file, using stdout for logging results!", 4);
            ResultService.init(System.out);
        } else if (filename.equals("stderr")) {
            ResultService.init(System.err);
        } else if (filename.equals("stdout")) {
            ResultService.init(System.out);
        } else {
            PrintStream out;
            try {
                out = new PrintStream(new FileOutputStream(new File(filename)));
            }
            catch (IOException e) {
                LogService.logMessage("Cannot create resultfile '" + filename + "': " + e.getClass() + ":" + e.getMessage(), 8);
                LogService.logMessage("using stdout", 8);
                out = System.out;
            }
            ResultService.init(out);
        }
    }

    public static void init(PrintStream outStream) {
        out = outStream;
    }

    public static void init(Experiment experiment) {
        String filename = experiment.getRootOperator().getParameterAsString("resultfile");
        ResultService.init(filename);
    }

    public static void close() {
        out.close();
    }

    public static void logResult(String result) {
        out.println(ResultService.getTime() + " " + result);
    }

    public static void logResult(ResultObject resultObject) {
        ResultService.logResult(resultObject.toResultString());
    }

    private static String getTime() {
        GregorianCalendar cal = (GregorianCalendar)GregorianCalendar.getInstance();
        String time = ResultService.getTwoDigits(cal.get(5)) + "." + ResultService.getTwoDigits(cal.get(2) + 1) + "." + cal.get(1) + " " + ResultService.getTwoDigits(cal.get(11)) + ":" + ResultService.getTwoDigits(cal.get(12)) + ":" + ResultService.getTwoDigits(cal.get(13));
        return time;
    }

    static String getTwoDigits(int i) {
        return (i < 10 ? "0" : "") + i;
    }
}

