/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools;

import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorCreationException;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.tools.GenericOperatorFactory;
import edu.udo.cs.yale.tools.GroupTree;
import edu.udo.cs.yale.tools.LogService;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class OperatorService {
    private static Map names2descriptions = new HashMap();
    private static GroupTree groupTree = new GroupTree("");
    private static Map ioObjects = new TreeMap();
    static /* synthetic */ Class class$edu$udo$cs$yale$tools$OperatorService;
    static /* synthetic */ Class class$edu$udo$cs$yale$tools$GenericOperatorFactory;

    public static void registerOperators(String name, InputStream operatorsXML, ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = (class$edu$udo$cs$yale$tools$OperatorService == null ? (class$edu$udo$cs$yale$tools$OperatorService = OperatorService.class$("edu.udo.cs.yale.tools.OperatorService")) : class$edu$udo$cs$yale$tools$OperatorService).getClassLoader();
        }
        LogService.logMessage("Loading operators from '" + name + "'.", 3);
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(operatorsXML);
        }
        catch (Exception e) {
            LogService.logException("Cannot read operator description file '" + name + "': no valid XML!", e);
        }
        if (document != null) {
            if (!document.getDocumentElement().getTagName().toLowerCase().equals("operators")) {
                LogService.logMessage("Operator description file '" + name + "': outermost operator must be <operators>!", 6);
                return;
            }
            NodeList factoryTags = document.getDocumentElement().getElementsByTagName("factory");
            for (int i = 0; i < factoryTags.getLength(); ++i) {
                Element factoryTag = (Element)factoryTags.item(i);
                Attr classAttr = factoryTag.getAttributeNode("class");
                if (classAttr == null) {
                    LogService.logMessage("Operator description file '" + name + "': factory tag must provide class attribute!", 6);
                    continue;
                }
                Class<?> factoryClass = null;
                try {
                    factoryClass = classLoader.loadClass(classAttr.getValue());
                }
                catch (ClassNotFoundException e) {
                    LogService.logMessage("Operator factory class '" + classAttr.getValue() + "' not found!", 6);
                }
                if (factoryClass == null) continue;
                if ((class$edu$udo$cs$yale$tools$GenericOperatorFactory == null ? OperatorService.class$("edu.udo.cs.yale.tools.GenericOperatorFactory") : class$edu$udo$cs$yale$tools$GenericOperatorFactory).isAssignableFrom(factoryClass)) {
                    GenericOperatorFactory factory = null;
                    try {
                        factory = (GenericOperatorFactory)factoryClass.newInstance();
                    }
                    catch (Exception e) {
                        LogService.logMessage("Cannot instantiate operator factory class '" + factoryClass.getName() + "'!", 6);
                    }
                    if (factory == null) continue;
                    factory.registerOperators();
                    continue;
                }
                LogService.logMessage("Operator description file '" + name + "': only subclasses of GenericOperatorFactory may be defined as class, was '" + classAttr.getValue() + "'!", 6);
            }
            NodeList operatorTags = document.getDocumentElement().getElementsByTagName("operator");
            for (int i = 0; i < operatorTags.getLength(); ++i) {
                Element currentElement = (Element)operatorTags.item(i);
                try {
                    OperatorService.registerOperator(currentElement, classLoader);
                    continue;
                }
                catch (Exception e) {
                    Attr currentNameAttr = currentElement.getAttributeNode("name");
                    if (currentNameAttr != null) {
                        LogService.logMessage("Cannot register '" + currentNameAttr.getValue() + "': " + e, 6);
                        continue;
                    }
                    LogService.logMessage("Cannot register '" + currentElement + "': " + e, 6);
                }
            }
        }
    }

    private static void registerOperator(Element operatorTag, ClassLoader classLoader) throws Exception {
        Attr nameAttr = operatorTag.getAttributeNode("name");
        Attr classAttr = operatorTag.getAttributeNode("class");
        if (nameAttr == null) {
            throw new Exception("Missing name for <operator> tag");
        }
        if (classAttr == null) {
            throw new Exception("Missing class for <operator> tag");
        }
        OperatorService.registerOperator(classLoader, nameAttr.getValue(), classAttr.getValue(), operatorTag.getAttribute("description"), operatorTag.getAttribute("group"), operatorTag.getAttribute("icon"));
    }

    public static void registerOperator(ClassLoader classLoader, String name, String clazz, String descr, String group, String icon) throws Exception {
        OperatorService.registerOperator(new OperatorDescription(classLoader, name, clazz, descr, group, icon));
    }

    public static void registerOperator(OperatorDescription description) throws Exception {
        OperatorDescription oldDescription = (OperatorDescription)names2descriptions.get(description.getName());
        if (oldDescription != null) {
            LogService.logMessage("An operator '" + description.getName() + "' was already registered. Overwriting...", 4);
        }
        names2descriptions.put(description.getName(), description);
        Operator currentOperator = description.createOperatorInstance();
        OperatorService.checkIOObjects(currentOperator.getInputClasses());
        OperatorService.checkIOObjects(currentOperator.getOutputClasses());
        String groupString = description.getGroup();
        String[] groupNames = groupString.split("\\.");
        GroupTree currentGroup = groupTree;
        for (int j = 0; j < groupNames.length; ++j) {
            GroupTree subGroup = currentGroup.getSubGroup(groupNames[j]);
            if (subGroup == null) {
                subGroup = new GroupTree(groupNames[j]);
                currentGroup.addSubGroup(subGroup);
            }
            currentGroup = subGroup;
        }
        currentGroup.addOperatorDescription(description);
    }

    private static void checkIOObjects(Class[] objects) {
        for (int j = 0; j < objects.length; ++j) {
            String current = objects[j].getName();
            ioObjects.put(current.substring(current.lastIndexOf(".") + 1), objects[j]);
        }
    }

    public static Set getIOObjectsNames() {
        return ioObjects.keySet();
    }

    public static Set getOperatorsDelivering(Class ioObject) {
        HashSet<OperatorDescription> result = new HashSet<OperatorDescription>();
        Iterator i = names2descriptions.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            OperatorDescription description = (OperatorDescription)names2descriptions.get(name);
            try {
                Operator currentOperator = description.createOperatorInstance();
                if (!OperatorService.containsClass(currentOperator.getOutputClasses(), ioObject)) continue;
                result.add(description);
            }
            catch (Exception e) {}
        }
        return result;
    }

    public static Set getOperatorsRequiring(Class ioObject) {
        HashSet<OperatorDescription> result = new HashSet<OperatorDescription>();
        Iterator i = names2descriptions.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            OperatorDescription description = (OperatorDescription)names2descriptions.get(name);
            try {
                Operator currentOperator = description.createOperatorInstance();
                if (!OperatorService.containsClass(currentOperator.getInputClasses(), ioObject)) continue;
                result.add(description);
            }
            catch (Exception e) {}
        }
        return result;
    }

    private static boolean containsClass(Class[] types, Class type) {
        for (int i = 0; i < types.length; ++i) {
            if (!type.isAssignableFrom(types[i])) continue;
            return true;
        }
        return false;
    }

    public static Class getIOObjectClass(String name) {
        return (Class)ioObjects.get(name);
    }

    public static Set getOperatorNames() {
        return names2descriptions.keySet();
    }

    public static GroupTree getGroups() {
        return groupTree;
    }

    public static OperatorDescription[] getOperatorDescriptions(Class clazz) {
        LinkedList<OperatorDescription> result = new LinkedList<OperatorDescription>();
        Iterator i = names2descriptions.keySet().iterator();
        while (i.hasNext()) {
            OperatorDescription current = (OperatorDescription)names2descriptions.get(i.next());
            if (!current.getOperatorClass().equals(clazz)) continue;
            result.add(current);
        }
        OperatorDescription[] resultArray = new OperatorDescription[result.size()];
        result.toArray(resultArray);
        return resultArray;
    }

    public static OperatorDescription getOperatorDescription(String completeName) {
        return (OperatorDescription)names2descriptions.get(completeName);
    }

    public static Operator createOperator(String className) throws OperatorCreationException {
        OperatorDescription description = (OperatorDescription)names2descriptions.get(className);
        if (description == null) {
            throw new OperatorCreationException(4, className, null);
        }
        return OperatorService.createOperator(description);
    }

    public static Operator createOperator(OperatorDescription description) throws OperatorCreationException {
        return description.createOperatorInstance();
    }

    public static Operator createOperator(Class clazz) throws OperatorCreationException {
        OperatorDescription[] descriptions = OperatorService.getOperatorDescriptions(clazz);
        if (descriptions.length == 0) {
            throw new OperatorCreationException(4, clazz.getName(), null);
        }
        if (descriptions.length > 1) {
            throw new OperatorCreationException(5, clazz.getName(), null);
        }
        return descriptions[0].createOperatorInstance();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

