/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.tools;

import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.Yale;
import edu.udo.cs.yale.gui.YaleGUI;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.tools.FormattedPrintStream;
import edu.udo.cs.yale.tools.ParameterService;
import edu.udo.cs.yale.tools.StreamMultiplier;
import edu.udo.cs.yale.tools.Tools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.util.Date;

public class LogService {
    public static final int MINIMUM = 0;
    public static final int IO = 1;
    public static final int STATUS = 2;
    public static final int INIT = 3;
    public static final int WARNING = 4;
    public static final int EXCEPTION = 5;
    public static final int ERROR = 6;
    public static final int FATAL = 7;
    public static final int MAXIMUM = 8;
    public static final int OFF = 9;
    public static final String[] LOG_VERBOSITY_NAMES = new String[]{"minimum", "io", "status", "init", "warning", "exception", "error", "fatal", "maximum"};
    private static FormattedPrintStream logOut = new FormattedPrintStream(System.err);
    private static int minVerbosityLevel = 3;
    private static String lastMessage;
    private static int equalMessageCount;
    private static File logFile;
    private static final String[] VERBOSITYLEVEL;

    public static void init(Experiment experiment) {
        int verbosityLevel = experiment.getRootOperator().getParameterAsInt("logverbosity");
        LogService.init(experiment, verbosityLevel);
    }

    public static void init(Experiment experiment, int verbosityLevel) {
        String filename = experiment.getRootOperator().getParameterAsString("logfile");
        boolean format = ParameterService.booleanValue(ParameterService.getProperty("yale.general.logfile.format"), false);
        if (filename == null) {
            LogService.logMessage("Logfile not set, using stderr", 4);
            logFile = null;
            LogService.init(System.err, verbosityLevel, format, -1);
        } else if (filename.equals("stderr")) {
            logFile = null;
            LogService.init(System.err, verbosityLevel, format, -1);
        } else if (filename.equals("stdout")) {
            logFile = null;
            LogService.init(System.out, verbosityLevel, format, -1);
        } else {
            OutputStream out = null;
            logFile = experiment.resolveFileName(filename);
            try {
                out = new FileOutputStream(logFile);
            }
            catch (IOException e) {
                LogService.logMessage("Cannot create logfile '" + filename + "': " + e.getClass() + ":" + e.getMessage(), 8);
                LogService.logMessage("using stderr", 8);
                out = System.err;
            }
            LogService.init(out, verbosityLevel, format, -1);
        }
    }

    public static void init(OutputStream out, int verbosityLevel, boolean format, int linewidth) {
        logOut = new FormattedPrintStream(out, format, 20, linewidth);
        minVerbosityLevel = verbosityLevel;
        LogService.logMessage("Started logging", 3);
        lastMessage = "";
        equalMessageCount = 0;
    }

    public static void initGUI() {
        minVerbosityLevel = Yale.getExperiment().getRootOperator().getParameterAsInt("logverbosity");
        String logOut = Yale.getExperiment().getRootOperator().getParameterAsString("logfile");
        OutputStream out = null;
        if (logOut != null) {
            try {
                logFile = Yale.getExperiment().resolveFileName(logOut);
                out = new StreamMultiplier(new OutputStream[]{new FileOutputStream(logFile), YaleGUI.getMainFrame().getMessageViewer().outputStream});
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot create log file: " + e);
            }
        } else {
            out = YaleGUI.getMainFrame().getMessageViewer().outputStream;
        }
        LogService.setOutputStream(out);
        LogService.logMessage("Log verbosity is: " + LOG_VERBOSITY_NAMES[minVerbosityLevel], 8);
    }

    public static void setOutputStream(OutputStream out) {
        logOut = new FormattedPrintStream(out, false, 0, -1);
    }

    public static void close() {
        LogService.logMessage("Ended logging", 3);
        logOut.close();
    }

    public static void setVerbosityLevel(int level) {
        minVerbosityLevel = level;
    }

    public static int getVerbosityLevel() {
        return minVerbosityLevel;
    }

    private static Operator getCurrentOperator() {
        Experiment exp = Yale.getExperiment();
        if (exp != null) {
            return exp.getRootOperator();
        }
        return null;
    }

    public static void logMessage(String message, int verbosityLevel) {
        if (message == null) {
            return;
        }
        if (verbosityLevel < minVerbosityLevel) {
            return;
        }
        if (message.equals(lastMessage)) {
            ++equalMessageCount;
            return;
        }
        if (equalMessageCount > 0) {
            logOut.println("Last message repeated " + equalMessageCount + " times.");
            equalMessageCount = 0;
        }
        lastMessage = message;
        logOut.println(LogService.getTime() + " " + VERBOSITYLEVEL[verbosityLevel] + message);
    }

    public static void logMessageWithTree(String message, int verbosityLevel, Operator op) {
        if (verbosityLevel < minVerbosityLevel) {
            return;
        }
        logOut.setIndented(true);
        logOut.println(Yale.getExperiment().getRootOperator().createMarkedExperimentTree(2, "here ==>", op));
        logOut.setIndented(false);
        LogService.logMessage(message, verbosityLevel);
    }

    public static void logException(String message, Throwable exception) {
        if (5 < minVerbosityLevel) {
            return;
        }
        Operator op = LogService.getCurrentOperator();
        if (op != null) {
            LogService.logMessage(Tools.classNameWOPackage(exception.getClass()) + " occured in " + Tools.ordinalNumber(op.getApplyCount()) + " application of " + op, 5);
        } else {
            LogService.logMessage(Tools.classNameWOPackage(exception.getClass()) + " occured.", 5);
        }
        LogService.logMessage(exception.getMessage(), 5);
        if (message != null) {
            LogService.logMessage(message, 5);
        }
        exception.printStackTrace(logOut);
    }

    private static String getTime() {
        return DateFormat.getDateTimeInstance().format(new Date()) + ":";
    }

    private static void fatal() {
        LogService.logMessage("Experiment not successful", 8);
        System.err.println("Experiment not successful");
        if (Yale.getExperiment() != null) {
            Yale.getExperiment().fatal();
        } else {
            System.exit(2);
        }
    }

    public static File getLogFile() {
        return logFile;
    }

    static {
        logFile = null;
        VERBOSITYLEVEL = new String[]{"", "", "", "", "$b[Warning]^b ", "$b[Exception]^b ", "$b[Error]^b ", "$b[Fatal]^b ", ""};
    }
}

