/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.validation.significance;

import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.performance.PerformanceCriterion;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.operator.validation.significance.FDistribution;
import edu.udo.cs.yale.operator.validation.significance.SignificanceTestOperator;
import edu.udo.cs.yale.operator.validation.significance.SignificanceTestResult;
import edu.udo.cs.yale.tools.Tools;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;

public class TTestSignificanceTestOperator
extends SignificanceTestOperator {
    public TTestSignificanceTestOperator(OperatorDescription description) {
        super(description);
    }

    public SignificanceTestResult performSignificanceTest(PerformanceVector[] allVectors, double alpha) {
        double[][] resultMatrix = new double[allVectors.length][allVectors.length];
        for (int i = 0; i < allVectors.length; ++i) {
            int j;
            for (j = 0; j < i + 1; ++j) {
                resultMatrix[i][j] = Double.NaN;
            }
            for (j = i + 1; j < allVectors.length; ++j) {
                resultMatrix[i][j] = this.getProbability(allVectors[i].getMainCriterion(), allVectors[j].getMainCriterion());
            }
        }
        return new TTestSignificanceTestResult(allVectors, resultMatrix, alpha);
    }

    private double getProbability(PerformanceCriterion pc1, PerformanceCriterion pc2) {
        double totalDeviation = ((double)(pc1.getExampleCount() - 1) * pc1.getVariance() + (double)(pc2.getExampleCount() - 1) * pc2.getVariance()) / (double)(pc1.getExampleCount() + pc2.getExampleCount() - 2);
        double factor = 1.0 / (1.0 / (double)pc1.getExampleCount() + 1.0 / (double)pc2.getExampleCount());
        double diff = pc1.getValue() - pc2.getValue();
        double t = factor * diff * diff / totalDeviation;
        FDistribution fDist = new FDistribution(1, pc1.getExampleCount() + pc2.getExampleCount() - 2);
        double prob = fDist.getProbabilityForValue(t);
        prob = prob < 0.0 ? 1.0 : 1.0 - prob;
        return prob;
    }

    public int getMinSize() {
        return 2;
    }

    public int getMaxSize() {
        return Integer.MAX_VALUE;
    }

    public class TTestSignificanceTestResult
    extends SignificanceTestResult {
        private PerformanceVector[] allVectors;
        private double[][] probMatrix;
        private double alpha = 0.05;

        public TTestSignificanceTestResult(PerformanceVector[] allVectors, double[][] probMatrix, double alpha) {
            this.allVectors = allVectors;
            this.probMatrix = probMatrix;
            this.alpha = alpha;
        }

        public String getName() {
            return "Pairwise t-Test";
        }

        public String toString() {
            int i;
            StringBuffer result = new StringBuffer();
            result.append("Probabilities for random values with the same result:\n");
            for (i = 0; i < this.allVectors.length; ++i) {
                for (int j = 0; j < this.allVectors.length; ++j) {
                    if (!Double.isNaN(this.probMatrix[i][j])) {
                        result.append(Tools.formatNumber(this.probMatrix[i][j]) + "\t");
                        continue;
                    }
                    result.append("-----\t");
                }
                result.append("\n");
            }
            result.append("Values smaller than alpha=" + Tools.formatNumber(this.alpha) + " indicate a probably significant difference between the mean values!\n");
            result.append("List of performance values:\n");
            for (i = 0; i < this.allVectors.length; ++i) {
                result.append(i + ": " + Tools.formatNumber(this.allVectors[i].getMainCriterion().getValue()) + " +/- " + Tools.formatNumber(Math.sqrt(this.allVectors[i].getMainCriterion().getVariance())) + "\n");
            }
            return result.toString();
        }

        public Component getVisualisationComponent() {
            int i;
            StringBuffer buffer = new StringBuffer();
            buffer.append("<table bgcolor=\"#E3D8C3\" border=\"1\">");
            buffer.append("<tr bgcolor=\"#ccccff\"><th></th>");
            for (i = 0; i < this.allVectors.length; ++i) {
                buffer.append("<th>" + Tools.formatNumber(this.allVectors[i].getMainCriterion().getValue()) + " +/- " + Tools.formatNumber(Math.sqrt(this.allVectors[i].getMainCriterion().getVariance())) + "</th>");
            }
            buffer.append("</tr>");
            for (i = 0; i < this.allVectors.length; ++i) {
                buffer.append("<tr><td>" + Tools.formatNumber(this.allVectors[i].getMainCriterion().getValue()) + " +/- " + Tools.formatNumber(Math.sqrt(this.allVectors[i].getMainCriterion().getVariance())) + "</td>");
                for (int j = 0; j < this.allVectors.length; ++j) {
                    buffer.append("<td>");
                    if (!Double.isNaN(this.probMatrix[i][j])) {
                        double prob = this.probMatrix[i][j];
                        if (prob < this.alpha) {
                            buffer.append("<b>");
                        }
                        buffer.append(Tools.formatNumber(prob));
                        if (prob < this.alpha) {
                            buffer.append("</b>");
                        }
                    }
                    buffer.append("</td>");
                }
                buffer.append("</tr>");
            }
            buffer.append("</table>");
            buffer.append("Probabilities for random values with the same result.<br>Bold values are smaller than alpha=" + Tools.formatNumber(this.alpha) + " which indicates a probably significant difference between the actual mean values!");
            JLabel label = new JLabel("<html><h1>" + this.getName() + "</h1>" + buffer.toString() + "</html>");
            label.setBorder(BorderFactory.createEmptyBorder(11, 11, 11, 11));
            label.setFont(label.getFont().deriveFont(0));
            return label;
        }
    }
}

