/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.validation;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IODescription;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.IllegalInputException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.performance.PerformanceCriterion;

public abstract class WrapperValidationChain
extends OperatorChain {
    private static final Class[] OUTPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = WrapperValidationChain.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector, class$edu$udo$cs$yale$example$AttributeWeights == null ? (class$edu$udo$cs$yale$example$AttributeWeights = WrapperValidationChain.class$("edu.udo.cs.yale.example.AttributeWeights")) : class$edu$udo$cs$yale$example$AttributeWeights};
    private static final Class[] INPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = WrapperValidationChain.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    private PerformanceCriterion lastPerformance;
    private IOContainer learnResult;
    private IOContainer methodResult;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$performance$PerformanceVector;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$AttributeWeights;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$learner$Model;

    public WrapperValidationChain(OperatorDescription description) {
        super(description);
        this.addValue(new Value("performance", "The last performance (main criterion)."){

            public double getValue() {
                if (WrapperValidationChain.this.lastPerformance != null) {
                    return WrapperValidationChain.this.lastPerformance.getValue();
                }
                return Double.NaN;
            }
        });
        this.addValue(new Value("variance", "The variance of the last performance (main criterion)."){

            public double getValue() {
                if (WrapperValidationChain.this.lastPerformance != null) {
                    return WrapperValidationChain.this.lastPerformance.getVariance();
                }
                return Double.NaN;
            }
        });
    }

    public int getMaxNumberOfInnerOperators() {
        return 3;
    }

    public int getMinNumberOfInnerOperators() {
        return 3;
    }

    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    public Class[] checkIO(Class[] input) throws IllegalInputException {
        Operator method = this.getMethod();
        Operator learner = this.getLearner();
        Operator evaluator = this.getEvaluator();
        if (!IODescription.containsClass(class$edu$udo$cs$yale$example$AttributeWeights == null ? (class$edu$udo$cs$yale$example$AttributeWeights = WrapperValidationChain.class$("edu.udo.cs.yale.example.AttributeWeights")) : class$edu$udo$cs$yale$example$AttributeWeights, input = method.checkIO(input))) {
            throw new IllegalInputException(this, learner, class$edu$udo$cs$yale$example$AttributeWeights == null ? (class$edu$udo$cs$yale$example$AttributeWeights = WrapperValidationChain.class$("edu.udo.cs.yale.example.AttributeWeights")) : class$edu$udo$cs$yale$example$AttributeWeights);
        }
        if (!IODescription.containsClass(class$edu$udo$cs$yale$operator$learner$Model == null ? (class$edu$udo$cs$yale$operator$learner$Model = WrapperValidationChain.class$("edu.udo.cs.yale.operator.learner.Model")) : class$edu$udo$cs$yale$operator$learner$Model, input = learner.checkIO(input))) {
            throw new IllegalInputException(this, learner, class$edu$udo$cs$yale$operator$learner$Model == null ? (class$edu$udo$cs$yale$operator$learner$Model = WrapperValidationChain.class$("edu.udo.cs.yale.operator.learner.Model")) : class$edu$udo$cs$yale$operator$learner$Model);
        }
        Class[] newInput = new Class[input.length + 1];
        for (int i = 0; i < input.length; ++i) {
            newInput[i] = input[i];
        }
        newInput[newInput.length - 1] = class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = WrapperValidationChain.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet;
        if (!IODescription.containsClass(class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = WrapperValidationChain.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector, input = evaluator.checkIO(newInput))) {
            throw new IllegalInputException(this, evaluator, class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = WrapperValidationChain.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector);
        }
        return this.getDeliveredOutputClasses();
    }

    private Operator getMethod() {
        return this.getOperator(0);
    }

    private Operator getLearner() {
        return this.getOperator(1);
    }

    private Operator getEvaluator() {
        return this.getOperator(2);
    }

    void setResult(PerformanceCriterion pc) {
        this.lastPerformance = pc;
    }

    IOContainer useMethod(ExampleSet methodTrainingSet) throws OperatorException {
        this.methodResult = this.getMethod().apply(new IOContainer(new IOObject[]{methodTrainingSet}));
        return this.methodResult;
    }

    IOContainer learn(ExampleSet trainingSet) throws OperatorException {
        if (this.methodResult == null) {
            throw new RuntimeException("Wrong use of MethodEvaluator.evaluate(ExampleSet): No preceding invocation of useMethod(ExampleSet)!");
        }
        this.learnResult = this.getLearner().apply(new IOContainer(new IOObject[]{trainingSet}));
        this.methodResult = null;
        return this.learnResult;
    }

    IOContainer evaluate(ExampleSet testSet) throws OperatorException {
        if (this.learnResult == null) {
            throw new RuntimeException("Wrong use of ValidationChain.evaluate(ExampleSet): No preceding invocation of learn(ExampleSet)!");
        }
        IOContainer result = this.getEvaluator().apply(this.learnResult.append(new IOObject[]{testSet}));
        this.learnResult = null;
        return result;
    }

    public abstract int getNumberOfValidationSteps();

    public int getNumberOfSteps() {
        return this.getNumberOfValidationSteps() * super.getNumberOfChildrensSteps();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

