/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.validation;

import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IODescription;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.IllegalInputException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.validation.Tools;
import edu.udo.cs.yale.tools.math.AverageVector;
import java.util.LinkedList;
import java.util.List;

public class IteratingPerformanceAverage
extends OperatorChain {
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$performance$PerformanceVector;

    public IteratingPerformanceAverage(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        int numberOfIterations = this.getParameterAsInt("iterations");
        LinkedList averageVectors = new LinkedList();
        for (int i = 0; i < numberOfIterations; ++i) {
            IOContainer evalOutput = this.evaluate();
            Tools.handleAverages(evalOutput, averageVectors, this.getParameterAsBoolean("average_performances_only"));
            this.inApplyLoop();
        }
        IOObject[] result = new AverageVector[averageVectors.size()];
        averageVectors.toArray(result);
        return result;
    }

    private IOContainer evaluate() throws OperatorException {
        IOContainer container = this.getInput().copy();
        for (int i = 0; i < this.getNumberOfOperators(); ++i) {
            container = this.getOperator(i).apply(container);
        }
        return container;
    }

    public Class[] checkIO(Class[] input) throws IllegalInputException {
        for (int i = 0; i < this.getNumberOfOperators(); ++i) {
            Operator o = this.getOperator(i);
            if (!o.isEnabled()) continue;
            input = o.checkIO(input);
        }
        if (!IODescription.containsClass(class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = IteratingPerformanceAverage.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector, input)) {
            throw new IllegalInputException((Operator)this, "The inner operators of IteratorWithPerformance must return a PerformanceVector");
        }
        return this.getDeliveredOutputClasses();
    }

    public int getNumberOfSteps() {
        int number = this.getParameterAsInt("iterations");
        return number * this.getNumberOfChildrensSteps() + 1;
    }

    public int getMinNumberOfInnerOperators() {
        return 0;
    }

    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    public Class[] getInputClasses() {
        return new Class[0];
    }

    public Class[] getOutputClasses() {
        return new Class[]{class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = IteratingPerformanceAverage.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector};
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt("iterations", "The number of iterations.", 1, Integer.MAX_VALUE, 10);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean("average_performances_only", "Indicates if only performance vectors should be averaged or all types of averagable result vectors.", true));
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

