/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.example.ListDataRowReader;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.example.SimpleExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SimpleSampling
extends Operator {
    private double fraction = 0.1;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;

    public SimpleSampling(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = SimpleSampling.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        this.fraction = this.getParameterAsDouble("sample_size");
        Attribute[] allAttributes = exampleSet.getExampleTable().getAttributes();
        LinkedList<DoubleArrayDataRow> dataList = new LinkedList<DoubleArrayDataRow>();
        ExampleReader reader = exampleSet.getExampleReader();
        while (reader.hasNext()) {
            Example example = reader.next();
            if (!this.accept(example)) continue;
            double[] values = new double[allAttributes.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = example.getValue(allAttributes[i]);
            }
            dataList.add(new DoubleArrayDataRow(values));
        }
        List<Attribute> attributes = Arrays.asList(exampleSet.getExampleTable().getAttributes());
        MemoryExampleTable exampleTable = new MemoryExampleTable(attributes, new ListDataRowReader(dataList.iterator()));
        LinkedList<Attribute> regularAttributes = new LinkedList<Attribute>();
        for (int i = 0; i < exampleSet.getNumberOfAttributes(); ++i) {
            regularAttributes.add(exampleSet.getAttribute(i));
        }
        SimpleExampleSet result = new SimpleExampleSet((ExampleTable)exampleTable, regularAttributes);
        Iterator special = exampleSet.getSpecialAttributeNames().iterator();
        while (special.hasNext()) {
            String name = (String)special.next();
            result.setSpecialAttribute(name, exampleSet.getAttribute(name));
        }
        return new IOObject[]{result};
    }

    private boolean accept(Example example) {
        return RandomGenerator.getGlobalRandomGenerator().nextDouble() < this.fraction;
    }

    public Class[] getInputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = SimpleSampling.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    public Class[] getOutputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = SimpleSampling.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble("sample_size", "The fraction of examples which should be sampled", 0.0, 1.0, 0.1);
        type.setExpert(false);
        types.add(type);
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

