/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.tools.LogService;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class RemoveUselessAttributes
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = RemoveUselessAttributes.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    private static final Class[] OUTPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = RemoveUselessAttributes.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;

    public RemoveUselessAttributes(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = RemoveUselessAttributes.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        ExampleSet clone = (ExampleSet)exampleSet.clone();
        double numericalMinDeviation = this.getParameterAsDouble("numerical_min_deviation");
        double nominalSingleValueUpper = this.getParameterAsDouble("nominal_single_value_upper");
        double nominalSingleValueLower = this.getParameterAsDouble("nominal_single_value_lower");
        if (nominalSingleValueLower < 0.0) {
            nominalSingleValueLower = 1.0 / (double)exampleSet.getSize();
        }
        for (int i = 0; i < exampleSet.getNumberOfAttributes(); ++i) {
            Attribute attribute = exampleSet.getAttribute(i);
            if (attribute.isNominal()) {
                Collection values = attribute.getValues();
                double[] valueCounts = new double[values.size()];
                Iterator v = values.iterator();
                int n = 0;
                while (v.hasNext()) {
                    String value = (String)v.next();
                    valueCounts[n] = attribute.getValueCount(value);
                    ++n;
                }
                double maximumValueCount = Double.NEGATIVE_INFINITY;
                for (n = 0; n < valueCounts.length; ++n) {
                    double percent = valueCounts[n] / (double)exampleSet.getSize();
                    maximumValueCount = Math.max(maximumValueCount, percent);
                    if (!(percent >= nominalSingleValueUpper)) continue;
                    clone.removeAttribute(attribute);
                    break;
                }
                if (!(maximumValueCount <= nominalSingleValueLower)) continue;
                clone.removeAttribute(attribute);
                break;
            }
            if (!(Math.sqrt(attribute.getVariance()) <= numericalMinDeviation)) continue;
            clone.removeAttribute(attribute);
        }
        if (clone.getNumberOfAttributes() <= 0) {
            LogService.logMessage("Example set does not not have any attribute after removing the useless attributes!", 4);
        }
        return new IOObject[]{clone};
    }

    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeDouble type = new ParameterTypeDouble("numerical_min_deviation", "Removes all numerical attributes with standard deviation less or equal to this threshold.", 0.0, Double.POSITIVE_INFINITY, 0.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("nominal_single_value_upper", "Removes all nominal attributes which provides more than the given amount of only one value.", 0.0, 1.0, 1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("nominal_single_value_lower", "Removes all nominal attributes which provides less than the given amount of at least one value (-1: remove attributes with values occuring only once).", -1.0, 1.0, -1.0);
        type.setExpert(false);
        types.add(type);
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

