/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.generator.FeatureGenerator;
import edu.udo.cs.yale.generator.GenerationException;
import edu.udo.cs.yale.generator.NormalizationGenerator;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.tools.LogService;
import java.util.ArrayList;
import java.util.List;

public class Normalization
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = Normalization.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    private static final Class[] OUTPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = Normalization.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;

    public Normalization(OperatorDescription description) {
        super(description);
    }

    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = Normalization.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        exampleSet.recalculateAllAttributeStatistics();
        if (!this.getParameterAsBoolean("standardize")) {
            LogService.logMessage("Standard-scaling set to OFF", 0);
            ArrayList<NormalizationGenerator> generators = new ArrayList<NormalizationGenerator>();
            double min = this.getParameterAsDouble("min");
            double max = this.getParameterAsDouble("max");
            if (max < min) {
                throw new UserError((Operator)this, 116, "max", (Object)"Must not be smaller than 'min'");
            }
            for (int i = 0; i < exampleSet.getNumberOfAttributes(); ++i) {
                NormalizationGenerator g = new NormalizationGenerator(min, max);
                g.setArguments(new Attribute[]{exampleSet.getAttribute(i)});
                generators.add(g);
            }
            try {
                List attributes = FeatureGenerator.generateAll(exampleSet.getExampleTable(), generators);
                exampleSet.removeAllAttributes();
                exampleSet.addAllAttributes(attributes);
            }
            catch (GenerationException e) {
                throw new UserError((Operator)this, (Throwable)e, 108, (Object)e.getMessage());
            }
        } else {
            LogService.logMessage("Standard-scaling set to ON", 0);
            ExampleReader r = exampleSet.getExampleReader();
            while (r.hasNext()) {
                Example example = r.next();
                for (int i = 0; i < exampleSet.getNumberOfAttributes(); ++i) {
                    Attribute attribute = exampleSet.getAttribute(i);
                    if (attribute.getVariance() == 0.0) {
                        example.setValue(attribute, 0.0);
                        continue;
                    }
                    double newValue = (example.getValue(attribute) - attribute.getAverage()) / Math.sqrt(attribute.getVariance());
                    example.setValue(attribute, newValue);
                }
            }
        }
        return new IOObject[]{exampleSet};
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeDouble("min", "The minimum value after normalization", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0));
        types.add(new ParameterTypeDouble("max", "The maximum value after normalization", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0));
        ParameterTypeBoolean type = new ParameterTypeBoolean("standardize", "Determines whether to perform standard-scaling (mean 0 and variance 1) or not; this scaling ignores min- and max-setings", true);
        type.setExpert(false);
        types.add(type);
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

