/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.example.ListDataRowReader;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.example.SimpleExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.meta.WeightedPerformanceMeasures;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ModelBasedSampling
extends Operator {
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;

    public ModelBasedSampling(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = ModelBasedSampling.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        Attribute weightAttr = exampleSet.getAttribute("weight");
        if (weightAttr == null) {
            weightAttr = exampleSet.createWeightAttribute();
            ExampleReader reader = exampleSet.getExampleReader();
            while (reader.hasNext()) {
                reader.next().setValue(weightAttr, 1.0);
            }
        }
        WeightedPerformanceMeasures weightedPerformanceMeasures = new WeightedPerformanceMeasures(exampleSet);
        weightedPerformanceMeasures.reweightExamples(exampleSet);
        exampleSet.recalculateAttributeStatistics(exampleSet.getWeight());
        Attribute[] allAttributes = exampleSet.getExampleTable().getAttributes();
        LinkedList<DoubleArrayDataRow> dataList = new LinkedList<DoubleArrayDataRow>();
        ExampleReader reader = exampleSet.getExampleReader();
        double maxWeight = exampleSet.getWeight().getMaximum();
        while (reader.hasNext()) {
            Example example = reader.next();
            if (!(RandomGenerator.getGlobalRandomGenerator().nextDouble() > example.getValue(weightAttr) / maxWeight)) continue;
            example.setValue(weightAttr, 1.0);
            double[] values = new double[allAttributes.length];
            for (int i = 0; i < values.length; ++i) {
                values[i] = example.getValue(allAttributes[i]);
            }
            dataList.add(new DoubleArrayDataRow(values));
        }
        List<Attribute> attributes = Arrays.asList(allAttributes);
        MemoryExampleTable exampleTable = new MemoryExampleTable(attributes, new ListDataRowReader(dataList.iterator()));
        LinkedList<Attribute> regularAttributes = new LinkedList<Attribute>();
        for (int i = 0; i < exampleSet.getNumberOfAttributes(); ++i) {
            regularAttributes.add(exampleSet.getAttribute(i));
        }
        SimpleExampleSet result = new SimpleExampleSet((ExampleTable)exampleTable, regularAttributes);
        Iterator special = exampleSet.getSpecialAttributeNames().iterator();
        while (special.hasNext()) {
            String name = (String)special.next();
            result.setSpecialAttribute(name, exampleSet.getAttribute(name));
        }
        return new IOObject[]{result};
    }

    public Class[] getInputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = ModelBasedSampling.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    public Class[] getOutputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = ModelBasedSampling.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

