/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class FrequencyDiscretizer
extends Operator {
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;

    public FrequencyDiscretizer(OperatorDescription description) {
        super(description);
    }

    public Class[] getInputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = FrequencyDiscretizer.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    public Class[] getOutputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = FrequencyDiscretizer.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    public IOObject[] apply() throws OperatorException {
        int i;
        ExampleSet exampleSet = (ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = FrequencyDiscretizer.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        int numberOfBins = this.getParameterAsInt("number_of_bins");
        if (numberOfBins >= exampleSet.getSize() - 1) {
            throw new UserError((Operator)this, 116, "number_of_bins", (Object)("number of bins must be smaller than number of examples (here: " + exampleSet.getSize() + ")"));
        }
        double[][] ranges = new double[exampleSet.getNumberOfAttributes()][numberOfBins];
        LinkedList<Attribute> list = new LinkedList<Attribute>();
        for (int a = 0; a < exampleSet.getNumberOfAttributes(); ++a) {
            Attribute attribute = exampleSet.getAttribute(a);
            if (!attribute.isNumerical()) continue;
            list.add(attribute);
        }
        LinkedList[] attributeValuesList = new LinkedList[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            attributeValuesList[i2] = new LinkedList();
        }
        ExampleReader reader = exampleSet.getExampleReader();
        while (reader.hasNext()) {
            Example current = reader.next();
            for (i = 0; i < list.size(); ++i) {
                int index = ((Attribute)list.get(i)).getTableIndex();
                Double value = new Double(current.getValue(index));
                attributeValuesList[i].add(value);
            }
        }
        LinkedList<Double[]> arrayList = new LinkedList<Double[]>();
        for (i = 0; i < list.size(); ++i) {
            Double[] array = new Double[attributeValuesList[i].size()];
            int j = 0;
            Iterator iterator = attributeValuesList[i].iterator();
            while (iterator.hasNext()) {
                Double value = (Double)iterator.next();
                array[j++] = value;
            }
            arrayList.add(array);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Arrays.sort((Object[])((Double[])iterator.next()));
        }
        int variable = 0;
        int[][] frequencyHelper = new int[arrayList.size()][numberOfBins * 2];
        for (int a = 0; a < exampleSet.getNumberOfAttributes(); ++a) {
            Attribute attribute = exampleSet.getAttribute(a);
            if (!attribute.isNumerical()) continue;
            Double[] array = (Double[])arrayList.get(variable);
            int frequencies = array.length / numberOfBins;
            int mod = array.length % numberOfBins;
            for (int i3 = 0; i3 < numberOfBins; ++i3) {
                if (mod > 0) {
                    frequencyHelper[variable][i3 * 2] = frequencies + 1;
                    --mod;
                    continue;
                }
                frequencyHelper[variable][i3 * 2] = frequencies;
            }
            ++variable;
            int z = 0;
            mod = array.length % numberOfBins;
            for (int j = 0; j < numberOfBins; ++j) {
                if (mod > 0) {
                    --mod;
                    z = z == 0 ? (z += frequencies) : z + frequencies + 1;
                    ranges[a][j] = array[z];
                    continue;
                }
                if (z == 0) {
                    z = -1;
                }
                ranges[a][j] = array[z += frequencies];
            }
        }
        boolean[] numerical = new boolean[ranges.length];
        for (int a = 0; a < exampleSet.getNumberOfAttributes(); ++a) {
            Attribute attribute = exampleSet.getAttribute(a);
            if (attribute.isNumerical()) {
                numerical[a] = true;
                attribute = exampleSet.replaceAttribute(attribute, AttributeFactory.changeValueType(attribute, 1));
                for (int b = 0; b < ranges[a].length; ++b) {
                    attribute.mapString("range" + (b + 1) + "(less than " + ranges[a][b] + ")");
                }
                continue;
            }
            numerical[a] = false;
        }
        reader = exampleSet.getExampleReader();
        while (reader.hasNext()) {
            Example example = reader.next();
            variable = 0;
            block13: for (int a = 0; a < exampleSet.getNumberOfAttributes(); ++a) {
                Attribute attribute = example.getAttribute(a);
                if (!numerical[a]) continue;
                double value = example.getValue(attribute);
                for (int b = 0; b < ranges[a].length; ++b) {
                    if (!(value <= ranges[a][b]) || frequencyHelper[variable][b * 2 + 1] >= frequencyHelper[variable][b * 2]) continue;
                    example.setValue(attribute, attribute.mapString("range" + (b + 1) + "(less than " + ranges[a][b] + ")"));
                    int[] nArray = frequencyHelper[variable];
                    int n = b * 2 + 1;
                    nArray[n] = nArray[n] + 1;
                    ++variable;
                    continue block13;
                }
            }
        }
        return new IOObject[]{exampleSet};
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeInt type = new ParameterTypeInt("number_of_bins", "Defines the number of bins which should be used for each attribute.", 2, Integer.MAX_VALUE, 2);
        type.setExpert(false);
        types.add(type);
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

