/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DataRow;
import edu.udo.cs.yale.example.DataRowReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.example.SimpleExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.tools.math.Complex;
import edu.udo.cs.yale.tools.math.FastFourierTransform;
import edu.udo.cs.yale.tools.math.Peak;
import edu.udo.cs.yale.tools.math.SpectrumFilter;
import java.util.LinkedList;

public class FourierTransform
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = FourierTransform.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    private static final Class[] OUTPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = FourierTransform.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;

    public FourierTransform(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = FourierTransform.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        int numberOfNewExamples = FastFourierTransform.getGreatestPowerOf2LessThan(exampleSet.getSize()) / 2;
        MemoryExampleTable exampleTable = new MemoryExampleTable(new LinkedList(), numberOfNewExamples);
        Attribute idAttribute = AttributeFactory.createAttribute("Id", 3);
        ((ExampleTable)exampleTable).addAttribute(idAttribute);
        DataRowReader drr = ((ExampleTable)exampleTable).getDataReader();
        int k = 0;
        while (drr.hasNext()) {
            DataRow dataRow = drr.next();
            dataRow.set(idAttribute, FastFourierTransform.convertFrequency(k++, numberOfNewExamples, exampleSet.getSize()));
        }
        double totalMaxEvidence = Double.NEGATIVE_INFINITY;
        Attribute label = exampleSet.getLabel();
        FastFourierTransform fft = new FastFourierTransform(4);
        SpectrumFilter filter = new SpectrumFilter(0);
        for (int i = 0; i < exampleSet.getNumberOfAttributes(); ++i) {
            Attribute current = exampleSet.getAttribute(i);
            if (current.isNominal()) continue;
            Complex[] result = fft.getFourierTransform(exampleSet, label, current);
            Peak[] spectrum = filter.filter(result, exampleSet.getSize());
            Attribute newAttribute = AttributeFactory.createAttribute("fft(" + current.getName() + ")", 4);
            ((ExampleTable)exampleTable).addAttribute(newAttribute);
            attributes.add(newAttribute);
            this.fillTable(exampleTable, newAttribute, spectrum);
        }
        SimpleExampleSet resultSet = new SimpleExampleSet((ExampleTable)exampleTable, attributes);
        resultSet.setId(idAttribute);
        return new IOObject[]{resultSet};
    }

    private void fillTable(ExampleTable table, Attribute attribute, Peak[] values) {
        DataRowReader reader = table.getDataReader();
        int k = 0;
        while (reader.hasNext()) {
            DataRow dataRow = reader.next();
            dataRow.set(attribute, values[k++].getMagnitude());
        }
    }

    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

