/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.operator.preprocessing.FeatureFilter;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FeatureNameFilter
extends FeatureFilter {
    private Pattern pattern;

    public FeatureNameFilter(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        String regex = this.getParameterAsString("skip_features_with_name");
        this.pattern = Pattern.compile(regex);
        return super.apply();
    }

    public boolean switchOffFeature(Attribute feature) throws OperatorException {
        Matcher matcher = this.pattern.matcher(feature.getName());
        return matcher.matches();
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeString("skip_features_with_name", "Remove attributes with a matching name (accepts regular expressions)", false));
        return types;
    }
}

