/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.preprocessing;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.tools.LogService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Deobfuscator
extends Operator {
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;

    public Deobfuscator(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet exampleSet = (ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = Deobfuscator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        String filename = this.getParameterAsString("obfuscation_map_file");
        File file = this.getExperiment().resolveFileName(filename);
        Map obfuscatorMap = null;
        try {
            obfuscatorMap = this.readObfuscatorMap(file);
        }
        catch (IOException e) {
            throw new UserError((Operator)this, 302, filename, (Object)e.getMessage());
        }
        for (int i = 0; i < exampleSet.getNumberOfAttributes(); ++i) {
            this.deObfuscateAttribute(exampleSet.getAttribute(i), obfuscatorMap);
        }
        Iterator i = exampleSet.getSpecialAttributeNames().iterator();
        while (i.hasNext()) {
            this.deObfuscateAttribute(exampleSet.getAttribute((String)i.next()), obfuscatorMap);
        }
        return new IOObject[]{exampleSet};
    }

    private void deObfuscateAttribute(Attribute attribute, Map obfuscatorMap) {
        String obfuscatedName = attribute.getName();
        String newName = (String)obfuscatorMap.get(obfuscatedName);
        if (newName != null) {
            attribute.setName(newName);
            attribute.clearConstructionDescription();
        } else {
            LogService.logMessage("No name found in obfuscating map for attribute '" + obfuscatedName + "'.", 4);
        }
        if (attribute.isNominal()) {
            Iterator v = attribute.getValues().iterator();
            while (v.hasNext()) {
                String obfuscatedValue = (String)v.next();
                String newValue = (String)obfuscatorMap.get(newName + ":" + obfuscatedValue);
                if (newValue != null) {
                    attribute.replaceValue(obfuscatedValue, newValue);
                    continue;
                }
                LogService.logMessage("No value found in obfuscating map for value '" + obfuscatedValue + "' of attribute '" + attribute.getName() + "'.", 4);
            }
        }
    }

    private Map readObfuscatorMap(File file) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        BufferedReader in = new BufferedReader(new FileReader(file));
        String line = null;
        while ((line = in.readLine()) != null) {
            String[] parts = line.trim().split("\\s");
            map.put(parts[0], parts[1]);
        }
        in.close();
        return map;
    }

    public Class[] getInputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = Deobfuscator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    public Class[] getOutputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = Deobfuscator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeFile type = new ParameterTypeFile("obfuscation_map_file", "File where the obfuscator map was written to.", false);
        type.setExpert(false);
        types.add(type);
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

