/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.parameter;

import edu.udo.cs.yale.tools.LogService;

public abstract class ParameterType
implements Comparable {
    private String key;
    private String description = "No documentation for this parameter.";
    private boolean expert = true;

    public ParameterType(String key, String description) {
        this.key = key;
        this.description = description;
    }

    public boolean isExpert() {
        return this.isOptional() && this.expert;
    }

    public void setExpert(boolean expert) {
        this.expert = expert;
    }

    public boolean isOptional() {
        return true;
    }

    public String getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public abstract String getRange();

    public abstract Object checkValue(Object var1);

    public abstract Object getDefaultValue();

    public String toString(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public String toString() {
        return this.key + "(" + this.description + ")";
    }

    public void illegalValue(Object illegal, Object corrected) {
        LogService.logMessage("Illegal value '" + illegal + "' for parameter '" + this.key + "' has been corrected to '" + corrected.toString() + "'.", 4);
    }

    public abstract String getXML(String var1, String var2, Object var3);

    public int compareTo(Object o) {
        if (!(o instanceof ParameterType)) {
            return 0;
        }
        return this.key.compareTo(((ParameterType)o).key);
    }
}

