/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.meta;

import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.ResultObjectAdapter;
import edu.udo.cs.yale.operator.Saveable;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.LogService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ParameterSet
extends ResultObjectAdapter
implements Saveable {
    private List parameterValues = new LinkedList();
    private PerformanceVector performance;

    private ParameterSet() {
    }

    public ParameterSet(Operator[] operators, String[] parameters, String[] values, PerformanceVector value) {
        if (operators.length != parameters.length || operators.length != values.length) {
            throw new IllegalArgumentException("The arrays operators, parameters, and values must be of equal size!");
        }
        for (int i = 0; i < operators.length; ++i) {
            this.parameterValues.add(new ParameterValue(operators[i].getName(), parameters[i], values[i]));
        }
        this.performance = value;
    }

    public String getName() {
        return "ParameterSet";
    }

    public String getParameterString() {
        StringBuffer str = new StringBuffer();
        Iterator i = this.parameterValues.iterator();
        while (i.hasNext()) {
            str.append(i.next().toString() + "\n");
        }
        return str.toString();
    }

    public String toString() {
        String str = "Parameter set:\n";
        str = str + this.getParameterString();
        str = str + "\nPerformance: " + this.performance;
        return str;
    }

    public PerformanceVector getPerformance() {
        return this.performance;
    }

    public void applyAll(Experiment experiment, Map nameMap) {
        Iterator i = this.parameterValues.iterator();
        while (i.hasNext()) {
            ((ParameterValue)i.next()).apply(experiment, nameMap);
        }
    }

    public void save(File file) throws IOException {
        this.write(new PrintWriter(new FileWriter(file)));
    }

    public void write(PrintWriter writer) {
        writer.println("# Generated by " + this.getClass().getName());
        writer.println(this.getParameterString());
        writer.flush();
    }

    public static ParameterSet read(BufferedReader reader) throws IOException {
        ParameterSet parameterSet = new ParameterSet();
        String line = null;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
            int colon = line.indexOf(".");
            int equals = line.indexOf("=");
            if (colon < 0 || equals < 0 || colon > equals) {
                throw new IOException("Malformed line: " + line);
            }
            parameterSet.parameterValues.add(new ParameterValue(line.substring(0, colon).trim(), line.substring(colon + 1, equals).trim(), line.substring(equals + 1).trim()));
        }
        reader.close();
        return parameterSet;
    }

    private static class ParameterValue {
        private String operator;
        private String parameterKey;
        private String parameterValue;

        private ParameterValue(String operator, String parameterKey, String parameterValue) {
            this.operator = operator;
            this.parameterKey = parameterKey;
            this.parameterValue = parameterValue;
        }

        public String toString() {
            return this.operator + "." + this.parameterKey + "\t= " + this.parameterValue;
        }

        public void apply(Experiment experiment, Map nameMap) {
            String opName = (String)nameMap.get(this.operator);
            if (opName == null) {
                opName = this.operator;
            }
            LogService.logMessage("Setting parameter '" + this.parameterKey + "' of operator '" + opName + "' to '" + this.parameterValue + "'.", 0);
            Operator operator = experiment.getOperator(opName);
            if (operator == null) {
                LogService.logMessage("No such operator: '" + opName + "'.", 0);
            } else {
                operator.getParameters().setParameter(this.parameterKey, this.parameterValue);
            }
        }
    }
}

