/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.nn;

import edu.udo.cs.yale.operator.learner.nn.Layer;
import edu.udo.cs.yale.operator.learner.nn.Trafo;
import edu.udo.cs.yale.tools.RandomGenerator;

public class WeightedLayer
extends Layer {
    private double[][] weight;
    private double[] u;

    public WeightedLayer(int input, int output, Trafo trafo, Layer succ) {
        super(output, trafo, succ);
        this.u = new double[output];
        this.weight = new double[output][input];
        RandomGenerator r = RandomGenerator.getGlobalRandomGenerator();
        for (int i = 0; i < output; ++i) {
            for (int j = 0; j < input; ++j) {
                this.weight[i][j] = r.nextDouble() * 2.0 - 1.0;
            }
        }
    }

    public double[] calculate(double[] s) {
        for (int i = 0; i < this.weight.length; ++i) {
            this.u[i] = 0.0;
            for (int j = 0; j < this.weight[i].length; ++j) {
                int n = i;
                this.u[n] = this.u[n] + this.weight[i][j] * s[j];
            }
        }
        return this.u;
    }

    public double[][] weights() {
        return this.weight;
    }

    public String toString() {
        String str = "";
        for (int j = 0; j < this.weight[0].length; ++j) {
            for (int i = 0; i < this.weight.length; ++i) {
                str = str + this.weight[i][j] + " | ";
            }
            str = str + "\n";
        }
        return str;
    }
}

