/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.meta;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.learner.meta.BayesianBoosting;

public class WeightedPerformanceMeasures {
    public static final double RULE_DOES_NOT_APPLY = Double.NaN;
    private double[] predictions;
    private double[] labels;
    private double[][] pred_label;
    private boolean crisp = true;
    private int posIndex = 0;
    private int[][] unweighted_num_pred_label;

    public WeightedPerformanceMeasures(ExampleSet exampleSet) throws OperatorException {
        int eLabel;
        double exaW;
        Example exa;
        int numberOfClasses = exampleSet.getLabel().getValues().size();
        this.labels = new double[numberOfClasses];
        this.predictions = new double[numberOfClasses];
        this.pred_label = new double[this.predictions.length][this.labels.length];
        this.unweighted_num_pred_label = new int[this.predictions.length][this.labels.length];
        ExampleReader reader = exampleSet.getExampleReader();
        double sumOfWeights = 0.0;
        if (exampleSet.getPredictedLabel().isNumerical()) {
            this.crisp = false;
            this.posIndex = exampleSet.getLabel().getPositiveIndex();
            if (this.predictions.length != 2) {
                throw new UserError(null, 114, "WeightedPerformanceMeasures (Soft base classifiers only supported for binary classification problems)", (Object)exampleSet.getLabel().getName());
            }
            while (reader.hasNext()) {
                exa = reader.next();
                exaW = exa.getWeight();
                sumOfWeights += exaW;
                eLabel = (int)(exa.getLabel() - 0.0);
                double ePred = exa.getPredictedLabel();
                int[] nArray = this.unweighted_num_pred_label[ePred >= 0.5 ? 1 : 0];
                int n = eLabel;
                nArray[n] = nArray[n] + 1;
                if (ePred < 0.0) {
                    ePred = 0.0;
                } else if (ePred > 1.0) {
                    ePred = 1.0;
                }
                int n2 = eLabel;
                this.labels[n2] = this.labels[n2] + exaW;
                this.predictions[0] = this.predictions[0] + (1.0 - ePred) * exaW;
                this.predictions[1] = this.predictions[1] + ePred * exaW;
                double[] dArray = this.pred_label[0];
                int n3 = eLabel;
                dArray[n3] = dArray[n3] + (1.0 - ePred) * exaW;
                double[] dArray2 = this.pred_label[1];
                int n4 = eLabel;
                dArray2[n4] = dArray2[n4] + ePred * exaW;
            }
        } else {
            while (reader.hasNext()) {
                this.crisp = true;
                exa = reader.next();
                exaW = exa.getWeight();
                sumOfWeights += exaW;
                eLabel = (int)(exa.getLabel() - 0.0);
                int ePred = (int)(exa.getPredictedLabel() - 0.0);
                int[] nArray = this.unweighted_num_pred_label[ePred];
                int n = eLabel;
                nArray[n] = nArray[n] + 1;
                int n5 = eLabel;
                this.labels[n5] = this.labels[n5] + exaW;
                int n6 = ePred;
                this.predictions[n6] = this.predictions[n6] + exaW;
                double[] dArray = this.pred_label[ePred];
                int n7 = eLabel;
                dArray[n7] = dArray[n7] + exaW;
            }
        }
        if (sumOfWeights > 0.0) {
            for (int i = 0; i < this.predictions.length; ++i) {
                int n = i;
                this.predictions[n] = this.predictions[n] / sumOfWeights;
                int j = 0;
                while (j < this.labels.length) {
                    double[] dArray = this.pred_label[i];
                    int n8 = j++;
                    dArray[n8] = dArray[n8] / sumOfWeights;
                }
            }
            int j = 0;
            while (j < this.labels.length) {
                int n = j++;
                this.labels[n] = this.labels[n] / sumOfWeights;
            }
        } else {
            double defaultPredProb = 1.0 / (double)this.predictions.length;
            double defaultLabelProb = 1.0 / (double)this.labels.length;
            double defaultPredLabelProb = defaultPredProb * defaultLabelProb;
            for (int i = 0; i < this.predictions.length; ++i) {
                this.predictions[i] = defaultPredProb;
                for (int j = 0; j < this.labels.length; ++j) {
                    this.pred_label[i][j] = defaultPredLabelProb;
                }
            }
            for (int j = 0; j < this.labels.length; ++j) {
                this.labels[j] = defaultLabelProb;
            }
        }
    }

    public int[] getCoveredExamplesNumForPred(int prediction) {
        int length = this.unweighted_num_pred_label.length;
        if (prediction >= 0 && prediction < length) {
            return this.unweighted_num_pred_label[prediction];
        }
        return new int[length];
    }

    public int getNumberOfLabels() {
        return this.labels.length;
    }

    public int getNumberOfPredictions() {
        return this.predictions.length;
    }

    public double getProbability(int label, int prediction) {
        return this.pred_label[prediction - 0][label - 0];
    }

    public double getProbabilityLabel(int label) {
        return this.labels[label - 0];
    }

    public double getProbabilityPrediction(int premise) {
        return this.predictions[premise - 0];
    }

    private int getNumOfClassesFor(int prediction) {
        int nonNulls = 0;
        for (int i = 0; i < this.getNumberOfLabels(); ++i) {
            if (!(this.getProbability(i + 0, prediction) > 0.0)) continue;
            ++nonNulls;
        }
        return nonNulls;
    }

    public double getBias(int label, int prediction) {
        double prLabel = this.getProbabilityLabel(label);
        double prPred = this.getProbabilityPrediction(prediction);
        double prJoint = this.getProbability(label, prediction);
        if (prPred == 0.0) {
            return Double.NaN;
        }
        if (prJoint == 0.0) {
            return 0.0;
        }
        if (prJoint == prPred) {
            return Double.POSITIVE_INFINITY;
        }
        double bias = prJoint / (prLabel * prPred);
        return bias;
    }

    public double[] getPnRatios(int prediction) {
        double[] biases = new double[this.labels.length];
        for (int i = 0; i < biases.length; ++i) {
            int yaleLabelIndex = i + 0;
            double b = this.getBias(yaleLabelIndex, prediction);
            if (b == 0.0 || b == Double.POSITIVE_INFINITY) {
                biases[i] = b;
                continue;
            }
            double negLabel = 1.0 - this.getProbabilityLabel(yaleLabelIndex);
            double probPred = this.getProbabilityPrediction(prediction);
            double probPredLabel = this.getProbability(yaleLabelIndex, prediction);
            double negLabelPred = probPred - probPredLabel;
            double oppositeBias = negLabelPred / (negLabel * probPred);
            biases[i] = b / oppositeBias;
        }
        return biases;
    }

    public double[][] createBiasMatrix() {
        int numPredictions = this.getNumberOfPredictions();
        double[][] biasMatrix = new double[numPredictions][];
        for (int i = 0; i < numPredictions; ++i) {
            if (this.crisp) {
                biasMatrix[i] = this.getPnRatios(i + 0);
                continue;
            }
            double predPrior = this.getProbabilityPrediction(i + 0);
            double[] biases = new double[]{predPrior, predPrior};
            biasMatrix[i] = biases;
        }
        return biasMatrix;
    }

    public double[] getLabelPriors() {
        double[] priors = new double[this.getNumberOfLabels()];
        for (int i = 0; i < priors.length; ++i) {
            priors[i] = this.getProbabilityLabel(i + 0);
        }
        return priors;
    }

    public boolean reweightExamples(ExampleSet exampleSet) throws OperatorException {
        ExampleReader reader = exampleSet.getExampleReader();
        double totalWeight = 0.0;
        while (reader.hasNext()) {
            Example example = reader.next();
            int label = (int)example.getLabel();
            double bias = 0.0;
            if (this.crisp) {
                int predicted = (int)example.getPredictedLabel();
                bias = this.getBias(label, predicted);
            } else {
                Attribute labelAttr = exampleSet.getLabel();
                int posLabel = labelAttr.getPositiveIndex();
                boolean posClass = label == posLabel;
                double predPos = Math.max(0.0, Math.min(1.0, example.getPredictedLabel()));
                double posPrior = this.getProbabilityPrediction(posLabel);
                bias = BayesianBoosting.getSoftPrediction(posClass, predPos, posPrior);
            }
            if (bias == Double.NaN) {
                throw new OperatorException("Internal error in class WeightedPerformanceMeasure: Applied rule marked as non-applicable!");
            }
            if (bias == 0.0 || bias == Double.POSITIVE_INFINITY || Double.isNaN(bias)) {
                example.setWeight(0.0);
                continue;
            }
            double newWeight = example.getWeight() / bias;
            example.setWeight(newWeight);
            totalWeight += newWeight;
        }
        return totalWeight > 0.0;
    }

    public static boolean reweightExamples(ExampleSet exampleSet, double[][] biasOddsMatrix, double[] classPriors) throws OperatorException {
        double[][] biasMatrix = new double[biasOddsMatrix.length][];
        double[] classOdds = new double[classPriors.length];
        for (int i = 0; i < classOdds.length; ++i) {
            classOdds[i] = classPriors[i] / (1.0 - classPriors[i]);
        }
        for (int pred = 0; pred < biasOddsMatrix.length; ++pred) {
            double[] curRow = biasOddsMatrix[pred];
            biasMatrix[pred] = new double[curRow.length];
            for (int label = 0; label < curRow.length; ++label) {
                double odds = curRow[label] * classOdds[label];
                double condProb = odds / (odds + 1.0);
                biasMatrix[pred][label] = condProb / classPriors[label];
            }
        }
        ExampleReader reader = exampleSet.getExampleReader();
        double totalWeight = 0.0;
        while (reader.hasNext()) {
            Example example = reader.next();
            int label = (int)example.getLabel();
            int predicted = (int)example.getPredictedLabel();
            double bias = biasMatrix[predicted][label];
            if (bias == Double.NaN) {
                throw new OperatorException("Internal error in class WeightedPerformanceMeasure: Applied rule marked as non-applicable!");
            }
            if (bias == 0.0 || bias == Double.POSITIVE_INFINITY || Double.isNaN(bias)) {
                example.setWeight(0.0);
                continue;
            }
            double newWeight = example.getWeight() / bias;
            example.setWeight(newWeight);
            totalWeight += newWeight;
        }
        return totalWeight > 0.0;
    }
}

