/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.meta;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.meta.WeightedPerformanceMeasures;

public class SDReweightMeasures
extends WeightedPerformanceMeasures {
    private double gamma;
    private boolean additive = true;

    public SDReweightMeasures(ExampleSet e) throws OperatorException {
        super(e);
    }

    public boolean reweightExamples(ExampleSet exampleSet, int posIndex, int coveredSubset) throws OperatorException {
        ExampleReader reader = exampleSet.getExampleReader();
        Attribute timesCoveredAttrib = null;
        if (this.additive) {
            timesCoveredAttrib = exampleSet.getAttribute("TIMES_COVERED_SPECIAL_ATTRIB");
        }
        double sumPosWeight = 0.0;
        double sumNegWeight = 0.0;
        while (reader.hasNext()) {
            Example example = reader.next();
            double weight = example.getWeight();
            int label = (int)example.getLabel() - 0;
            if (label == posIndex) {
                int predicted = (int)example.getPredictedLabel() - 0;
                if (predicted == coveredSubset) {
                    if (this.additive) {
                        int timesCovered = (int)example.getValue(timesCoveredAttrib) + 1;
                        weight = this.reweightAdd(weight, timesCovered);
                        example.setValue(timesCoveredAttrib, timesCovered);
                    } else {
                        weight = this.reweightMult(weight);
                    }
                    example.setWeight(weight);
                }
                sumPosWeight += weight;
                continue;
            }
            sumNegWeight += weight;
        }
        double ratio = sumPosWeight / sumNegWeight;
        if (ratio != 1.0) {
            reader = exampleSet.getExampleReader();
            while (reader.hasNext()) {
                Example example = reader.next();
                if ((int)example.getLabel() - 0 == posIndex) continue;
                example.setWeight(example.getWeight() * ratio);
            }
        }
        return true;
    }

    private double reweightAdd(double w, int timesCovered) {
        return w * (double)timesCovered / (double)(timesCovered + 1);
    }

    private double reweightMult(double w) {
        return w * this.gamma;
    }

    public void setGamma(double gamma) {
        this.gamma = gamma;
    }

    public void setAdditive(boolean additive) {
        this.additive = additive;
    }
}

