/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.meta;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.IOModel;
import edu.udo.cs.yale.operator.learner.Model;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class MultiModelByRegression
extends IOModel {
    public static final String ID = "YALE MultiModel";
    private static final int FILE_MODEL = 1;
    private static final int IO_MODEL = 2;
    private Model[] models;

    public MultiModelByRegression(Attribute label) {
        super(label);
    }

    public MultiModelByRegression(Attribute label, Model[] models) {
        super(label);
        this.models = models;
    }

    public int getNumberOfModels() {
        return this.models.length;
    }

    public Model getModel(int index) {
        return this.models[index];
    }

    public void apply(ExampleSet exampleSet) throws OperatorException {
        ExampleSet[] eSet = new ExampleSet[this.getNumberOfModels()];
        for (int i = 0; i < this.getNumberOfModels(); ++i) {
            Model model = this.getModel(i);
            eSet[i] = (ExampleSet)exampleSet.clone();
            Attribute predLabel = model.createPredictedLabel(eSet[i]);
            model.apply(eSet[i]);
        }
        ExampleReader[] reader = new ExampleReader[eSet.length];
        for (int r = 0; r < reader.length; ++r) {
            reader[r] = eSet[r].getExampleReader();
        }
        ExampleReader originalReader = exampleSet.getExampleReader();
        Attribute predictedLabel = exampleSet.getPredictedLabel();
        while (originalReader.hasNext()) {
            double bestLabel = Double.NaN;
            double highestFunctionValue = Double.NEGATIVE_INFINITY;
            for (int k = 0; k < reader.length; ++k) {
                double functionValue = reader[k].next().getPredictedLabel();
                if (!(functionValue > highestFunctionValue)) continue;
                highestFunctionValue = functionValue;
                bestLabel = k + 0;
            }
            Example example = originalReader.next();
            example.setPredictedLabel(bestLabel);
            example.setConfidence(predictedLabel.mapIndex((int)bestLabel), 1.0);
        }
    }

    public void writeData(ObjectOutputStream out) throws IOException {
        out.writeInt(this.models.length);
        for (int i = 0; i < this.models.length; ++i) {
            this.models[i].writeModel(out);
        }
    }

    public void readData(ObjectInputStream in) throws IOException {
        this.models = new Model[in.readInt()];
        for (int i = 0; i < this.models.length; ++i) {
            this.models[i] = Model.readModel(in);
        }
    }

    public String getIdentifier() {
        return ID;
    }

    public String toString() {
        String result = super.toString() + "\n";
        for (int i = 0; i < this.models.length; ++i) {
            result = result + (i > 0 ? "\n" : "") + this.models[i].toString();
        }
        return result;
    }
}

