/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.meta;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.learner.Model;
import edu.udo.cs.yale.operator.learner.meta.AbstractMetaLearner;
import edu.udo.cs.yale.operator.learner.meta.MultiModelByRegression;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import java.util.List;

public class ClassificationByRegression
extends AbstractMetaLearner {
    private static final Class[] INPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = ClassificationByRegression.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    private int numberOfClasses;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;

    public ClassificationByRegression(OperatorDescription description) {
        super(description);
    }

    public boolean supportsCapability(LearnerCapability lc) {
        if (lc == LearnerCapability.POLYNOMINAL_CLASS || lc == LearnerCapability.BINOMINAL_CLASS || lc == LearnerCapability.NUMERICAL_CLASS) {
            return true;
        }
        return super.supportsCapability(lc);
    }

    public Model learn(ExampleSet inputSet) throws OperatorException {
        Attribute classLabel = inputSet.getLabel();
        this.numberOfClasses = classLabel.getValues().size();
        Model[] models = new Model[this.numberOfClasses];
        ExampleSet eSet = (ExampleSet)inputSet.clone();
        Attribute tempLabel = AttributeFactory.createAttribute("temp_regression_label", 4);
        eSet.getExampleTable().addAttribute(tempLabel);
        eSet.setLabel(tempLabel);
        for (int i = 0; i < this.numberOfClasses; ++i) {
            ExampleReader r = eSet.getExampleReader();
            while (r.hasNext()) {
                Example e = r.next();
                if (e.getValue(classLabel) == (double)(i + 0)) {
                    e.setValue(tempLabel, 1.0);
                    continue;
                }
                e.setValue(tempLabel, -1.0);
            }
            models[i] = this.applyInnerLearner(eSet);
        }
        return new MultiModelByRegression(classLabel, models);
    }

    public int getNumberOfSteps() {
        return this.getNumberOfChildrensSteps() * this.numberOfClasses + 1;
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeFile type = new ParameterTypeFile("model_file", "If this parameter is set, the model is written to a file.", true);
        type.setExpert(false);
        types.add(type);
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

