/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.meta;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.Example;
import edu.udo.cs.yale.example.ExampleReader;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.SplittedExampleSet;
import edu.udo.cs.yale.operator.MissingIOObjectException;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.learner.Model;
import edu.udo.cs.yale.operator.learner.meta.AbstractMetaLearner;
import edu.udo.cs.yale.operator.learner.meta.BayBoostModel;
import edu.udo.cs.yale.operator.learner.meta.WeightedPerformanceMeasures;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.tools.LogService;
import java.util.List;
import java.util.Vector;

public class BayesianBoosting
extends AbstractMetaLearner {
    public static final String NUM_OF_ITERATIONS = "iterations";
    public static final String INTERNAL_BOOTSTRAP = "ratio_internal_bootstrap";
    public static final String EQUALLY_PROB_LABELS = "rescale_label_priors";
    public static final double MIN_ADVANTAGE = 0.001;
    public static final double MIN_LIFT_RATIO_SOFT_CLASSIFIER = 0.2;
    private Model startModel;
    private int currentIteration;
    private double performance = 0.0;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$learner$Model;

    public BayesianBoosting(OperatorDescription description) {
        super(description);
        this.addValue(new Value("performance", "The performance."){

            public double getValue() {
                return BayesianBoosting.this.performance;
            }
        });
        this.addValue(new Value("iteration", "The current iteration."){

            public double getValue() {
                return BayesianBoosting.this.currentIteration;
            }
        });
    }

    public boolean supportsCapability(LearnerCapability lc) {
        if (lc == LearnerCapability.NUMERICAL_CLASS) {
            return false;
        }
        return super.supportsCapability(lc);
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeBoolean(EQUALLY_PROB_LABELS, "Specifies whether the proportion of labels should be equal by construction after first iteration .", false));
        types.add(new ParameterTypeDouble(INTERNAL_BOOTSTRAP, "Fraction of examples used for training (internal bootstrapping). If activated (value < 1) only the rest is used to estimate the biases.", 0.0, 1.0, 0.7));
        types.add(new ParameterTypeInt(NUM_OF_ITERATIONS, "The maximum number of iterations.", 1, Integer.MAX_VALUE, 10));
        return types;
    }

    public int getNumberOfSteps() {
        return 1;
    }

    public Model learn(ExampleSet exampleSet) throws OperatorException {
        this.readOptionalParameters();
        this.checkLearnerCapabilities(exampleSet);
        double[] classPriors = this.prepareWeights(exampleSet);
        BayBoostModel model = this.trainBoostingModel(exampleSet, classPriors);
        return model;
    }

    private double[] prepareWeights(ExampleSet exampleSet) {
        Attribute weightAttr = exampleSet.createWeightAttribute();
        ExampleReader exRead = exampleSet.getExampleReader();
        int numClasses = exampleSet.getLabel().getValues().size();
        double[] classPriors = new double[numClasses];
        int total = exampleSet.getSize();
        double invTotal = 1.0 / (double)total;
        if (!this.getParameterAsBoolean(EQUALLY_PROB_LABELS)) {
            while (exRead.hasNext()) {
                Example example = exRead.next();
                example.setValue(weightAttr, 1.0);
                int n = (int)(example.getLabel() - 0.0);
                classPriors[n] = classPriors[n] + invTotal;
            }
        } else {
            while (exRead.hasNext()) {
                int n = (int)(exRead.next().getLabel() - 0.0);
                classPriors[n] = classPriors[n] + invTotal;
            }
            double[] weights = new double[numClasses];
            for (int i = 0; i < weights.length; ++i) {
                weights[i] = 1.0 / ((double)weights.length * classPriors[i]);
            }
            exRead = exampleSet.getExampleReader();
            while (exRead.hasNext()) {
                Example example = exRead.next();
                example.setValue(weightAttr, weights[(int)example.getLabel()]);
            }
        }
        return classPriors;
    }

    private Model trainBaseModel(ExampleSet exampleSet) throws OperatorException {
        Model model = this.applyInnerLearner(exampleSet);
        BayesianBoosting.createOrReplacePredictedLabelFor(exampleSet, model);
        model.apply(exampleSet);
        return model;
    }

    private void readOptionalParameters() {
        try {
            this.startModel = (Model)this.getInput(class$edu$udo$cs$yale$operator$learner$Model == null ? (class$edu$udo$cs$yale$operator$learner$Model = BayesianBoosting.class$("edu.udo.cs.yale.operator.learner.Model")) : class$edu$udo$cs$yale$operator$learner$Model);
        }
        catch (MissingIOObjectException e) {
            LogService.logMessage(this.getName() + ": No model found in input.", 2);
        }
    }

    private void applyPriorModel(ExampleSet trainingSet, Vector modelInfo) throws OperatorException {
        if (this.startModel != null) {
            BayesianBoosting.createOrReplacePredictedLabelFor(trainingSet, this.startModel);
            this.startModel.apply(trainingSet);
            WeightedPerformanceMeasures wp = new WeightedPerformanceMeasures(trainingSet);
            wp.reweightExamples(trainingSet);
            modelInfo.add(new Object[]{this.startModel, wp.createBiasMatrix()});
        }
    }

    private BayBoostModel trainBoostingModel(ExampleSet trainingSet, double[] classPriors) throws OperatorException {
        Vector<Object[]> modelInfo = new Vector<Object[]>();
        this.applyPriorModel(trainingSet, modelInfo);
        double splitRatio = this.getParameterAsDouble(INTERNAL_BOOTSTRAP);
        boolean bootstrap = splitRatio > 0.0 && splitRatio < 1.0;
        LogService.logMessage(bootstrap ? "Bootstrapping enabled." : "Bootstrapping disabled.", 2);
        int iterations = this.getParameterAsInt(NUM_OF_ITERATIONS);
        for (int i = 0; i < iterations; ++i) {
            this.currentIteration = i;
            int size = trainingSet.getSize();
            ExampleSet splittedSet = trainingSet;
            if (bootstrap) {
                splittedSet = new SplittedExampleSet(trainingSet, splitRatio);
                ((SplittedExampleSet)splittedSet).selectSingleSubset(0);
            }
            Model model = this.trainBaseModel(splittedSet);
            if (bootstrap) {
                ((SplittedExampleSet)splittedSet).selectSingleSubset(1);
                model.apply(trainingSet);
            }
            WeightedPerformanceMeasures wp = new WeightedPerformanceMeasures(splittedSet);
            if (classPriors.length == 2) {
                this.debugMessage(wp);
            }
            int nonEmptyClasses = 0;
            for (int j = 0; j < wp.getNumberOfLabels() && nonEmptyClasses < 2; ++j) {
                double c = wp.getProbabilityLabel(j + 0);
                if (!(c > 0.0)) continue;
                ++nonEmptyClasses;
            }
            if (nonEmptyClasses < 2) {
                modelInfo.add(new Object[]{model, wp.createBiasMatrix()});
                break;
            }
            boolean positiveWeight = wp.reweightExamples(trainingSet);
            double[][] biasMatrix = wp.createBiasMatrix();
            modelInfo.add(new Object[]{model, biasMatrix});
            if (!this.isModelUseful(biasMatrix)) {
                LogService.logMessage("Discard model because of low advantage on training data.", 2);
                modelInfo.remove(modelInfo.size() - 1);
                break;
            }
            if (!positiveWeight) break;
        }
        return new BayBoostModel(trainingSet.getLabel(), modelInfo, classPriors, true);
    }

    private void debugMessage(WeightedPerformanceMeasures wp) {
        String message = "\nModel learned - training performance of base learner:\nTPR: " + wp.getProbability(0, 0) + " FPR: " + wp.getProbability(1, 0) + " | Positively predicted: " + (wp.getProbability(1, 0) + wp.getProbability(0, 0)) + "\nFNR: " + wp.getProbability(0, 1) + " TNR: " + wp.getProbability(1, 1) + " | Negatively predicted: " + (wp.getProbability(0, 1) + wp.getProbability(1, 1)) + "\nPositively labelled: " + (wp.getProbability(0, 0) + wp.getProbability(0, 1)) + "\nNegatively labelled: " + (wp.getProbability(1, 0) + wp.getProbability(1, 1));
        LogService.logMessage(message, 2);
    }

    private boolean adjustBaseModelWeights(ExampleSet exampleSet, Vector modelInfo, double[] classPriors) throws OperatorException {
        double[] weightedPriors;
        if (modelInfo.size() <= 1) {
            return true;
        }
        if (this.getParameterAsBoolean(EQUALLY_PROB_LABELS)) {
            weightedPriors = new double[classPriors.length];
            for (int i = 0; i < weightedPriors.length; ++i) {
                weightedPriors[i] = 0.5;
            }
        } else {
            weightedPriors = classPriors;
        }
        for (int j = 0; j < modelInfo.size(); ++j) {
            this.setInitialWeights(exampleSet, classPriors);
            if (!BayesianBoosting.applyAllButJthModel(exampleSet, modelInfo, j, weightedPriors)) {
                return false;
            }
            Object[] consideredModelInfo = (Object[])modelInfo.get(j);
            Model consideredModel = (Model)consideredModelInfo[0];
            double[][] oldBiasMatrix = (double[][])consideredModelInfo[1];
            BayesianBoosting.createOrReplacePredictedLabelFor(exampleSet, consideredModel);
            if (!exampleSet.getPredictedLabel().isNominal()) {
                return false;
            }
            consideredModel.apply(exampleSet);
            WeightedPerformanceMeasures wp = new WeightedPerformanceMeasures(exampleSet);
            if (!wp.reweightExamples(exampleSet)) continue;
            double[][] newBiasMatrix = wp.createBiasMatrix();
            LogService.logMessage("Weights of model number " + j + " updated (old/new):", 2);
            for (int m = 0; m < newBiasMatrix.length; ++m) {
                String line = "";
                double[] curline = newBiasMatrix[m];
                for (int n = 0; n < curline.length; ++n) {
                    double oldBias = oldBiasMatrix[m][n];
                    if (oldBias != 0.0 && oldBias != Double.POSITIVE_INFINITY && !Double.isNaN(oldBias)) {
                        oldBiasMatrix[m][n] = curline[n];
                    }
                    line = line + "(" + oldBias + "/" + oldBiasMatrix[m][n] + ") ";
                }
                LogService.logMessage(line, 2);
            }
        }
        return true;
    }

    private static boolean applyAllButJthModel(ExampleSet exampleSet, Vector modelInfo, int j, double[] classPriors) throws OperatorException {
        for (int index = 0; index < modelInfo.size(); ++index) {
            if (index == j) continue;
            Object[] currentModelInfo = (Object[])modelInfo.get(index);
            Model currentModel = (Model)currentModelInfo[0];
            double[][] biasMatrix = (double[][])currentModelInfo[1];
            BayesianBoosting.createOrReplacePredictedLabelFor(exampleSet, currentModel);
            if (!exampleSet.getPredictedLabel().isNominal()) {
                return false;
            }
            currentModel.apply(exampleSet);
            WeightedPerformanceMeasures.reweightExamples(exampleSet, biasMatrix, classPriors);
        }
        return true;
    }

    private static void createOrReplacePredictedLabelFor(ExampleSet exampleSet, Model model) {
        Attribute predictedLabel = exampleSet.getPredictedLabel();
        if (predictedLabel != null) {
            exampleSet.clearPredictedLabel();
            exampleSet.getExampleTable().removeAttribute(predictedLabel);
        }
        model.createPredictedLabel(exampleSet);
    }

    private void setInitialWeights(ExampleSet exampleSet, double[] classPriors) {
        int k;
        double[] weights = new double[classPriors.length];
        if (this.getParameterAsBoolean(EQUALLY_PROB_LABELS)) {
            for (k = 0; k < weights.length; ++k) {
                weights[k] = 1.0 / ((double)weights.length * classPriors[k]);
            }
        } else {
            for (k = 0; k < weights.length; ++k) {
                weights[k] = 1.0;
            }
        }
        ExampleReader exRead = exampleSet.getExampleReader();
        while (exRead.hasNext()) {
            Example example = exRead.next();
            example.setWeight(weights[(int)example.getLabel()]);
        }
    }

    private boolean isModelUseful(double[][] biasMatrix) {
        for (int row = 0; row < biasMatrix.length; ++row) {
            double[] current = biasMatrix[row];
            for (int col = 0; col < current.length; ++col) {
                if (!(Math.abs(current[col] - 1.0) > 0.001)) continue;
                return true;
            }
        }
        return false;
    }

    public static double getSoftPrediction(boolean posClass, double predPosClass, double posPredPrior) {
        double minLift = 0.2;
        double maxLift = 5.0;
        double prior1 = Math.max(0.0, Math.min(1.0, posPredPrior));
        double pred1 = Math.max(0.2 * prior1, Math.min(5.0 * prior1, predPosClass));
        return posClass ? pred1 / prior1 : (1.0 - pred1) / (1.0 - prior1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

