/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.meta;

import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IODescription;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.IllegalInputException;
import edu.udo.cs.yale.operator.InputDescription;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.ResultObjectAdapter;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.learner.Learner;
import edu.udo.cs.yale.operator.learner.LearnerCapability;
import edu.udo.cs.yale.operator.learner.Model;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.LogService;
import java.util.LinkedList;

public abstract class AbstractMetaLearner
extends OperatorChain
implements Learner {
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$learner$Model;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$performance$PerformanceVector;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$AttributeWeights;

    public AbstractMetaLearner(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        PerformanceVector perfVector;
        AttributeWeights weights;
        ExampleSet exampleSet = (ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = AbstractMetaLearner.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        if (exampleSet.getLabel() == null) {
            throw new UserError((Operator)this, 105, new Object[0]);
        }
        if (exampleSet.getNumberOfAttributes() == 0) {
            throw new UserError((Operator)this, 106, new Object[0]);
        }
        try {
            this.checkLearnerCapabilities(exampleSet);
        }
        catch (OperatorException e) {
            LogService.logMessage(e.getMessage(), 4);
        }
        LinkedList<ResultObjectAdapter> results = new LinkedList<ResultObjectAdapter>();
        Model model = this.learn(exampleSet);
        results.add(model);
        if (this.shouldCalculateWeights() && (weights = this.getWeights(exampleSet)) != null) {
            results.add(weights);
        }
        if (this.shouldEstimatePerformance() && (perfVector = this.getEstimatedPerformance()) != null) {
            results.add(perfVector);
        }
        IOObject[] resultArray = new IOObject[results.size()];
        results.toArray(resultArray);
        return resultArray;
    }

    public void checkLearnerCapabilities(ExampleSet exampleSet) throws OperatorException {
        if (exampleSet.containsValueType(1)) {
            if (exampleSet.containsValueType(8)) {
                if (!this.supportsCapability(LearnerCapability.BINOMINAL_ATTRIBUTES)) {
                    throw new UserError((Operator)this, 501, LearnerCapability.BINOMINAL_ATTRIBUTES.getDescription());
                }
            } else if (!this.supportsCapability(LearnerCapability.POLYNOMINAL_ATTRIBUTES)) {
                throw new UserError((Operator)this, 501, LearnerCapability.POLYNOMINAL_ATTRIBUTES.getDescription());
            }
        } else if (exampleSet.containsValueType(2) && !this.supportsCapability(LearnerCapability.NUMERICAL_ATTRIBUTES)) {
            throw new UserError((Operator)this, 501, LearnerCapability.NUMERICAL_ATTRIBUTES.getDescription());
        }
        if (exampleSet.getLabel().isNominal()) {
            if (exampleSet.getLabel().isBooleanClassification() || exampleSet.getLabel().isNominal() && exampleSet.getLabel().getNumberOfValues() == 2) {
                if (!this.supportsCapability(LearnerCapability.BINOMINAL_CLASS)) {
                    throw new UserError((Operator)this, 501, LearnerCapability.BINOMINAL_CLASS.getDescription());
                }
            } else if (!this.supportsCapability(LearnerCapability.POLYNOMINAL_CLASS)) {
                throw new UserError((Operator)this, 501, LearnerCapability.POLYNOMINAL_CLASS.getDescription());
            }
        } else if (exampleSet.getLabel().isNumerical() && !this.supportsCapability(LearnerCapability.NUMERICAL_CLASS)) {
            throw new UserError((Operator)this, 501, LearnerCapability.NUMERICAL_CLASS.getDescription());
        }
    }

    protected Model applyInnerLearner(ExampleSet exampleSet) throws OperatorException {
        IOContainer input = new IOContainer(new IOObject[]{exampleSet});
        for (int i = 0; i < this.getNumberOfOperators(); ++i) {
            input = this.getOperator(i).apply(input);
        }
        return (Model)input.remove(class$edu$udo$cs$yale$operator$learner$Model == null ? (class$edu$udo$cs$yale$operator$learner$Model = AbstractMetaLearner.class$("edu.udo.cs.yale.operator.learner.Model")) : class$edu$udo$cs$yale$operator$learner$Model);
    }

    public int getNumberOfSteps() {
        return this.getNumberOfOperators();
    }

    public int getMinNumberOfInnerOperators() {
        return 1;
    }

    public int getMaxNumberOfInnerOperators() {
        return Integer.MAX_VALUE;
    }

    public Class[] checkIO(Class[] input) throws IllegalInputException {
        for (int i = 0; i < this.getNumberOfOperators(); ++i) {
            input = this.getOperator(i).checkIO(input);
        }
        if (!IODescription.containsClass(class$edu$udo$cs$yale$operator$learner$Model == null ? (class$edu$udo$cs$yale$operator$learner$Model = AbstractMetaLearner.class$("edu.udo.cs.yale.operator.learner.Model")) : class$edu$udo$cs$yale$operator$learner$Model, input)) {
            throw new IllegalInputException(this, this.getOperator(this.getNumberOfOperators() - 1), class$edu$udo$cs$yale$operator$learner$Model == null ? (class$edu$udo$cs$yale$operator$learner$Model = AbstractMetaLearner.class$("edu.udo.cs.yale.operator.learner.Model")) : class$edu$udo$cs$yale$operator$learner$Model);
        }
        if (this.shouldEstimatePerformance() && !IODescription.containsClass(class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = AbstractMetaLearner.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector, input)) {
            throw new IllegalInputException(this, this.getOperator(this.getNumberOfOperators() - 1), class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = AbstractMetaLearner.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector);
        }
        if (this.shouldCalculateWeights() && !IODescription.containsClass(class$edu$udo$cs$yale$example$AttributeWeights == null ? (class$edu$udo$cs$yale$example$AttributeWeights = AbstractMetaLearner.class$("edu.udo.cs.yale.example.AttributeWeights")) : class$edu$udo$cs$yale$example$AttributeWeights, input)) {
            throw new IllegalInputException(this, this.getOperator(this.getNumberOfOperators() - 1), class$edu$udo$cs$yale$example$AttributeWeights == null ? (class$edu$udo$cs$yale$example$AttributeWeights = AbstractMetaLearner.class$("edu.udo.cs.yale.example.AttributeWeights")) : class$edu$udo$cs$yale$example$AttributeWeights);
        }
        return this.getAllOutputClasses(input);
    }

    public InputDescription getInputDescription(Class cls) {
        if ((class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = AbstractMetaLearner.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet).isAssignableFrom(cls)) {
            return new InputDescription(cls, false, true);
        }
        return super.getInputDescription(cls);
    }

    public Class[] getInputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = AbstractMetaLearner.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    public boolean shouldEstimatePerformance() {
        return false;
    }

    public boolean shouldCalculateWeights() {
        return false;
    }

    public PerformanceVector getEstimatedPerformance() throws OperatorException {
        throw new UserError((Operator)this, 912, this.getName(), (Object)"estimation of performance not supported.");
    }

    public AttributeWeights getWeights(ExampleSet exampleSet) throws OperatorException {
        throw new UserError((Operator)this, 916, this.getName(), (Object)"calculation of weights not supported.");
    }

    public boolean supportsCapability(LearnerCapability capability) {
        if (this.getNumberOfOperators() == 0) {
            return false;
        }
        for (int i = 0; i < this.getNumberOfOperators(); ++i) {
            if (!(this.getOperator(i) instanceof Learner)) continue;
            return ((Learner)((Object)this.getOperator(i))).supportsCapability(capability);
        }
        return false;
    }

    public Class[] getOutputClasses() {
        LinkedList<Class> classList = new LinkedList<Class>();
        classList.add(class$edu$udo$cs$yale$operator$learner$Model == null ? (class$edu$udo$cs$yale$operator$learner$Model = AbstractMetaLearner.class$("edu.udo.cs.yale.operator.learner.Model")) : class$edu$udo$cs$yale$operator$learner$Model);
        if (this.shouldEstimatePerformance()) {
            classList.add(class$edu$udo$cs$yale$operator$performance$PerformanceVector == null ? (class$edu$udo$cs$yale$operator$performance$PerformanceVector = AbstractMetaLearner.class$("edu.udo.cs.yale.operator.performance.PerformanceVector")) : class$edu$udo$cs$yale$operator$performance$PerformanceVector);
        }
        if (this.shouldCalculateWeights()) {
            classList.add(class$edu$udo$cs$yale$example$AttributeWeights == null ? (class$edu$udo$cs$yale$example$AttributeWeights = AbstractMetaLearner.class$("edu.udo.cs.yale.example.AttributeWeights")) : class$edu$udo$cs$yale$example$AttributeWeights);
        }
        Class[] result = new Class[classList.size()];
        classList.toArray(result);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

