/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner.kernel;

import edu.udo.cs.mySVM.Examples.ExampleSet;
import edu.udo.cs.mySVM.Kernel.Kernel;
import edu.udo.cs.mySVM.Kernel.KernelDot;
import edu.udo.cs.mySVM.Kernel.KernelNeural;
import edu.udo.cs.mySVM.Kernel.KernelPolynomial;
import edu.udo.cs.mySVM.Kernel.KernelRadial;
import edu.udo.cs.mySVM.SVM.SVMInterface;
import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.learner.AbstractLearner;
import edu.udo.cs.yale.operator.learner.Model;
import edu.udo.cs.yale.operator.learner.kernel.AbstractMySVMModel;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import java.util.List;

public abstract class AbstractMySVMLearner
extends AbstractLearner {
    private static final String[] KERNEL_TYPES = new String[]{"dot", "radial", "polynomial", "neural"};
    public static final int KERNEL_DOT = 0;
    public static final int KERNEL_RADIAL = 1;
    public static final int KERNEL_POLYNOMIAL = 2;
    public static final int KERNEL_NEURAL = 3;
    private SVMInterface svm = null;
    private Kernel kernel;

    public AbstractMySVMLearner(OperatorDescription description) {
        super(description);
    }

    protected Kernel getKernel() {
        return this.kernel;
    }

    protected SVMInterface getSVM() {
        return this.svm;
    }

    public boolean shouldCalculateWeights() {
        return this.getParameterAsBoolean("calculate_weights");
    }

    public AttributeWeights getWeights(edu.udo.cs.yale.example.ExampleSet exampleSet) throws OperatorException {
        if (this.getParameterAsInt("kernel_type") != 0) {
            throw new UserError((Operator)this, 916, this, (Object)"Cannot create weights for nonlinear kernel!");
        }
        double[] weights = this.svm.getWeights();
        AttributeWeights weightVector = new AttributeWeights();
        for (int i = 0; i < exampleSet.getNumberOfAttributes(); ++i) {
            weightVector.setWeight(exampleSet.getAttribute(i).getName(), weights[i]);
        }
        return weightVector;
    }

    public abstract SVMInterface createSVM(Attribute var1, Kernel var2, ExampleSet var3, edu.udo.cs.yale.example.ExampleSet var4) throws OperatorException;

    public abstract AbstractMySVMModel createSVMModel(Attribute var1, ExampleSet var2, Kernel var3, int var4);

    public Model learn(edu.udo.cs.yale.example.ExampleSet exampleSet) throws OperatorException {
        ExampleSet svmExamples = new ExampleSet(exampleSet, exampleSet.getLabel(), this.getParameterAsBoolean("scale"));
        int kernelType = this.getParameterAsInt("kernel_type");
        int cacheSize = this.getParameterAsInt("kernel_cache");
        this.kernel = AbstractMySVMLearner.createKernel(kernelType);
        if (kernelType == 1) {
            ((KernelRadial)this.kernel).setGamma(this.getParameterAsDouble("kernel_gamma"));
        } else if (kernelType == 2) {
            ((KernelPolynomial)this.kernel).setDegree(this.getParameterAsInt("kernel_degree"));
        } else if (kernelType == 3) {
            ((KernelNeural)this.kernel).setParameter(this.getParameterAsDouble("kernel_a"), this.getParameterAsDouble("kernel_b"));
        }
        this.kernel.init(svmExamples, cacheSize);
        Attribute label = exampleSet.getLabel();
        this.svm = this.createSVM(label, this.kernel, svmExamples, exampleSet);
        this.svm.init(this.kernel, svmExamples);
        this.svm.train();
        return this.createSVMModel(exampleSet.getLabel(), svmExamples, this.kernel, kernelType);
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory("kernel_type", "The SVM kernel type", KERNEL_TYPES, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_gamma", "The SVM kernel parameter gamma (radial).", 0.0, Double.POSITIVE_INFINITY, 1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("kernel_degree", "The SVM kernel parameter degree (polynomial).", 0, Integer.MAX_VALUE, 2);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_a", "The SVM kernel parameter a (neural).", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("kernel_b", "The SVM kernel parameter b (neural).", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeInt("kernel_cache", "Size of the cache for kernel evaluations im MB ", 0, Integer.MAX_VALUE, 200));
        type = new ParameterTypeDouble("C", "The SVM complexity constant. Use -1 for different C values for positive and negative.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0.0);
        types.add(type);
        type = new ParameterTypeDouble("convergence_epsilon", "Precision on the KKT conditions", 0.0, Double.POSITIVE_INFINITY, 0.001);
        types.add(type);
        types.add(new ParameterTypeInt("max_iterations", "Stop after this many iterations", 1, Integer.MAX_VALUE, 100000));
        types.add(new ParameterTypeBoolean("scale", "Scale the example values and store the scaling parameters for test set.", true));
        types.add(new ParameterTypeBoolean("calculate_weights", "Indicates if attribute weights should be returned.", false));
        return types;
    }

    public static Kernel createKernel(int kernelType) {
        switch (kernelType) {
            case 1: {
                return new KernelRadial();
            }
            case 2: {
                return new KernelPolynomial();
            }
            case 3: {
                return new KernelNeural();
            }
        }
        return new KernelDot();
    }
}

