/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.learner;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ExampleTable;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.ResultObjectAdapter;
import edu.udo.cs.yale.operator.Saveable;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.learner.IOModel;
import edu.udo.cs.yale.operator.learner.SerializableModel;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.Tools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;

public abstract class Model
extends ResultObjectAdapter
implements Saveable {
    private transient Attribute labelAttribute;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$learner$Model;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$learner$SerializableModel;
    static /* synthetic */ Class class$edu$udo$cs$yale$operator$learner$IOModel;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$Attribute;

    protected Model() {
    }

    public Model(Attribute label) {
        this.labelAttribute = label;
    }

    public abstract void apply(ExampleSet var1) throws OperatorException;

    public abstract void writeData(ObjectOutputStream var1) throws IOException;

    public void setPredictionParameter(String name, String value) throws OperatorException {
        throw new UserError(null, 204, new Object[]{this.getClass(), name});
    }

    public String toString() {
        return "Model (type " + Tools.classNameWOPackage(this.getClass()) + ") for label " + this.labelAttribute;
    }

    public void save(File file) throws IOException {
        this.writeModel(file);
    }

    public final void writeModel(File file) throws IOException {
        LogService.logMessage("Writing model to file '" + file + "'.", 0);
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(file));
        this.writeModel(out);
        out.close();
    }

    public final void writeModel(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.getClass().getName());
        if (this.labelAttribute != null) {
            out.writeUTF("label");
            this.labelAttribute.writeAttributeData(out);
        } else {
            out.writeUTF("nolabel");
        }
        this.writeData(out);
    }

    public static final Model readModel(File file) throws OperatorException, IOException {
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
        Model model = Model.readModel(in);
        in.close();
        return model;
    }

    public static final Model readModel(ObjectInputStream in) throws IOException {
        Model model;
        block11: {
            String className = in.readUTF();
            String labelString = in.readUTF();
            Attribute label = null;
            if (labelString.equals("label")) {
                label = AttributeFactory.readAttribute(in);
            }
            model = null;
            try {
                Class c = Tools.classForName(className);
                if (!(class$edu$udo$cs$yale$operator$learner$Model == null ? (class$edu$udo$cs$yale$operator$learner$Model = Model.class$("edu.udo.cs.yale.operator.learner.Model")) : class$edu$udo$cs$yale$operator$learner$Model).isAssignableFrom(c)) {
                    throw new IOException("Model file does not contain a model (but " + c.getName() + ")!");
                }
                if ((class$edu$udo$cs$yale$operator$learner$SerializableModel == null ? (class$edu$udo$cs$yale$operator$learner$SerializableModel = Model.class$("edu.udo.cs.yale.operator.learner.SerializableModel")) : class$edu$udo$cs$yale$operator$learner$SerializableModel).isAssignableFrom(c)) {
                    model = SerializableModel.readSerializableModel(in);
                    model.labelAttribute = label;
                    break block11;
                }
                if ((class$edu$udo$cs$yale$operator$learner$IOModel == null ? (class$edu$udo$cs$yale$operator$learner$IOModel = Model.class$("edu.udo.cs.yale.operator.learner.IOModel")) : class$edu$udo$cs$yale$operator$learner$IOModel).isAssignableFrom(c)) {
                    Constructor constructor = c.getConstructor(class$edu$udo$cs$yale$example$Attribute == null ? (class$edu$udo$cs$yale$example$Attribute = Model.class$("edu.udo.cs.yale.example.Attribute")) : class$edu$udo$cs$yale$example$Attribute);
                    model = (Model)constructor.newInstance(label);
                    ((IOModel)model).readData(in);
                    break block11;
                }
                throw new IOException("Don't know how to read a '" + className + "' model!");
            }
            catch (ClassCastException e) {
                throw new IOException("'" + className + "' is not a model!");
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Don't know anything about class '" + className + "'!");
            }
            catch (InstantiationException e) {
                throw new IOException("Cannot instantiate '" + className + "': " + e);
            }
            catch (IllegalAccessException e) {
                throw new IOException("Cannot instantiate '" + className + "': " + e);
            }
            catch (NoSuchMethodException e) {
                throw new IOException("Cannot instantiate '" + className + "' (no one-argument constructor taking an Attribute): " + e);
            }
            catch (InvocationTargetException e) {
                throw new IOException("Cannot instantiate '" + className + "': Exception in constructor: " + e);
            }
        }
        return model;
    }

    public boolean equals(Object o) {
        return o != null && this.getClass().equals(o.getClass());
    }

    public Attribute getLabel() {
        return this.labelAttribute;
    }

    public Attribute createPredictedLabel(ExampleSet exampleSet) {
        return this.createPredictedLabel(exampleSet, null);
    }

    public Attribute createPredictedLabel(ExampleSet exampleSet, String name) {
        return this.createPredictedLabel(exampleSet, this.getLabel(), name);
    }

    public Attribute createPredictedLabel(ExampleSet exampleSet, Attribute label, String name) {
        Attribute predictedLabel = AttributeFactory.createAttribute(label, "prediction");
        if (name != null) {
            predictedLabel.setName(name);
        }
        ExampleTable table = exampleSet.getExampleTable();
        table.addAttribute(predictedLabel);
        exampleSet.setPredictedLabel(predictedLabel);
        if (label.isNominal()) {
            Iterator i = predictedLabel.getValues().iterator();
            while (i.hasNext()) {
                String value = (String)i.next();
                Attribute confidence = AttributeFactory.createAttribute("confidence(" + value + ")", 4);
                table.addAttribute(confidence);
                exampleSet.setSpecialAttribute("confidence(" + value + ")", confidence);
            }
        }
        return predictedLabel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

