/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.example.SparseFormatDataRowReader;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeList;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.att.AttributeSet;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class SparseFormatExampleSource
extends Operator {
    private static final Class[] INPUT_CLASSES = new Class[0];
    private static final Class[] OUTPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = SparseFormatExampleSource.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;

    public SparseFormatExampleSource(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        int format = this.getParameterAsInt("format");
        HashMap<Object, Object> prefixMap = new HashMap<Object, Object>();
        Iterator<Object> p = this.getParameterList("prefix_map").iterator();
        while (p.hasNext()) {
            Object[] prefixMapping = (Object[])p.next();
            prefixMap.put(prefixMapping[0], prefixMapping[1]);
        }
        String attributeFileName = this.getParameterAsString("attribute_file");
        File attributeFile = attributeFileName != null ? this.getExperiment().resolveFileName(attributeFileName) : null;
        String attributeDescriptionFile = this.getParameterAsString("attributes");
        AttributeSet attributeSet = null;
        if (attributeDescriptionFile != null) {
            try {
                attributeSet = new AttributeSet(this.getExperiment().resolveFileName(attributeDescriptionFile), false);
            }
            catch (Throwable e) {
                throw new UserError((Operator)this, e, 302, new Object[]{attributeDescriptionFile, e.getMessage()});
            }
            if (attributeFile != null && attributeSet.getDefaultSource() != null && !attributeFile.equals(attributeSet.getDefaultSource())) {
                LogService.logMessage("Attribute file names specified by parameter 'attribute_file' and default_source specified in '" + attributeDescriptionFile + "' do not match! Assuming the latter to be correct.", 4);
            }
            if (format != 4 && attributeSet.getSpecialAttribute("label") == null) {
                throw new UserError((Operator)this, 917, new Object[0]);
            }
            LogService.logMessage("Found " + attributeSet.getNumberOfRegularAttributes() + " regular attributes.", 0);
            attributeFile = attributeSet.getDefaultSource();
        } else {
            int dimension = this.getParameterAsInt("dimension");
            attributeSet = new AttributeSet(dimension);
            for (int i = 0; i < dimension; ++i) {
                Attribute attribute = AttributeFactory.createAttribute(4);
                attributeSet.addAttribute(attribute);
            }
            p = prefixMap.values().iterator();
            while (p.hasNext()) {
                String specialName = (String)p.next();
                attributeSet.setSpecialAttribute(specialName, AttributeFactory.createAttribute(4));
            }
            if (format != 4) {
                attributeSet.setSpecialAttribute("label", AttributeFactory.createAttribute(1));
            }
        }
        if (attributeFile == null) {
            throw new UserError((Operator)this, 902, new Object[0]);
        }
        FileReader inAttributes = null;
        FileReader inLabels = null;
        try {
            inAttributes = new FileReader(attributeFile);
        }
        catch (IOException e) {
            throw new UserError((Operator)this, (Throwable)e, 302, new Object[]{attributeFile, e.getMessage()});
        }
        String labelFile = null;
        if (format == 3) {
            labelFile = this.getParameterAsString("label_file");
            if (labelFile == null) {
                throw new UserError((Operator)this, 201, new Object[]{"format", SparseFormatDataRowReader.FORMAT_NAMES[3], "label_file"});
            }
            try {
                inLabels = labelFile != null ? new FileReader(this.getExperiment().resolveFileName(labelFile)) : null;
            }
            catch (IOException e) {
                throw new UserError((Operator)this, (Throwable)e, 302, new Object[]{labelFile, e.getMessage()});
            }
        }
        MemoryExampleTable table = new MemoryExampleTable(attributeSet.getAllAttributes());
        SparseFormatDataRowReader reader = new SparseFormatDataRowReader(new DataRowFactory(this.getParameterAsInt("datamanagement")), format, prefixMap, attributeSet, inAttributes, inLabels, this.getParameterAsInt("sample_size"));
        table.readExamples(reader);
        return new IOObject[]{table.createExampleSet(attributeSet)};
    }

    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeCategory("format", "Format of the sparse data file.", SparseFormatDataRowReader.FORMAT_NAMES, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeFile("attributes", "Name of the attribute description file.", true);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeFile("attribute_file", "Name of the data file. Only necessary if not specified in the attribute description file.", true));
        types.add(new ParameterTypeFile("label_file", "Name of the data file containing the labels. Only necessary if format is 'format_separate_file'.", true));
        types.add(new ParameterTypeInt("dimension", "Dimension of the example space. Only necessary if parameter 'attributes' is not set.", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeList("prefix_map", "Maps prefixes to names of special attributes.", new ParameterTypeString("special_attribute", "Maps prefixes to names of special attributes.")));
        types.add(new ParameterTypeInt("sample_size", "The maximum number of examples to read from the data files (-1 = all)", -1, Integer.MAX_VALUE, -1));
        types.add(new ParameterTypeCategory("datamanagement", "Determines, how the data is represented internally.", DataRowFactory.TYPE_NAMES, 1));
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

