/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.Statistics;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.tools.LogService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;

public class GNUPlotOperator
extends Operator {
    public Class[] getInputClasses() {
        return new Class[0];
    }

    public Class[] getOutputClasses() {
        return new Class[0];
    }

    public GNUPlotOperator(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        String statisticsName = this.getParameterAsString("name");
        if (!this.getExperiment().statisticsExist(statisticsName)) {
            LogService.logMessage("Statistics with name '" + statisticsName + "' does not exist.", 6);
            return new IOObject[0];
        }
        Statistics statistics = this.getExperiment().getStatistics(statisticsName);
        String[] valueNames = this.getParameterAsString("values").split(" ");
        int[] values = new int[valueNames.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = statistics.getColumnIndex(valueNames[i]);
            if (values[i] != -1) continue;
            LogService.logMessage(this.getName() + ": No data column with name '" + valueNames[i] + "' exists.", 6);
            return new IOObject[0];
        }
        String xAxisName = this.getParameterAsString("x_axis");
        int xAxis = statistics.getColumnIndex(xAxisName);
        if (xAxis == -1) {
            LogService.logMessage("No data column with name '" + xAxisName + "' exists.", 6);
            return new IOObject[0];
        }
        String yAxisName = this.getParameterAsString("y_axis");
        int yAxis = -1;
        if (yAxisName != null && (yAxis = statistics.getColumnIndex(yAxisName)) == -1) {
            LogService.logMessage("No data column with name '" + yAxisName + "' exists.", 6);
            return new IOObject[0];
        }
        String additional = "";
        if (this.isParameterSet("title")) {
            additional = additional + "set title \"" + this.getParameterAsString("title") + "\"\n";
        }
        if (this.isParameterSet("additional_parameters")) {
            additional = additional + this.getParameterAsString("additional_parameters");
        }
        try {
            File file = this.getExperiment().createFile(this.getParameterAsString("output_file"));
            LogService.logMessage("Creating gnuplot file '" + file + "'", 0);
            PrintStream out = new PrintStream(new FileOutputStream(file));
            statistics.writeGNUPlot(out, xAxis, yAxis, values, "linespoints", additional, null);
            out.close();
        }
        catch (IOException e) {
            LogService.logMessage("Cannot create output file: " + e.getMessage(), 6);
            return new IOObject[0];
        }
        return new IOObject[0];
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeFile("output_file", "The gnuplot file.", false));
        types.add(new ParameterTypeString("name", "The name of the experiment log operator which produced the statistics.", false));
        types.add(new ParameterTypeString("title", "The title of the plot.", "Created by Yale"));
        types.add(new ParameterTypeString("x_axis", "The values of the x-axis.", false));
        ParameterTypeString type = new ParameterTypeString("y_axis", "The values of the y-axis (for 3d plots).", true);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeString("values", "A whitespace separated list of values which should be plotted.", false));
        types.add(new ParameterTypeString("additional_parameters", "Additional parameters for the gnuplot header.", true));
        return types;
    }
}

