/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.io;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.DataRowFactory;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeFile;
import edu.udo.cs.yale.operator.parameter.ParameterTypeString;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.WekaTools;
import java.io.IOException;
import java.util.List;
import weka.core.Instances;
import weka.core.converters.Loader;

public class AbstractWekaExampleSource
extends Operator {
    private Loader loader;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;

    public AbstractWekaExampleSource(OperatorDescription description) {
        super(description);
    }

    protected void setLoader(Loader loader) {
        this.loader = loader;
    }

    public IOObject[] apply() throws OperatorException {
        String weightName;
        String idName;
        if (this.loader == null) {
            throw new OperatorException("Wrong implementation of Weka example source: loader must be set before this operator can be applied!");
        }
        ExampleSet result = null;
        try {
            Instances instances = this.loader.getDataSet();
            result = WekaTools.toYaleExampleSet(instances, null, this.getParameterAsInt("datamanagement"));
        }
        catch (IOException e) {
            throw new UserError((Operator)this, 302, new Object[]{this.getParameterAsString("data_file"), e.getMessage()});
        }
        String labelName = this.getParameterAsString("label_attribute");
        if (labelName != null) {
            Attribute attribute = result.getAttribute(labelName);
            if (attribute == null) {
                throw new UserError((Operator)this, 111, labelName);
            }
            if (result.getLabel() != null) {
                LogService.logMessage(this.getName() + ": label attribute was already set. Overwriting label attribute by " + labelName, 4);
            }
            result.removeAttribute(attribute);
            result.setLabel(attribute);
        }
        if ((idName = this.getParameterAsString("id_attribute")) != null) {
            Attribute attribute = result.getAttribute(idName);
            if (attribute == null) {
                throw new UserError((Operator)this, 111, idName);
            }
            if (result.getId() != null) {
                LogService.logMessage(this.getName() + ": id attribute was already set. Overwriting id attribute by " + idName, 4);
            }
            result.removeAttribute(attribute);
            result.setId(attribute);
        }
        if ((weightName = this.getParameterAsString("weight_attribute")) != null) {
            Attribute attribute = result.getAttribute(weightName);
            if (attribute == null) {
                throw new UserError((Operator)this, 111, weightName);
            }
            if (result.getWeight() != null) {
                LogService.logMessage(this.getName() + ": weight attribute was already set. Overwriting weight attribute by " + weightName, 4);
            }
            result.removeAttribute(attribute);
            result.setWeight(attribute);
        }
        return new IOObject[]{result};
    }

    public Class[] getInputClasses() {
        return new Class[0];
    }

    public Class[] getOutputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = AbstractWekaExampleSource.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeFile("data_file", "The path to the data file.", false));
        ParameterTypeString type = new ParameterTypeString("label_attribute", "The (case sensitive) name of the label attribute");
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeString("id_attribute", "The (case sensitive) name of the id attribute"));
        types.add(new ParameterTypeString("weight_attribute", "The (case sensitive) name of the weight attribute"));
        types.add(new ParameterTypeCategory("datamanagement", "Determines, how the data is represented internally.", DataRowFactory.TYPE_NAMES, 0));
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

