/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.generator;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ListDataRowReader;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class MultipleLabelGenerator
extends Operator {
    private static final int NUMBER_OF_ATTRIBUTES = 5;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;

    public MultipleLabelGenerator(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        int numberOfExamples = this.getParameterAsInt("number_examples");
        double lower = this.getParameterAsDouble("attributes_lower_bound");
        double upper = this.getParameterAsDouble("attributes_upper_bound");
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        for (int m = 0; m < 5; ++m) {
            attributes.add(AttributeFactory.createAttribute("att" + (m + 1), 4));
        }
        int type = 1;
        if (this.getParameterAsBoolean("regression")) {
            type = 4;
        }
        Attribute label1 = AttributeFactory.createAttribute("label1", type);
        attributes.add(label1);
        Attribute label2 = AttributeFactory.createAttribute("label2", type);
        attributes.add(label2);
        Attribute label3 = AttributeFactory.createAttribute("label3", type);
        attributes.add(label3);
        if (!this.getParameterAsBoolean("regression")) {
            label1.mapString("positive");
            label1.mapString("negative");
            label2.mapString("positive");
            label2.mapString("negative");
            label3.mapString("positive");
            label3.mapString("negative");
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        LinkedList<DoubleArrayDataRow> data = new LinkedList<DoubleArrayDataRow>();
        for (int n = 0; n < numberOfExamples; ++n) {
            double[] features = new double[5];
            for (int i = 0; i < features.length; ++i) {
                features[i] = RandomGenerator.getGlobalRandomGenerator().nextDoubleInRange(lower, upper);
            }
            double[] example = new double[8];
            System.arraycopy(features, 0, example, 0, features.length);
            if (this.getParameterAsBoolean("regression")) {
                example[example.length - 3] = example[0] + example[1] + example[2];
                example[example.length - 2] = 2.0 * example[0] + example[3];
                example[example.length - 1] = example[3] * example[3];
            } else {
                example[example.length - 3] = example[0] + example[1] + example[2] > 0.0 ? (double)label1.mapString("positive") : (double)label1.mapString("negative");
                example[example.length - 2] = 2.0 * example[0] + example[3] > 0.0 ? (double)label1.mapString("positive") : (double)label1.mapString("negative");
                example[example.length - 1] = example[3] * example[3] - example[2] * example[2] > 0.0 ? (double)label1.mapString("positive") : (double)label1.mapString("negative");
            }
            data.add(new DoubleArrayDataRow(example));
        }
        table.readExamples(new ListDataRowReader(data.iterator()));
        HashMap<String, Attribute> specialMap = new HashMap<String, Attribute>();
        specialMap.put("label1", label1);
        specialMap.put("label2", label2);
        specialMap.put("label3", label3);
        ExampleSet result = table.createCompleteExampleSet(specialMap);
        return new IOObject[]{result};
    }

    public Class[] getInputClasses() {
        return new Class[0];
    }

    public Class[] getOutputClasses() {
        return new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = MultipleLabelGenerator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeInt("number_examples", "The number of generated examples.", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeBoolean("regression", "Defines if multiple labels for regression tasks should be generated.", false);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble("attributes_lower_bound", "The minimum value for the attributes.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, -10.0));
        types.add(new ParameterTypeDouble("attributes_upper_bound", "The maximum value for the attributes.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 10.0));
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

