/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.generator;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeFactory;
import edu.udo.cs.yale.example.DoubleArrayDataRow;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.example.ListDataRowReader;
import edu.udo.cs.yale.example.MemoryExampleTable;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.UserError;
import edu.udo.cs.yale.operator.generator.TargetFunction;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.operator.parameter.ParameterTypeStringCategory;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.LinkedList;
import java.util.List;

public class ExampleSetGenerator
extends Operator {
    private static final String[] KNOWN_FUNCTION_NAMES = new String[]{"random", "sum", "polynomial", "non linear", "one variable non linear", "complicated function", "complicated function2", "simple sinus", "sinus", "simple superposition", "sinus frequency", "triangular function", "square pulse function", "random classification", "one third classification", "sum classification", "simple non linear classification", "interaction classification", "simple polynomial classification", "polynomial classification", "sinus classification", "multi classification", "three ring clusters", "single gaussian cluster"};
    private static final TargetFunction[] KNOWN_FUNCTIONS = new TargetFunction[]{new RandomFunction(), new SumFunction(), new PolynomialFunction(), new NonLinearFunction(), new OneVariableNonLinearFunction(), new ComplicatedFunction(), new ComplicatedFunction2(), new SimpleSinusFunction(), new SinusFunction(), new SimpleSuperpositionFunction(), new SinusFrequencyFunction(), new TriangularFunction(), new SquarePulseFunction(), new RandomClassificationFunction(), new OneThirdClassification(), new SumClassificationFunction(), new SimpleNonLinearClassificationFunction(), new InteractionClassificationFunction(), new SimplePolynomialClassificationFunction(), new PolynomialClassificationFunction(), new SinusClassificationFunction(), new MultiClassificationFunction(), new RingClusteringFunction(), new GaussianFunction()};
    private static final Class[] INPUT_CLASSES = new Class[0];
    private static final Class[] OUTPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = ExampleSetGenerator.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;

    public ExampleSetGenerator(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        int numberOfExamples = this.getParameterAsInt("number_examples");
        int numberOfAttributes = this.getParameterAsInt("number_of_attributes");
        double lower = this.getParameterAsDouble("attributes_lower_bound");
        double upper = this.getParameterAsDouble("attributes_upper_bound");
        String functionName = this.getParameterAsString("target_function");
        if (functionName == null) {
            throw new UserError((Operator)this, 205, "target_function");
        }
        TargetFunction function = ExampleSetGenerator.getFunctionForName(functionName);
        if (function == null) {
            try {
                Class<?> clazz = Class.forName(functionName);
                function = (TargetFunction)clazz.newInstance();
            }
            catch (Exception e) {
                throw new UserError((Operator)this, (Throwable)e, 904, new Object[]{functionName, e});
            }
        }
        function.setLowerArgumentBound(lower);
        function.setUpperArgumentBound(upper);
        LinkedList<Attribute> attributes = new LinkedList<Attribute>();
        for (int m = 0; m < numberOfAttributes; ++m) {
            attributes.add(AttributeFactory.createAttribute("att" + (m + 1), 4));
        }
        Attribute label = function.getLabel();
        if (label != null) {
            attributes.add(label);
        }
        MemoryExampleTable table = new MemoryExampleTable(attributes);
        LinkedList<DoubleArrayDataRow> data = null;
        try {
            data = new LinkedList<DoubleArrayDataRow>();
            for (int n = 0; n < numberOfExamples; ++n) {
                double[] features;
                double[] example = features = function.createArguments(numberOfAttributes);
                if (label != null) {
                    example = new double[numberOfAttributes + 1];
                    System.arraycopy(features, 0, example, 0, features.length);
                    example[example.length - 1] = function.calculate(features);
                }
                data.add(new DoubleArrayDataRow(example));
            }
        }
        catch (TargetFunction.FunctionException e) {
            throw new UserError((Operator)this, 918, e.getFunctionName(), (Object)e.getMessage());
        }
        table.readExamples(new ListDataRowReader(data.iterator()));
        ExampleSet result = table.createCompleteExampleSet(label, null, null, null);
        return new IOObject[]{result};
    }

    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeStringCategory("target_function", "Specifies the target function of this example set", KNOWN_FUNCTION_NAMES);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("number_examples", "The number of generated examples.", 1, Integer.MAX_VALUE, 100);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("number_of_attributes", "The number of attributes.", 0, Integer.MAX_VALUE, 5);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeDouble("attributes_lower_bound", "The minimum value for the attributes.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, -10.0));
        types.add(new ParameterTypeDouble("attributes_upper_bound", "The maximum value for the attributes.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 10.0));
        return types;
    }

    public static TargetFunction getFunctionForName(String functionName) {
        for (int i = 0; i < KNOWN_FUNCTION_NAMES.length; ++i) {
            if (!KNOWN_FUNCTION_NAMES[i].equals(functionName)) continue;
            return KNOWN_FUNCTIONS[i];
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class GaussianFunction
    implements TargetFunction {
        private double bound = 10.0;

        private GaussianFunction() {
        }

        public void setLowerArgumentBound(double lower) {
            this.bound = Math.max(this.bound, Math.abs(lower));
        }

        public void setUpperArgumentBound(double upper) {
            this.bound = Math.max(this.bound, Math.abs(upper));
        }

        public Attribute getLabel() {
            return AttributeFactory.createAttribute("label", 4);
        }

        public double calculate(double[] att) throws TargetFunction.FunctionException {
            return 0.0;
        }

        public double[] createArguments(int number) throws TargetFunction.FunctionException {
            double[] args = new double[number];
            RandomGenerator random = RandomGenerator.getGlobalRandomGenerator();
            for (int i = 0; i < args.length; ++i) {
                args[i] = random.nextGaussian() * this.bound;
            }
            return args;
        }
    }

    private static class RingClusteringFunction
    implements TargetFunction {
        private double bound = 10.0;
        private Attribute label = AttributeFactory.createAttribute("label", 1);

        public RingClusteringFunction() {
            this.label.mapString("core");
            this.label.mapString("first_ring");
            this.label.mapString("second_ring");
        }

        public void setLowerArgumentBound(double lower) {
            this.bound = Math.max(this.bound, Math.abs(lower));
        }

        public void setUpperArgumentBound(double upper) {
            this.bound = Math.max(this.bound, Math.abs(upper));
        }

        public Attribute getLabel() {
            return this.label;
        }

        public double calculate(double[] att) throws TargetFunction.FunctionException {
            if (att.length != 2) {
                throw new TargetFunction.FunctionException("Clustering function", "must have 2 attributes!");
            }
            double label = 0.0;
            if (RandomGenerator.getGlobalRandomGenerator().nextDouble() < 0.05) {
                int type = RandomGenerator.getGlobalRandomGenerator().nextInt(3);
                switch (type) {
                    case 0: {
                        return this.getLabel().mapString("core");
                    }
                    case 1: {
                        return this.getLabel().mapString("first_ring");
                    }
                    case 2: {
                        return this.getLabel().mapString("second_ring");
                    }
                }
                return this.getLabel().mapString("core");
            }
            double radius = Math.sqrt(att[0] * att[0] + att[1] * att[1]);
            if (radius < this.bound / 3.0) {
                return this.getLabel().mapString("core");
            }
            if (radius < 2.0 * this.bound / 3.0) {
                return this.getLabel().mapString("first_ring");
            }
            return this.getLabel().mapString("second_ring");
        }

        public double[] createArguments(int number) throws TargetFunction.FunctionException {
            if (number != 2) {
                throw new TargetFunction.FunctionException("Ring clustering function", "must have 2 attributes!");
            }
            double[] args = new double[number];
            RandomGenerator random = RandomGenerator.getGlobalRandomGenerator();
            int type = random.nextInt(3);
            double radius = 0.0;
            switch (type) {
                case 0: {
                    radius = random.nextGaussian();
                    break;
                }
                case 1: {
                    radius = this.bound / 2.0 + random.nextGaussian();
                    break;
                }
                case 2: {
                    radius = this.bound + random.nextGaussian();
                    break;
                }
                default: {
                    radius = random.nextGaussian();
                }
            }
            double angle = random.nextDouble() * 2.0 * Math.PI;
            args[0] = radius * Math.cos(angle);
            args[1] = radius * Math.sin(angle);
            return args;
        }
    }

    private static class MultiClassificationFunction
    extends ClassificationFunction {
        private Attribute label = AttributeFactory.createAttribute("label", 1);

        public MultiClassificationFunction() {
            this.getLabel().mapString("one");
            this.getLabel().mapString("two");
            this.getLabel().mapString("three");
            this.getLabel().mapString("four");
        }

        public Attribute getLabel() {
            return this.label;
        }

        public double calculate(double[] args) throws TargetFunction.FunctionException {
            double sumD = 0.0;
            for (int i = 0; i < args.length; ++i) {
                sumD += args[i];
            }
            int sum = Math.abs((int)Math.round(sumD));
            if (sum % 2 == 0) {
                return this.getLabel().mapString("one");
            }
            if (sum % 3 == 0) {
                return this.getLabel().mapString("two");
            }
            if (sum % 5 == 0) {
                return this.getLabel().mapString("three");
            }
            return this.getLabel().mapString("four");
        }
    }

    private static class SinusClassificationFunction
    extends ClassificationFunction {
        private SinusClassificationFunction() {
        }

        public double calculate(double[] att) throws TargetFunction.FunctionException {
            if (att.length < 2) {
                throw new TargetFunction.FunctionException("Sinus classification function", "needs at least 2 attributes!");
            }
            if (Math.sin(att[0] * att[1]) + Math.sin(att[0] + att[1]) > 0.0) {
                return this.getLabel().mapString("positive");
            }
            return this.getLabel().mapString("negative");
        }
    }

    private static class PolynomialClassificationFunction
    extends ClassificationFunction {
        private PolynomialClassificationFunction() {
        }

        public double calculate(double[] att) throws TargetFunction.FunctionException {
            if (att.length < 4) {
                throw new TargetFunction.FunctionException("Polynomial classification function", "needs at least 4 attributes!");
            }
            if (att[0] * att[0] * att[0] + att[1] * att[1] - att[2] * att[2] + att[3] > 0.0) {
                return this.getLabel().mapString("positive");
            }
            return this.getLabel().mapString("negative");
        }
    }

    private static class SimplePolynomialClassificationFunction
    extends ClassificationFunction {
        private SimplePolynomialClassificationFunction() {
        }

        public double calculate(double[] att) throws TargetFunction.FunctionException {
            if (att.length < 1) {
                throw new TargetFunction.FunctionException("Simple polynomial classification function", "needs at least one attribute!");
            }
            if (att[0] * att[0] * att[0] * att[0] > 100.0) {
                return this.getLabel().mapString("positive");
            }
            return this.getLabel().mapString("negative");
        }
    }

    private static class SimpleNonLinearClassificationFunction
    extends ClassificationFunction {
        private SimpleNonLinearClassificationFunction() {
        }

        public double calculate(double[] att) throws TargetFunction.FunctionException {
            if (att.length < 2) {
                throw new TargetFunction.FunctionException("Simple non linear classification function", "needs at least 2 attributes!");
            }
            if (att[0] * att[1] > 50.0 && att[0] * att[1] < 80.0) {
                return this.getLabel().mapString("positive");
            }
            return this.getLabel().mapString("negative");
        }
    }

    private static class InteractionClassificationFunction
    extends ClassificationFunction {
        private InteractionClassificationFunction() {
        }

        public double calculate(double[] att) throws TargetFunction.FunctionException {
            if (att.length < 3) {
                throw new TargetFunction.FunctionException("Interactive classification function", "needs at least 3 attributes!");
            }
            if (att[0] < 0.0 || att[1] > 0.0 && att[2] < 0.0) {
                return this.getLabel().mapString("positive");
            }
            return this.getLabel().mapString("negative");
        }
    }

    private static class SumClassificationFunction
    extends ClassificationFunction {
        private SumClassificationFunction() {
        }

        public double calculate(double[] args) {
            double sum = 0.0;
            for (int i = 0; i < args.length; ++i) {
                sum += args[i];
            }
            return sum > 0.0 ? this.getLabel().mapString("positive") : this.getLabel().mapString("negative");
        }
    }

    private static class OneThirdClassification
    extends ClassificationFunction {
        private OneThirdClassification() {
        }

        public double calculate(double[] args) {
            if (args[0] < 0.333333333333) {
                return this.getLabel().mapString("positive");
            }
            return this.getLabel().mapString("negative");
        }
    }

    private static class RandomClassificationFunction
    extends ClassificationFunction {
        private RandomClassificationFunction() {
        }

        public double calculate(double[] args) {
            if (RandomGenerator.getGlobalRandomGenerator().nextBoolean()) {
                return this.getLabel().mapString("positive");
            }
            return this.getLabel().mapString("negative");
        }
    }

    private static class SquarePulseFunction
    extends RegressionFunction {
        private SquarePulseFunction() {
        }

        public double calculate(double[] args) throws TargetFunction.FunctionException {
            if (args.length != 1) {
                throw new TargetFunction.FunctionException("Square pulse function", "needs 1 attribute!");
            }
            return (int)args[0] % 2 == 0 ? 1.0 : 0.0;
        }
    }

    private static class TriangularFunction
    extends RegressionFunction {
        private TriangularFunction() {
        }

        public double calculate(double[] args) throws TargetFunction.FunctionException {
            if (args.length != 1) {
                throw new TargetFunction.FunctionException("Triangular function", "needs 1 attributes!");
            }
            return args[0] - (double)((int)args[0]);
        }
    }

    private static class SimpleSuperpositionFunction
    extends RegressionFunction {
        private SimpleSuperpositionFunction() {
        }

        public double calculate(double[] args) throws TargetFunction.FunctionException {
            if (args.length != 1) {
                throw new TargetFunction.FunctionException("Simple superposition function", "needs 1 attribute!");
            }
            return 5.0 * Math.sin(args[0]) + Math.sin(30.0 * args[0]);
        }
    }

    private static class SinusFrequencyFunction
    extends RegressionFunction {
        private SinusFrequencyFunction() {
        }

        public double calculate(double[] att) throws TargetFunction.FunctionException {
            if (att.length < 2) {
                throw new TargetFunction.FunctionException("Sinus frequency function", "needs at least 2 attributes!");
            }
            return 10.0 * Math.sin(3.0 * att[0]) + 12.0 * Math.sin(7.0 * att[0]) + 11.0 * Math.sin(5.0 * att[1]) + 9.0 * Math.sin(10.0 * att[1]) + 10.0 * Math.sin(8.0 * (att[0] + att[1]));
        }
    }

    private static class SinusFunction
    extends RegressionFunction {
        private SinusFunction() {
        }

        public double calculate(double[] att) throws TargetFunction.FunctionException {
            if (att.length != 2) {
                throw new TargetFunction.FunctionException("Sinus function", "needs 2 attributes!");
            }
            return Math.sin(att[0] * att[1]) + Math.sin(att[0] + att[1]);
        }
    }

    private static class SimpleSinusFunction
    extends RegressionFunction {
        private SimpleSinusFunction() {
        }

        public double calculate(double[] att) throws TargetFunction.FunctionException {
            if (att.length != 1) {
                throw new TargetFunction.FunctionException("Simple Sinus function", "needs 1 attribute!");
            }
            return Math.sin(att[0]);
        }
    }

    private static class ComplicatedFunction2
    extends RegressionFunction {
        private ComplicatedFunction2() {
        }

        public double calculate(double[] att) throws TargetFunction.FunctionException {
            if (att.length < 3) {
                throw new TargetFunction.FunctionException("Complicated function2", "needs at least 3 attributes!");
            }
            return att[0] * att[0] * att[0] + att[1] * att[1] + att[0] * att[1] + att[0] / Math.abs(att[2]) - 1.0 / (att[2] * att[2]);
        }
    }

    private static class ComplicatedFunction
    extends RegressionFunction {
        private ComplicatedFunction() {
        }

        public double calculate(double[] att) throws TargetFunction.FunctionException {
            if (att.length < 3) {
                throw new TargetFunction.FunctionException("Complicated function", "needs at least 3 attributes!");
            }
            return att[0] * att[0] * att[1] + att[1] * att[2] + Math.max(att[0], att[1]) - Math.exp(att[2]);
        }
    }

    private static class OneVariableNonLinearFunction
    extends RegressionFunction {
        private OneVariableNonLinearFunction() {
        }

        public double calculate(double[] att) throws TargetFunction.FunctionException {
            if (att.length != 1) {
                throw new TargetFunction.FunctionException("One variable non linear", "needs one attribute!");
            }
            return 3.0 * att[0] * att[0] * att[0] - att[0] * att[0] + 1000.0 / Math.abs(att[0]) + 2000.0 * Math.abs(att[0]);
        }
    }

    private static class NonLinearFunction
    extends RegressionFunction {
        private NonLinearFunction() {
        }

        public double calculate(double[] att) throws TargetFunction.FunctionException {
            if (att.length < 3) {
                throw new TargetFunction.FunctionException("Non linear function", "needs at least 3 attributes!");
            }
            return att[0] * att[1] * att[2] + att[0] * att[1] + att[1] * att[1];
        }
    }

    private static class PolynomialFunction
    extends RegressionFunction {
        private PolynomialFunction() {
        }

        public double calculate(double[] att) throws TargetFunction.FunctionException {
            if (att.length < 3) {
                throw new TargetFunction.FunctionException("Polynomial function", "needs at least 3 attributes!");
            }
            return att[0] * att[0] * att[0] + att[1] * att[1] + att[2];
        }
    }

    private static class SumFunction
    extends RegressionFunction {
        private SumFunction() {
        }

        public double calculate(double[] args) {
            double sum = 0.0;
            for (int i = 0; i < args.length; ++i) {
                sum += args[i];
            }
            return sum;
        }
    }

    private static class RandomFunction
    extends RegressionFunction {
        private RandomFunction() {
        }

        public double calculate(double[] args) {
            return RandomGenerator.getGlobalRandomGenerator().nextDouble();
        }
    }

    private static abstract class ClassificationFunction
    implements TargetFunction {
        protected double lower = -10.0;
        protected double upper = 10.0;
        private Attribute label = AttributeFactory.createAttribute("label", 1);

        public ClassificationFunction() {
            this.label.mapString("negative");
            this.label.mapString("positive");
        }

        public void setLowerArgumentBound(double lower) {
            this.lower = lower;
        }

        public void setUpperArgumentBound(double upper) {
            this.upper = upper;
        }

        public Attribute getLabel() {
            return this.label;
        }

        public double[] createArguments(int dimension) {
            double[] args = new double[dimension];
            for (int i = 0; i < args.length; ++i) {
                args[i] = RandomGenerator.getGlobalRandomGenerator().nextDoubleInRange(this.lower, this.upper);
            }
            return args;
        }
    }

    private static abstract class RegressionFunction
    implements TargetFunction {
        private double lower = -10.0;
        private double upper = 10.0;

        private RegressionFunction() {
        }

        public void setLowerArgumentBound(double lower) {
            this.lower = lower;
        }

        public void setUpperArgumentBound(double upper) {
            this.upper = upper;
        }

        public Attribute getLabel() {
            return AttributeFactory.createAttribute("label", 4);
        }

        public double[] createArguments(int dimension) {
            double[] args = new double[dimension];
            for (int i = 0; i < args.length; ++i) {
                args[i] = RandomGenerator.getGlobalRandomGenerator().nextDoubleInRange(this.lower, this.upper);
            }
            return args;
        }
    }
}

