/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.weighting;

import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.operator.features.ga.AbstractGeneticAlgorithm;
import edu.udo.cs.yale.operator.features.ga.SelectionCrossover;
import edu.udo.cs.yale.operator.features.weighting.VarianceAdaption;
import edu.udo.cs.yale.operator.features.weighting.WeightingCrossover;
import edu.udo.cs.yale.operator.features.weighting.WeightingMutation;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.LinkedList;
import java.util.List;

public class EvolutionaryWeighting
extends AbstractGeneticAlgorithm {
    private WeightingMutation weighting = null;

    public EvolutionaryWeighting(OperatorDescription description) {
        super(description);
    }

    public PopulationOperator getCrossoverPopulationOperator(ExampleSet eSet) {
        return new WeightingCrossover(this.getParameterAsInt("crossover_type"), this.getParameterAsDouble("p_crossover"));
    }

    public PopulationOperator getMutationPopulationOperator(ExampleSet eSet) {
        this.weighting = new WeightingMutation(this.getParameterAsDouble("mutation_variance"), this.getParameterAsBoolean("bounded_mutation"));
        return this.weighting;
    }

    protected List getPostProcessingPopulationOperators(ExampleSet eSet) {
        LinkedList<VarianceAdaption> otherPostOps = new LinkedList<VarianceAdaption>();
        if (this.getParameterAsBoolean("1_5_rule")) {
            otherPostOps.add(new VarianceAdaption(this.weighting, eSet.getNumberOfAttributes()));
        }
        return otherPostOps;
    }

    public Population createInitialPopulation(ExampleSet exampleSet) {
        int numberOfIndividuals = this.getParameterAsInt("population_size");
        Population initPop = new Population();
        for (int i = 0; i < numberOfIndividuals; ++i) {
            AttributeWeightedExampleSet nes = new AttributeWeightedExampleSet((ExampleSet)exampleSet.clone());
            for (int j = 0; j < nes.getNumberOfAttributes(); ++j) {
                nes.setWeightForBlock(j, RandomGenerator.getGlobalRandomGenerator().nextDouble());
            }
            initPop.add(nes);
        }
        return initPop;
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeDouble("mutation_variance", "The (initial) variance for each mutation.", 0.0, Double.POSITIVE_INFINITY, 1.0));
        types.add(new ParameterTypeBoolean("1_5_rule", "If set to true, the 1/5 rule for variance adaption is used.", true));
        types.add(new ParameterTypeBoolean("bounded_mutation", "If set to true, the weights are bounded between 0 and 1.", false));
        ParameterTypeDouble type = new ParameterTypeDouble("p_crossover", "Probability for an individual to be selected for crossover.", 0.0, 1.0, 0.0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory("crossover_type", "Type of the crossover.", SelectionCrossover.CROSSOVER_TYPES, 1));
        return types;
    }
}

