/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.ga.selection;

import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.LinkedList;

public class TournamentSelection
implements PopulationOperator {
    private int popSize;
    private double tournamentFraction;
    private double delta = 0.0;
    private boolean keepBest = false;

    public TournamentSelection(int popSize, double tournamentFraction, int maxGenerations, boolean dynamic, boolean keepBest) {
        this.popSize = popSize;
        this.keepBest = keepBest;
        this.tournamentFraction = tournamentFraction;
        if (dynamic) {
            this.delta = (1.0 - this.tournamentFraction) / (double)(maxGenerations + 1);
        }
    }

    public boolean performOperation(int generation) {
        return true;
    }

    public void operate(Population population) {
        LinkedList<Object> newGeneration = new LinkedList<Object>();
        int tournamentSize = Math.max((int)Math.round((double)population.getNumberOfIndividuals() * this.tournamentFraction), 1);
        if (this.keepBest) {
            newGeneration.add(population.bestEver().clone());
        }
        while (newGeneration.size() < this.popSize) {
            ExampleSet winner = null;
            for (int k = 0; k < tournamentSize; ++k) {
                AttributeWeightedExampleSet current = population.get(RandomGenerator.getGlobalRandomGenerator().nextInt(population.getNumberOfIndividuals()));
                if (winner != null && !(((PerformanceVector)current.getUserData("performance")).getMainCriterion().getFitness() > ((PerformanceVector)winner.getUserData("performance")).getMainCriterion().getFitness())) continue;
                winner = current;
            }
            newGeneration.add(winner.clone());
        }
        population.clear();
        population.addAll(newGeneration);
        this.tournamentFraction += this.delta;
    }
}

