/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.ga.selection;

import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.operator.performance.PerformanceVector;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.LinkedList;
import java.util.ListIterator;

public class StochasticUniversalSampling
implements PopulationOperator {
    private int popSize;
    private boolean keepBest;

    public StochasticUniversalSampling(int popSize, boolean keepBest) {
        this.popSize = popSize;
        this.keepBest = keepBest;
    }

    public boolean performOperation(int generation) {
        return true;
    }

    public double filterFitness(double fitness) {
        return fitness;
    }

    public void operate(Population population) {
        LinkedList<AttributeWeightedExampleSet> newGeneration = new LinkedList<AttributeWeightedExampleSet>();
        if (this.keepBest) {
            AttributeWeightedExampleSet best = (AttributeWeightedExampleSet)population.bestEver().clone();
            newGeneration.add(best);
        }
        int numberOfMarks = this.popSize - newGeneration.size();
        double distance = 1.0 / (double)numberOfMarks;
        double r = RandomGenerator.getGlobalRandomGenerator().nextDouble() / (double)numberOfMarks;
        for (int i = 0; i < numberOfMarks; ++i) {
            double f = 0.0;
            int j = 0;
            AttributeWeightedExampleSet exampleSet = null;
            while ((f += this.filterFitness(((PerformanceVector)(exampleSet = population.get(j++)).getUserData("performance")).getMainCriterion().getFitness())) < r) {
            }
            newGeneration.add(exampleSet);
            r += distance;
        }
        population.clear();
        ListIterator i = newGeneration.listIterator();
        while (i.hasNext()) {
            population.add((AttributeWeightedExampleSet)i.next());
        }
    }
}

