/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.ga;

import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class SelectionCrossover
implements PopulationOperator {
    public static final String[] CROSSOVER_TYPES = new String[]{"one_point", "uniform", "shuffle"};
    public static final int ONE_POINT = 0;
    public static final int UNIFORM = 1;
    public static final int SHUFFLE = 2;
    private int type;
    private double prob;

    public SelectionCrossover(int type, double prob) {
        this.prob = prob;
        this.type = type;
    }

    public boolean performOperation(int generation) {
        return true;
    }

    public int getType() {
        return this.type;
    }

    public void crossover(AttributeWeightedExampleSet es1, AttributeWeightedExampleSet es2) {
        switch (this.type) {
            case 0: {
                int n = 1 + RandomGenerator.getGlobalRandomGenerator().nextInt(es1.getNumberOfAttributes() - 1);
                for (int i = n = es1.getExampleTable().getBlockEndIndex(n); i < es1.getNumberOfAttributes(); ++i) {
                    boolean dummy = es1.isAttributeUsed(i);
                    es1.setAttributeUsed(i, es2.isAttributeUsed(i));
                    es2.setAttributeUsed(i, dummy);
                }
                break;
            }
            case 1: {
                boolean[] swap = new boolean[es1.getNumberOfAttributes()];
                for (int i = 0; i < swap.length; ++i) {
                    boolean blockBoolean = RandomGenerator.getGlobalRandomGenerator().nextBoolean();
                    int endIndex = es1.getExampleTable().getBlockEndIndex(i);
                    for (int j = i; j <= endIndex; ++j) {
                        if (j >= swap.length) continue;
                        swap[j] = blockBoolean;
                    }
                    i = endIndex;
                }
                this.swapAttributes(es1, es2, swap);
                break;
            }
            case 2: {
                boolean[] swap = new boolean[es1.getNumberOfAttributes()];
                ArrayList<Integer> indices = new ArrayList<Integer>();
                for (int i = 0; i < swap.length; ++i) {
                    indices.add(new Integer(i));
                    i = es1.getExampleTable().getBlockEndIndex(i);
                }
                if (indices.size() > 0) {
                    int toSwap = RandomGenerator.getGlobalRandomGenerator().nextInt(indices.size() - 1) + 1;
                    for (int i = 0; i < toSwap; ++i) {
                        int index = (Integer)indices.remove(RandomGenerator.getGlobalRandomGenerator().nextInt(indices.size()));
                        int endIndex = es1.getExampleTable().getBlockEndIndex(index);
                        for (int j = i; j <= endIndex; ++j) {
                            if (j >= swap.length) continue;
                            swap[j] = true;
                        }
                    }
                }
                this.swapAttributes(es1, es2, swap);
                break;
            }
        }
    }

    private void swapAttributes(AttributeWeightedExampleSet es1, AttributeWeightedExampleSet es2, boolean[] swap) {
        for (int i = 0; i < swap.length; ++i) {
            if (!swap[i]) continue;
            boolean dummy = es1.isAttributeUsed(i);
            es1.setAttributeUsed(i, es2.isAttributeUsed(i));
            es2.setAttributeUsed(i, dummy);
        }
    }

    public void operate(Population population) {
        if (population.getNumberOfIndividuals() < 2) {
            return;
        }
        LinkedList<Object> matingPool = new LinkedList<Object>();
        for (int i = 0; i < population.getNumberOfIndividuals(); ++i) {
            matingPool.add(population.get(i).clone());
        }
        LinkedList<Object> l = new LinkedList<Object>();
        while (matingPool.size() > 1) {
            AttributeWeightedExampleSet p1 = (AttributeWeightedExampleSet)matingPool.remove(RandomGenerator.getGlobalRandomGenerator().nextInt(matingPool.size()));
            AttributeWeightedExampleSet p2 = (AttributeWeightedExampleSet)matingPool.remove(RandomGenerator.getGlobalRandomGenerator().nextInt(matingPool.size()));
            if (RandomGenerator.getGlobalRandomGenerator().nextDouble() < this.prob) {
                AttributeWeightedExampleSet clone1 = (AttributeWeightedExampleSet)p1.clone();
                AttributeWeightedExampleSet clone2 = (AttributeWeightedExampleSet)p2.clone();
                this.crossover(clone1, clone2);
                if (clone1.getNumberOfUsedAttributes() > 0) {
                    l.add(clone1);
                }
                if (clone2.getNumberOfUsedAttributes() <= 0) continue;
                l.add(clone2);
                continue;
            }
            l.add(p1);
            l.add(p2);
        }
        l.addAll(matingPool);
        population.clear();
        Iterator i = l.iterator();
        while (i.hasNext()) {
            population.add((AttributeWeightedExampleSet)i.next());
        }
    }
}

