/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.ga;

import edu.udo.cs.yale.example.AttributeWeightedExampleSet;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.features.Population;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.operator.features.ga.AbstractGeneticAlgorithm;
import edu.udo.cs.yale.operator.features.ga.SelectionCrossover;
import edu.udo.cs.yale.operator.features.ga.SelectionMutation;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.tools.RandomGenerator;
import java.util.List;

public class GeneticAlgorithm
extends AbstractGeneticAlgorithm {
    public GeneticAlgorithm(OperatorDescription description) {
        super(description);
    }

    public Population createInitialPopulation(ExampleSet es) {
        Population initP = new Population();
        boolean i = false;
        while (initP.getNumberOfIndividuals() < this.getParameterAsInt("population_size")) {
            AttributeWeightedExampleSet nes = new AttributeWeightedExampleSet((ExampleSet)es.clone());
            for (int j = 0; j < nes.getNumberOfAttributes(); ++j) {
                if (!(RandomGenerator.getGlobalRandomGenerator().nextDouble() < 1.0 - this.getParameterAsDouble("p_initialize"))) continue;
                j = nes.flipAttributeUsed(j);
            }
            if (nes.getNumberOfUsedAttributes() <= 0) continue;
            initP.add(nes);
        }
        return initP;
    }

    protected PopulationOperator getMutationPopulationOperator(ExampleSet eSet) {
        double pMutation = this.getParameterAsDouble("p_mutation");
        return new SelectionMutation(pMutation);
    }

    protected PopulationOperator getCrossoverPopulationOperator(ExampleSet eSet) {
        double pCrossover = this.getParameterAsDouble("p_crossover");
        int crossoverType = this.getParameterAsInt("crossover_type");
        return new SelectionCrossover(crossoverType, pCrossover);
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        types.add(new ParameterTypeDouble("p_initialize", "Initial probability for an attribute to be switched on.", 0.0, 1.0, 0.5));
        ParameterTypeDouble type = new ParameterTypeDouble("p_mutation", "Probability for an attribute to be changed (-1: 1 / numberOfAtt).", -1.0, 1.0, -1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("p_crossover", "Probability for an individual to be selected for crossover.", 0.0, 1.0, 0.5);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeCategory("crossover_type", "Type of the crossover.", SelectionCrossover.CROSSOVER_TYPES, 1));
        return types;
    }
}

