/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features.ga;

import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.features.AttributeGenerator;
import edu.udo.cs.yale.operator.features.PopulationOperator;
import edu.udo.cs.yale.operator.features.ga.AbstractGeneratingGeneticAlgorithm;
import edu.udo.cs.yale.operator.features.ga.SelectionMutation;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeNumber;
import edu.udo.cs.yale.tools.LogService;
import java.util.List;

public class GeneratingGeneticAlgorithm
extends AbstractGeneratingGeneticAlgorithm {
    public GeneratingGeneticAlgorithm(OperatorDescription description) {
        super(description);
    }

    protected PopulationOperator getMutationPopulationOperator(ExampleSet eSet) {
        double pMutation = this.getParameterAsDouble("p_mutation");
        return new SelectionMutation(pMutation);
    }

    protected PopulationOperator getGeneratingPopulationOperator(ExampleSet eSet) {
        List generators = this.getGenerators();
        if (generators.size() == 0) {
            LogService.logMessage("No FeatureGenerators specified for " + this.getName() + ".", 4);
        }
        int noOfNewAttributes = this.getParameterAsInt("max_number_of_new_attributes");
        double pGenerate = this.getParameterAsDouble("p_generate");
        return new AttributeGenerator(pGenerate, noOfNewAttributes, generators);
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeNumber type = new ParameterTypeInt("max_number_of_new_attributes", "Max number of attributes to generate for an individual.", 0, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("p_generate", "Probability for an individual to be selected for generation.", 0.0, 1.0, 0.1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeDouble("p_mutation", "Probability for an attribute to be changed (-1: 1 / numberOfAtts).", -1.0, 1.0, 0.1);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

