/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator.features;

import edu.udo.cs.yale.example.Attribute;
import edu.udo.cs.yale.example.AttributeWeights;
import edu.udo.cs.yale.example.ExampleSet;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeDouble;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import java.util.List;

public class AttributeWeightSelection
extends Operator {
    private static final String[] WEIGHT_RELATIONS = new String[]{"greater", "greater equals", "equals", "less equals", "less"};
    private static final int GREATER = 0;
    private static final int GREATER_EQUALS = 1;
    private static final int EQUALS = 2;
    private static final int LESS_EQUALS = 3;
    private static final int LESS = 4;
    private static final Class[] INPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = AttributeWeightSelection.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet, class$edu$udo$cs$yale$example$AttributeWeights == null ? (class$edu$udo$cs$yale$example$AttributeWeights = AttributeWeightSelection.class$("edu.udo.cs.yale.example.AttributeWeights")) : class$edu$udo$cs$yale$example$AttributeWeights};
    private static final Class[] OUTPUT_CLASSES = new Class[]{class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = AttributeWeightSelection.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet};
    static /* synthetic */ Class class$edu$udo$cs$yale$example$ExampleSet;
    static /* synthetic */ Class class$edu$udo$cs$yale$example$AttributeWeights;

    public AttributeWeightSelection(OperatorDescription description) {
        super(description);
    }

    public IOObject[] apply() throws OperatorException {
        ExampleSet eSet = (ExampleSet)this.getInput(class$edu$udo$cs$yale$example$ExampleSet == null ? (class$edu$udo$cs$yale$example$ExampleSet = AttributeWeightSelection.class$("edu.udo.cs.yale.example.ExampleSet")) : class$edu$udo$cs$yale$example$ExampleSet);
        AttributeWeights weights = (AttributeWeights)this.getInput(class$edu$udo$cs$yale$example$AttributeWeights == null ? (class$edu$udo$cs$yale$example$AttributeWeights = AttributeWeightSelection.class$("edu.udo.cs.yale.example.AttributeWeights")) : class$edu$udo$cs$yale$example$AttributeWeights);
        boolean deselectUnknown = this.getParameterAsBoolean("deselect_unknown");
        double relationWeight = this.getParameterAsDouble("weight");
        int relation = this.getParameterAsInt("weight_relation");
        boolean useAbsoluteWeights = this.getParameterAsBoolean("use_absolute_weights");
        block7: for (int i = eSet.getNumberOfAttributes() - 1; i >= 0; --i) {
            Attribute attribute = eSet.getAttribute(i);
            double weight = weights.getWeight(attribute.getName());
            if (useAbsoluteWeights) {
                weight = Math.abs(weight);
            }
            if (Double.isNaN(weight) && deselectUnknown) {
                eSet.removeAttribute(attribute);
                continue;
            }
            switch (relation) {
                case 0: {
                    if (!(weight <= relationWeight)) continue block7;
                    eSet.removeAttribute(attribute);
                    continue block7;
                }
                case 1: {
                    if (!(weight < relationWeight)) continue block7;
                    eSet.removeAttribute(attribute);
                    continue block7;
                }
                case 2: {
                    if (weight == relationWeight) continue block7;
                    eSet.removeAttribute(attribute);
                    continue block7;
                }
                case 3: {
                    if (!(weight > relationWeight)) continue block7;
                    eSet.removeAttribute(attribute);
                    continue block7;
                }
                case 4: {
                    if (!(weight >= relationWeight)) continue block7;
                    eSet.removeAttribute(attribute);
                }
            }
        }
        return new IOObject[]{eSet};
    }

    public Class[] getInputClasses() {
        return INPUT_CLASSES;
    }

    public Class[] getOutputClasses() {
        return OUTPUT_CLASSES;
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        ParameterTypeSingle type = new ParameterTypeDouble("weight", "Use this weight for the selection relation.", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 1.0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory("weight_relation", "Selects only weights which fulfill this relation.", WEIGHT_RELATIONS, 0);
        type.setExpert(false);
        types.add(type);
        types.add(new ParameterTypeBoolean("deselect_unknown", "Indicates if attributes which weight is unknown should be deselected.", true));
        types.add(new ParameterTypeBoolean("use_absolute_weights", "Indicates if the absolute values of the weights should be used for comparison.", true));
        return types;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

