/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator;

import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.IllegalInputException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.tools.LogService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public abstract class OperatorChain
extends Operator {
    private List operators = new ArrayList();
    private int stepCounter = 0;

    public OperatorChain(OperatorDescription description) {
        super(description);
    }

    public Operator cloneOperator(String name) {
        OperatorChain clone = (OperatorChain)super.cloneOperator(name);
        clone.stepCounter = this.stepCounter;
        clone.operators = new ArrayList();
        Iterator i = this.operators.iterator();
        while (i.hasNext()) {
            Operator originalChild = (Operator)i.next();
            Operator clonedChild = originalChild.cloneOperator(originalChild.getName());
            clonedChild.setParent(clone);
            clone.addOperator(clonedChild);
        }
        return clone;
    }

    public void setExperiment(Experiment experiment) {
        super.setExperiment(experiment);
        for (int i = 0; i < this.getNumberOfOperators(); ++i) {
            this.getOperator(i).setExperiment(experiment);
        }
    }

    public abstract Class[] checkIO(Class[] var1) throws IllegalInputException;

    public abstract int getMaxNumberOfInnerOperators();

    public abstract int getMinNumberOfInnerOperators();

    public Class[] getAllOutputClasses(Class[] innerOutput) {
        Class[] deliveredOutput = this.getDeliveredOutputClasses();
        Class[] result = new Class[deliveredOutput.length + innerOutput.length];
        System.arraycopy(deliveredOutput, 0, result, 0, deliveredOutput.length);
        System.arraycopy(innerOutput, 0, result, deliveredOutput.length, innerOutput.length);
        return result;
    }

    public int addOperator(Operator o) {
        if (o == null) {
            return -1;
        }
        o.setParent(this);
        this.operators.add(o);
        if (this.getNumberOfOperators() == this.getMaxNumberOfInnerOperators() + 1) {
            LogService.logMessage("More than " + this.getMaxNumberOfInnerOperators() + " inner operators in " + this.getName() + "!", 4);
        }
        return this.getNumberOfAllOperators() - 1;
    }

    public void addOperator(Operator operator, int index) {
        this.operators.add(index, operator);
        operator.setParent(this);
        if (this.getNumberOfOperators() == this.getMaxNumberOfInnerOperators() + 1) {
            LogService.logMessage("More than " + this.getMaxNumberOfInnerOperators() + " inner operators in " + this.getName() + "!", 4);
        }
    }

    public void removeOperator(Operator operator) {
        this.operators.remove(operator);
    }

    public Operator getOperator(int i) {
        if (i < 0 || i >= this.getNumberOfOperators()) {
            throw new RuntimeException("Illegal operator index in getOperator() (" + this.getName() + "): " + i);
        }
        int counter = 0;
        Iterator o = this.operators.iterator();
        while (o.hasNext()) {
            Operator operator = (Operator)o.next();
            if (!operator.isEnabled()) continue;
            if (counter == i) {
                return operator;
            }
            ++counter;
        }
        return null;
    }

    public Iterator getOperators() {
        return this.operators.iterator();
    }

    public List getAllInnerOperators() {
        LinkedList<Operator> children = new LinkedList<Operator>();
        for (int i = 0; i < this.operators.size(); ++i) {
            Operator innerOp = this.getOperator(i);
            children.add(innerOp);
            if (!(innerOp instanceof OperatorChain)) continue;
            children.addAll(((OperatorChain)innerOp).getAllInnerOperators());
        }
        return children;
    }

    public int getNumberOfOperators() {
        int number = 0;
        Iterator i = this.operators.iterator();
        while (i.hasNext()) {
            Operator op = (Operator)i.next();
            if (!op.isEnabled()) continue;
            ++number;
        }
        return number;
    }

    public int getNumberOfAllOperators() {
        return this.operators.size();
    }

    public Operator getOperatorFromAll(int i) {
        return (Operator)this.operators.get(i);
    }

    public int getIndexOfOperator(Operator operator) {
        return this.operators.indexOf(operator);
    }

    public Operator getInnerOperatorForName(String name) {
        if (name == null) {
            return null;
        }
        if (name.equals(this.getName())) {
            return this;
        }
        ListIterator i = this.operators.listIterator();
        while (i.hasNext()) {
            Operator innerinner;
            Operator inner = (Operator)i.next();
            if (name.equals(inner.getName())) {
                return inner;
            }
            if (!(inner instanceof OperatorChain) || (innerinner = ((OperatorChain)inner).getInnerOperatorForName(name)) == null) continue;
            return innerinner;
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Iterator i = this.operators.iterator();
        while (i.hasNext()) {
            Operator child = (Operator)i.next();
            child.setEnabled(enabled);
        }
    }

    public boolean isEnabled() {
        if (this.getParent() == null) {
            return super.isEnabled();
        }
        return super.isEnabled() && this.getParent().isEnabled();
    }

    public void experimentStarts() {
        super.experimentStarts();
        for (int i = 0; i < this.getNumberOfOperators(); ++i) {
            this.getOperator(i).experimentStarts();
        }
    }

    public void experimentFinished() {
        super.experimentFinished();
        for (int i = 0; i < this.getNumberOfOperators(); ++i) {
            this.getOperator(i).experimentFinished();
        }
    }

    public IOObject[] apply() throws OperatorException {
        this.clearStepCounter();
        IOContainer input = this.getInput();
        Iterator i = this.operators.iterator();
        while (i.hasNext()) {
            input = ((Operator)i.next()).apply(input);
        }
        return input.getIOObjects();
    }

    protected IOContainer handleAdditionalOutput(IOContainer container, IOObject[] additional) {
        return container.prepend(additional);
    }

    public int checkProperties() {
        int errorCount = super.checkProperties();
        Iterator i = this.operators.iterator();
        while (i.hasNext()) {
            Operator o = (Operator)i.next();
            if (!o.isEnabled()) continue;
            errorCount += o.checkProperties();
        }
        return errorCount;
    }

    public int checkDeprecations() {
        int deprecationCount = super.checkDeprecations();
        Iterator i = this.operators.iterator();
        while (i.hasNext()) {
            Operator o = (Operator)i.next();
            deprecationCount += o.checkDeprecations();
        }
        return deprecationCount;
    }

    public int checkNumberOfInnerOperators() {
        int errorCount = 0;
        if (this.getNumberOfOperators() < this.getMinNumberOfInnerOperators() || this.getNumberOfOperators() > this.getMaxNumberOfInnerOperators()) {
            int maximum = this.getMaxNumberOfInnerOperators();
            String maximumString = maximum == Integer.MAX_VALUE ? "infinity" : maximum + "";
            String message = "Operator has " + this.getNumberOfOperators() + " " + (this.getNumberOfOperators() == 1 ? "child" : "children") + ", should be " + (this.getMinNumberOfInnerOperators() == this.getMaxNumberOfInnerOperators() ? this.getMinNumberOfInnerOperators() + "" : " between " + this.getMinNumberOfInnerOperators() + " and " + maximumString);
            this.addError(message);
            ++errorCount;
        }
        Iterator i = this.operators.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof OperatorChain) || !((Operator)o).isEnabled()) continue;
            errorCount += ((OperatorChain)o).checkNumberOfInnerOperators();
        }
        return errorCount;
    }

    public String createExperimentTree(String indent, String selfPrefix, String childPrefix, Operator markOperator, String mark) {
        String tree = super.createExperimentTree(indent, selfPrefix, childPrefix, markOperator, mark);
        Iterator i = this.operators.iterator();
        while (i.hasNext()) {
            Operator o = (Operator)i.next();
            tree = tree + "\n" + o.createExperimentTree(indent, childPrefix + "+- ", childPrefix + (i.hasNext() ? "|  " : "   "), markOperator, mark);
        }
        return tree;
    }

    protected final String getInnerOperatorsXML(String indent) {
        StringBuffer result = new StringBuffer();
        Iterator i = this.operators.iterator();
        while (i.hasNext()) {
            result.append(((Operator)i.next()).getXML(indent));
        }
        return result.toString();
    }

    public void delete() {
        Iterator i = this.operators.iterator();
        while (i.hasNext()) {
            Operator operator = (Operator)i.next();
            operator.delete();
        }
        super.delete();
    }

    public void clearErrorList() {
        Iterator i = this.operators.iterator();
        while (i.hasNext()) {
            ((Operator)i.next()).clearErrorList();
        }
        super.clearErrorList();
    }

    public abstract int getNumberOfSteps();

    public int getNumberOfChildrensSteps() {
        int sum = 0;
        for (int i = 0; i < this.getNumberOfOperators(); ++i) {
            sum += this.getOperator(i).getNumberOfSteps();
        }
        return sum;
    }

    public void countStep() {
        int max = this.getNumberOfSteps();
        if (this.stepCounter < max) {
            ++this.stepCounter;
        }
        if (this.getParent() != null) {
            this.getParent().countStep();
        }
    }

    public int getCurrentStep() {
        return this.stepCounter;
    }

    public void clearStepCounter() {
        this.stepCounter = 0;
    }
}

