/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator;

import edu.udo.cs.yale.BreakpointListener;
import edu.udo.cs.yale.Experiment;
import edu.udo.cs.yale.operator.ExperimentStoppedException;
import edu.udo.cs.yale.operator.IOContainer;
import edu.udo.cs.yale.operator.IODescription;
import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.IllegalInputException;
import edu.udo.cs.yale.operator.InputDescription;
import edu.udo.cs.yale.operator.MissingIOObjectException;
import edu.udo.cs.yale.operator.OperatorChain;
import edu.udo.cs.yale.operator.OperatorCreationException;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.Value;
import edu.udo.cs.yale.operator.parameter.ParameterType;
import edu.udo.cs.yale.operator.parameter.ParameterTypeBoolean;
import edu.udo.cs.yale.operator.parameter.ParameterTypeColor;
import edu.udo.cs.yale.operator.parameter.Parameters;
import edu.udo.cs.yale.tools.LogService;
import edu.udo.cs.yale.tools.OperatorService;
import edu.udo.cs.yale.tools.Tools;
import edu.udo.cs.yale.tools.XMLException;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class Operator {
    private boolean[] breakPoint = new boolean[BreakpointListener.BREAKPOINT_POS_NAME.length];
    private Thread breakpointThread = null;
    private boolean enabled = true;
    private String name;
    private String userDescription;
    private Experiment experiment;
    private OperatorChain parent;
    private IOContainer inputContainer;
    private int applyCount;
    private long startTime;
    private long loopStartTime;
    private Parameters parameters = null;
    private Map valueMap = new TreeMap();
    private List errorList = new LinkedList();
    private OperatorDescription operatorDescription = null;

    public Operator(OperatorDescription description) {
        this.operatorDescription = description;
        this.parameters = new Parameters(this.getParameterTypes());
        this.addValue(new Value("applycount", "The number of times the operator was applied.", false){

            public double getValue() {
                return Operator.this.applyCount;
            }
        });
        this.addValue(new Value("time", "The time elapsed since this operator started.", false){

            public double getValue() {
                return System.currentTimeMillis() - Operator.this.startTime;
            }
        });
        this.addValue(new Value("looptime", "The time elapsed since the current loop started.", false){

            public double getValue() {
                return System.currentTimeMillis() - Operator.this.loopStartTime;
            }
        });
    }

    public final OperatorDescription getOperatorDescription() {
        return this.operatorDescription;
    }

    public final String getOperatorClassName() {
        return this.operatorDescription.getName();
    }

    public final void register(Experiment experiment, String name) {
        this.experiment = experiment;
        this.setName(name);
    }

    public final Experiment getExperiment() {
        return this.experiment;
    }

    protected void setExperiment(Experiment experiment) {
        this.experiment = experiment;
    }

    private void setName(String name) {
        this.name = this.experiment.getFirstFreeName(name);
        this.experiment.registerOperator(this.name, this);
    }

    public String getName() {
        return this.name;
    }

    public final void rename(String name) {
        if (this.name != null) {
            this.experiment.unRegisterOperator(this.name);
        }
        this.setName(name);
    }

    public void setUserDescription(String description) {
        this.userDescription = description;
    }

    public String getUserDescription() {
        return this.userDescription;
    }

    public String getDeprecationInfo() {
        return null;
    }

    public final void setParent(OperatorChain parent) {
        this.parent = parent;
        if (parent != null) {
            this.setExperiment(parent.getExperiment());
        }
    }

    public final OperatorChain getParent() {
        return this.parent;
    }

    public void remove() {
        if (this.parent != null) {
            this.parent.removeOperator(this);
        }
        this.delete();
    }

    protected void delete() {
        this.experiment.unRegisterOperator(this.name);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getStatus() {
        return this.name + " [" + this.applyCount + "]";
    }

    public int getApplyCount() {
        return this.applyCount;
    }

    public Operator cloneOperator(String name) {
        Operator clone = null;
        try {
            clone = this.operatorDescription.createOperatorInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            LogService.logMessage("Can not create clone of operator '" + this.getName() + "': " + e, 6);
            return null;
        }
        clone.breakPoint = new boolean[]{this.breakPoint[0], this.breakPoint[1], this.breakPoint[2]};
        clone.experiment = this.experiment;
        clone.register(this.getExperiment(), name);
        this.getExperiment().registerOperator(name, clone);
        clone.inputContainer = this.inputContainer;
        clone.applyCount = this.applyCount;
        clone.startTime = this.startTime;
        clone.loopStartTime = this.loopStartTime;
        clone.parameters = (Parameters)this.parameters.clone();
        Iterator i = this.valueMap.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            clone.valueMap.put(key, this.valueMap.get(key));
        }
        clone.errorList = this.errorList;
        return clone;
    }

    public abstract IOObject[] apply() throws OperatorException;

    public abstract Class[] getInputClasses();

    public abstract Class[] getOutputClasses();

    protected Class[] getDesiredInputClasses() {
        Class[] inputClasses = this.getInputClasses();
        if (inputClasses == null) {
            return new Class[0];
        }
        return inputClasses;
    }

    protected Class[] getDeliveredOutputClasses() {
        LinkedList<Class> result = new LinkedList<Class>();
        Class[] inputClasses = this.getDesiredInputClasses();
        for (int i = 0; i < inputClasses.length; ++i) {
            InputDescription description = this.getInputDescription(inputClasses[i]);
            if ((!description.showParameter() || !this.getParameterAsBoolean(description.getParameterName())) && !description.getKeepDefault()) continue;
            result.add(inputClasses[i]);
        }
        Class[] additionalOutput = this.getOutputClasses();
        if (additionalOutput != null) {
            for (int i = 0; i < additionalOutput.length; ++i) {
                result.add(additionalOutput[i]);
            }
        }
        Class[] resultArray = new Class[result.size()];
        result.toArray(resultArray);
        return resultArray;
    }

    public InputDescription getInputDescription(Class inputClass) {
        return new InputDescription(inputClass);
    }

    public int getNumberOfSteps() {
        return 1;
    }

    private IODescription getIODescription() {
        return new IODescription(this.getDesiredInputClasses(), this.getDeliveredOutputClasses());
    }

    public Class[] checkIO(Class[] input) throws IllegalInputException {
        if (this.isEnabled()) {
            return this.getIODescription().getOutputClasses(input, this);
        }
        return input;
    }

    public int checkProperties() {
        int errorCount = 0;
        if (this.isEnabled()) {
            Iterator i = this.getParameterTypes().iterator();
            while (i.hasNext()) {
                ParameterType type = (ParameterType)i.next();
                Object value = this.getParameters().getParameter(type.getKey());
                if (type.isOptional() || type.getDefaultValue() != null || value != null) continue;
                this.addError(this.getName() + ": " + type.getKey() + " is not defined!");
                ++errorCount;
            }
        }
        return errorCount;
    }

    public int checkDeprecations() {
        String deprecationString = this.getDeprecationInfo();
        int deprecationCount = 0;
        if (deprecationString != null) {
            this.addWarning(deprecationString);
            deprecationCount = 1;
        }
        return deprecationCount;
    }

    private void stop() throws ExperimentStoppedException {
        LogService.logMessage("$bExperiment stopped.^b", 8);
        throw new ExperimentStoppedException(this);
    }

    public final synchronized IOContainer apply(IOContainer input) throws OperatorException {
        if (this.experiment == null) {
            throw new RuntimeException("Experiment of operator " + this + " is null, probably not registered!");
        }
        if (this.getDeprecationInfo() != null) {
            LogService.logMessage(this.getDeprecationInfo(), 4);
        }
        if (this.isEnabled()) {
            IOObject[] ioo;
            if (this.experiment.shouldStop()) {
                this.stop();
            }
            this.experiment.setCurrentOperator(this);
            ++this.applyCount;
            this.startTime = this.loopStartTime = System.currentTimeMillis();
            if (input == null) {
                throw new IllegalArgumentException("Input is null!");
            }
            this.inputContainer = input;
            if (this.parent != null) {
                this.parent.countStep();
            }
            if (this.breakPoint[0]) {
                this.processBreakpoint(this.inputContainer, 0);
            }
            if ((ioo = this.inputContainer.getIOObjects()).length == 0) {
                LogService.logMessage("$b" + this.getName() + " called^b " + Tools.ordinalNumber(this.applyCount) + " time without input", 1);
            } else {
                String iLog = "$b" + this.getName() + " called^b " + Tools.ordinalNumber(this.applyCount) + " time with input:";
                for (int i = 0; i < ioo.length; ++i) {
                    iLog = iLog + "\n  " + (i + 1) + ". " + ioo[i];
                }
                LogService.logMessage(iLog, 1);
            }
            this.initApply();
            IOObject[] output = this.apply();
            if (output.length == 0) {
                LogService.logMessage(this.getName() + " returned no additional output", 1);
            } else {
                String oLog = this.getName() + " returned additional output:";
                for (int i = 0; i < output.length; ++i) {
                    oLog = oLog + "\n  " + (i + 1) + ". " + output[i];
                }
                LogService.logMessage(oLog, 1);
            }
            LogService.logMessage(this.getName() + ": execution time was " + (System.currentTimeMillis() - this.startTime) + " ms", 0);
            IOContainer outputContainer = this.handleAdditionalOutput(this.inputContainer, output);
            if (this.breakPoint[2]) {
                this.processBreakpoint(outputContainer, 2);
            }
            return outputContainer;
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resume() {
        if (this.breakpointThread != null) {
            Thread thread = this.breakpointThread;
            synchronized (thread) {
                this.breakpointThread.notify();
            }
            this.experiment.fireResumeEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBreakpoint(IOContainer container, int breakpointType) throws ExperimentStoppedException {
        LogService.logMessage("$b" + this.getName() + "^b: Breakpoint reached", 8);
        this.breakpointThread = Thread.currentThread();
        try {
            this.experiment.fireBreakpointEvent(this, container, breakpointType);
            Thread thread = this.breakpointThread;
            synchronized (thread) {
                this.breakpointThread.wait();
            }
            this.experiment.fireResumeEvent();
            if (this.experiment.shouldStop()) {
                this.stop();
            }
        }
        catch (InterruptedException e) {
            LogService.logException("While waiting after breakpoint", e);
        }
    }

    protected IOContainer handleAdditionalOutput(IOContainer container, IOObject[] additional) {
        return this.inputContainer.prepend(additional);
    }

    protected IOObject getInput(Class cls) throws MissingIOObjectException {
        return this.getInput(cls, 0);
    }

    protected IOObject getInput(Class cls, int nr) throws MissingIOObjectException {
        InputDescription description = this.getInputDescription(cls);
        if (description.showParameter()) {
            if (this.getParameterAsBoolean(description.getParameterName())) {
                return this.inputContainer.get(cls, nr);
            }
            return this.inputContainer.remove(cls, nr);
        }
        if (description.getKeepDefault()) {
            return this.inputContainer.get(cls, nr);
        }
        return this.inputContainer.remove(cls, nr);
    }

    protected boolean hasInput(Class cls) {
        return this.inputContainer.contains(cls);
    }

    public IOContainer getInput() {
        return this.inputContainer;
    }

    protected void setInput(IOContainer input) {
        if (input == null) {
            throw new IllegalArgumentException("Input is null!");
        }
        this.inputContainer = input;
    }

    public void initApply() throws OperatorException {
    }

    public void experimentStarts() {
        this.applyCount = 0;
    }

    public void experimentFinished() {
    }

    public void setBreakpoint(int position, boolean on) {
        this.breakPoint[position] = on;
    }

    public boolean hasBreakpoint(int position) {
        return this.breakPoint[position];
    }

    public void inApplyLoop() throws ExperimentStoppedException {
        if (this.breakPoint[1]) {
            this.processBreakpoint(this.getIOContainerForInApplyLoopBreakpoint(), 1);
        }
        this.loopStartTime = System.currentTimeMillis();
    }

    protected IOContainer getIOContainerForInApplyLoopBreakpoint() {
        return IOContainer.DUMMY_IO_CONTAINER;
    }

    public void addValue(Value value) {
        this.valueMap.put(value.getKey(), value);
    }

    public final double getValue(String key) {
        Value value = (Value)this.valueMap.get(key);
        if (value != null) {
            return value.getValue();
        }
        LogService.logMessage(this.getName() + ": Illegal value requested: " + key, 4);
        return Double.NaN;
    }

    public Collection getValues() {
        return this.valueMap.values();
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public Object getParameter(String key) {
        return this.parameters.getParameter(key);
    }

    public boolean isParameterSet(String key) {
        return this.getParameter(key) != null;
    }

    public String getParameterAsString(String key) {
        return this.expandString((String)this.getParameter(key));
    }

    public int getParameterAsInt(String key) {
        return (Integer)this.getParameter(key);
    }

    public double getParameterAsDouble(String key) {
        return (Double)this.getParameter(key);
    }

    public boolean getParameterAsBoolean(String key) {
        return (Boolean)this.getParameter(key);
    }

    public List getParameterList(String key) {
        return (List)this.getParameter(key);
    }

    public Color getParameterAsColor(String key) {
        return ParameterTypeColor.string2Color((String)this.getParameter(key));
    }

    public File getParameterAsFile(String key) {
        String fileName = this.getParameterAsString(key);
        if (fileName == null) {
            return null;
        }
        if (this.getExperiment() != null) {
            return this.getExperiment().resolveFileName(fileName);
        }
        return new File(fileName);
    }

    private String expandString(String str) {
        if (str == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int start = 0;
        int end = 0;
        while ((end = str.indexOf(37, start)) >= 0) {
            result.append(str.substring(start, end));
            int skip = 2;
            if (end + 1 < str.length()) {
                switch (str.charAt(end + 1)) {
                    case 'n': {
                        result.append(this.getName());
                        break;
                    }
                    case 'c': {
                        result.append(this.getClass().getName());
                        break;
                    }
                    case 'a': {
                        result.append(this.applyCount);
                        break;
                    }
                    case 'b': {
                        result.append(this.applyCount + 1);
                        break;
                    }
                    case 'p': {
                        int openNumberIndex = str.indexOf(91, end + 2);
                        if (openNumberIndex < 0) {
                            throw new RuntimeException("A number in [] must follow $p, for example $p[10].");
                        }
                        int closeNumberIndex = str.indexOf(93, end + 2);
                        if (closeNumberIndex < 0) {
                            throw new RuntimeException("A number in [] must follow $p, for example $p[10].");
                        }
                        if (closeNumberIndex <= openNumberIndex + 1) {
                            throw new RuntimeException("A number in [] must follow $p, for example $p[10].");
                        }
                        String numberString = str.substring(openNumberIndex + 1, closeNumberIndex);
                        int number = Integer.parseInt(numberString);
                        result.append(this.applyCount + number);
                        skip = 4 + numberString.length();
                        break;
                    }
                    case 't': {
                        result.append(DateFormat.getDateTimeInstance().format(new Date()));
                        break;
                    }
                    case '%': {
                        result.append('%');
                        break;
                    }
                    default: {
                        result.append(str.charAt(end + 1));
                    }
                }
            }
            start = end + skip;
        }
        result.append(str.substring(start));
        return result.toString();
    }

    public List getParameterTypes() {
        ArrayList<ParameterTypeBoolean> types = new ArrayList<ParameterTypeBoolean>();
        Class[] inputClasses = this.getDesiredInputClasses();
        for (int i = 0; i < inputClasses.length; ++i) {
            InputDescription description = this.getInputDescription(inputClasses[i]);
            if (!description.showParameter()) continue;
            types.add(new ParameterTypeBoolean(description.getParameterName(), "Indicates if this input object should also be returned as output.", description.getKeepDefault()));
        }
        return types;
    }

    public void writeXML(PrintWriter out, String indent) throws IOException {
        out.println(this.getXML(indent));
    }

    public String getXML(String indent) {
        StringBuffer result = new StringBuffer();
        String breakpointString = "";
        StringBuffer breakpointBuf = null;
        boolean firstBreakpoint = true;
        for (int i = 0; i < BreakpointListener.BREAKPOINT_POS_NAME.length; ++i) {
            if (!this.breakPoint[i]) continue;
            if (firstBreakpoint) {
                breakpointBuf = new StringBuffer(" breakpoints=\"");
                firstBreakpoint = false;
            } else {
                breakpointBuf.append(",");
            }
            breakpointBuf.append(BreakpointListener.BREAKPOINT_POS_NAME[i]);
        }
        if (breakpointBuf != null) {
            breakpointBuf.append("\"");
            breakpointString = breakpointBuf.toString();
        }
        result.append(indent + "<operator " + "name=\"" + this.name + "\" " + "class=\"" + this.operatorDescription.getName() + "\"" + breakpointString + (!this.enabled ? " activated=\"no\"" : "") + ">\n");
        if (this.userDescription != null && this.userDescription.length() != 0) {
            result.append(indent + "  <description text=\"" + this.userDescription + "\"/>\n");
        }
        result.append(this.parameters.getXML(indent + "  "));
        result.append(this.getInnerOperatorsXML(indent + "  "));
        result.append(indent + "</operator>\n");
        return result.toString();
    }

    protected String getInnerOperatorsXML(String indent) {
        return "";
    }

    private static String createDescriptionFromXML(Element element) throws XMLException {
        Attr textAttr = element.getAttributeNode("text");
        if (textAttr == null) {
            throw new XMLException("Attribute 'text' of <description> tag is not set.");
        }
        if (element.getChildNodes().getLength() > 0) {
            throw new XMLException("No inner tags allowed for <description>");
        }
        return textAttr.getValue();
    }

    private static Object[] createParameterFromXML(Element element) throws XMLException {
        Attr keyAttr = element.getAttributeNode("key");
        Attr valueAttr = element.getAttributeNode("value");
        if (keyAttr == null) {
            throw new XMLException("Attribute 'key' of <parameter> tag is not set.");
        }
        if (valueAttr == null) {
            throw new XMLException("Attribute 'value' of <parameter> tag is not set.");
        }
        if (element.getChildNodes().getLength() > 0) {
            throw new XMLException("No inner tags allowed for <parameter>");
        }
        return new Object[]{keyAttr.getValue(), valueAttr.getValue()};
    }

    private static Object[] createParameterListFromXML(Element element) throws XMLException {
        LinkedList<Object[]> values = new LinkedList<Object[]>();
        Attr keyAttr = element.getAttributeNode("key");
        if (keyAttr == null) {
            throw new XMLException("Attribute 'key' of <list> tag is not set.");
        }
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (!(node instanceof Element)) continue;
            Element inner = (Element)node;
            if (inner.getTagName().toLowerCase().equals("parameter")) {
                values.add(Operator.createParameterFromXML(inner));
                continue;
            }
            if (inner.getTagName().toLowerCase().equals("list")) {
                values.add(Operator.createParameterListFromXML(inner));
                continue;
            }
            throw new XMLException("Ilegal inner tag for <list>: " + inner.getTagName());
        }
        return new Object[]{keyAttr.getValue(), values};
    }

    public static Operator createFromXML(Element element, Experiment experiment) throws XMLException {
        int i;
        OperatorDescription opDescr;
        Attr activationAttr;
        if (!element.getTagName().toLowerCase().equals("operator")) {
            throw new XMLException("<operator> expected!");
        }
        String className = null;
        Object subTypeName = null;
        String name = null;
        String breakpointString = null;
        String activationString = null;
        Attr classAttr = element.getAttributeNode("class");
        if (classAttr == null) {
            throw new XMLException("Attribute 'class' of <operator> tag is not defined! ");
        }
        className = classAttr.getValue();
        Attr nameAttr = element.getAttributeNode("name");
        if (nameAttr == null) {
            throw new XMLException("Attribute 'name' of <operator> tag is not defined! ");
        }
        name = nameAttr.getValue();
        Attr breakpointAttr = element.getAttributeNode("breakpoints");
        if (breakpointAttr != null) {
            breakpointString = breakpointAttr.getValue();
        }
        if ((activationAttr = element.getAttributeNode("activated")) != null) {
            activationString = activationAttr.getValue();
        }
        if ((opDescr = OperatorService.getOperatorDescription(className)) == null) {
            throw new XMLException("Unknown operator class: '" + className + "'!");
        }
        Operator operator = null;
        try {
            operator = opDescr.createOperatorInstance();
        }
        catch (OperatorCreationException e) {
            throw new XMLException("Cannot create operator: " + e.getMessage(), e);
        }
        if (breakpointString != null) {
            boolean ok = false;
            if (breakpointString.equals("both")) {
                operator.setBreakpoint(0, true);
                operator.setBreakpoint(2, true);
                ok = true;
            }
            for (i = 0; i < BreakpointListener.BREAKPOINT_POS_NAME.length; ++i) {
                if (breakpointString.indexOf(BreakpointListener.BREAKPOINT_POS_NAME[i]) < 0) continue;
                operator.setBreakpoint(i, true);
                ok = true;
            }
            if (!ok) {
                throw new XMLException("Breakpoint `" + breakpointString + "` is not defined!");
            }
        }
        if (activationString != null) {
            if (activationString.equals("no")) {
                operator.setEnabled(false);
            } else if (activationString.equals("yes")) {
                operator.setEnabled(true);
            } else {
                throw new XMLException("Activation mode `" + activationString + "` is not defined!");
            }
        }
        operator.register(experiment, name);
        NodeList innerTags = element.getChildNodes();
        for (i = 0; i < innerTags.getLength(); ++i) {
            Object[] parameter;
            Node node = innerTags.item(i);
            if (!(node instanceof Element)) continue;
            Element inner = (Element)node;
            if (inner.getTagName().toLowerCase().equals("parameter")) {
                parameter = Operator.createParameterFromXML(inner);
                operator.getParameters().setParameter((String)parameter[0], parameter[1]);
                continue;
            }
            if (inner.getTagName().toLowerCase().equals("list")) {
                parameter = Operator.createParameterListFromXML(inner);
                operator.getParameters().setParameter((String)parameter[0], parameter[1]);
                continue;
            }
            if (inner.getTagName().toLowerCase().equals("operator")) {
                if (operator instanceof OperatorChain) {
                    ((OperatorChain)operator).addOperator(Operator.createFromXML(inner, experiment));
                    continue;
                }
                throw new XMLException("No inner operators allowed for '" + className + "'");
            }
            if (inner.getTagName().toLowerCase().equals("description")) {
                String description = Operator.createDescriptionFromXML(inner);
                operator.setUserDescription(description);
                continue;
            }
            throw new XMLException("Ilegal inner tag for <operator>: " + inner.getTagName());
        }
        if (operator instanceof OperatorChain) {
            OperatorChain chain = (OperatorChain)operator;
            if (chain.getNumberOfOperators() < chain.getMinNumberOfInnerOperators()) {
                LogService.logMessage("Less than " + chain.getMinNumberOfInnerOperators() + " inner operators for " + chain.getName() + "!", 4);
            }
            if (chain.getNumberOfOperators() > chain.getMaxNumberOfInnerOperators()) {
                LogService.logMessage("More than " + chain.getMaxNumberOfInnerOperators() + " inner operators for " + chain.getName() + "!", 4);
            }
        }
        return operator;
    }

    public void clearErrorList() {
        this.errorList.clear();
    }

    public void addError(String message) {
        LogService.logMessage(this.getName() + ": " + message, 6);
        this.errorList.add(message);
    }

    public void addWarning(String message) {
        LogService.logMessage(this.getName() + ": " + message, 4);
        this.errorList.add(message);
    }

    public List getErrorList() {
        return this.errorList;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void logMessage(String message, int verbosityLevel) {
        LogService.logMessage(this.getName() + ": " + message, verbosityLevel);
    }

    public String toString() {
        String type = null;
        type = this.getOperatorDescription() != null ? this.getOperatorClassName() : this.getClass().getName();
        return (this.breakPoint[0] || this.breakPoint[1] ? "* " : "") + this.name + " (" + type + ")";
    }

    public String createExperimentTree(int indent) {
        return this.createExperimentTree(this.indent(indent), "", "", null, null);
    }

    public String createMarkedExperimentTree(int indent, String mark, Operator operator) {
        mark = mark + " ";
        indent = Math.max(indent, mark.length());
        return this.createExperimentTree(this.indent(indent), "", "", operator, this.indent(indent - mark.length()) + mark);
    }

    public String createExperimentTree(String indent, String selfPrefix, String childPrefix, Operator markOperator, String mark) {
        if (markOperator != null && this.getName().equals(markOperator.getName())) {
            return mark + selfPrefix + this.getName() + "[" + this.applyCount + "]" + " (" + this.getOperatorClassName() + ")";
        }
        return indent + selfPrefix + this.getName() + "[" + this.applyCount + "]" + " (" + this.getOperatorClassName() + ")";
    }

    public String indent(int indent) {
        String s = "";
        while (s.length() < indent) {
            s = s + " ";
        }
        return s;
    }
}

