/*
 * Decompiled with CFR 0.152.
 */
package edu.udo.cs.yale.operator;

import edu.udo.cs.yale.operator.IOObject;
import edu.udo.cs.yale.operator.MissingIOObjectException;
import edu.udo.cs.yale.operator.Operator;
import edu.udo.cs.yale.operator.OperatorDescription;
import edu.udo.cs.yale.operator.OperatorException;
import edu.udo.cs.yale.operator.parameter.ParameterTypeCategory;
import edu.udo.cs.yale.operator.parameter.ParameterTypeInt;
import edu.udo.cs.yale.operator.parameter.ParameterTypeSingle;
import edu.udo.cs.yale.tools.OperatorService;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class IOMultiplyOperator
extends Operator {
    private static final String[] MULTIPLY_TYPES = new String[]{"multiply_one", "multiply_all"};
    private static final int MULTIPLY_ONE = 0;
    private static final int MULTIPLY_ALL = 1;
    private String[] objectArray = null;

    public IOMultiplyOperator(OperatorDescription description) {
        super(description);
    }

    private Class getSelectedClass() {
        int ioType = this.getParameterAsInt("io_object");
        if (this.objectArray != null) {
            return OperatorService.getIOObjectClass(this.objectArray[ioType]);
        }
        return null;
    }

    public IOObject[] apply() throws OperatorException {
        LinkedList result = new LinkedList();
        Class clazz = this.getSelectedClass();
        int numberOfCopies = this.getParameterAsInt("number_of_copies");
        if (clazz != null) {
            switch (this.getParameterAsInt("multiply_type")) {
                case 0: {
                    int number = this.getParameterAsInt("multiply_which");
                    IOObject ioObject = this.getInput(clazz, number - 1);
                    this.addCopies(result, ioObject, numberOfCopies);
                    break;
                }
                case 1: {
                    try {
                        while (true) {
                            IOObject ioObject = this.getInput(clazz);
                            this.addCopies(result, ioObject, numberOfCopies);
                        }
                    }
                    catch (MissingIOObjectException e) {
                        // empty catch block
                    }
                }
            }
        }
        IOObject[] resultArray = new IOObject[result.size()];
        result.toArray(resultArray);
        return resultArray;
    }

    private void addCopies(List result, IOObject ioObject, int numberOfCopies) {
        result.add(ioObject);
        for (int i = 0; i < numberOfCopies; ++i) {
            result.add(ioObject.copy());
        }
    }

    public Class[] getInputClasses() {
        Class clazz = null;
        try {
            clazz = this.getSelectedClass();
        }
        catch (NullPointerException e) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (clazz != null) {
            return new Class[]{clazz};
        }
        return new Class[0];
    }

    public Class[] getOutputClasses() {
        return this.getInputClasses();
    }

    public List getParameterTypes() {
        List types = super.getParameterTypes();
        Set ioObjects = OperatorService.getIOObjectsNames();
        this.objectArray = new String[ioObjects.size()];
        Iterator i = ioObjects.iterator();
        int index = 0;
        while (i.hasNext()) {
            this.objectArray[index++] = (String)i.next();
        }
        ParameterTypeSingle type = new ParameterTypeInt("number_of_copies", "The number of copies which should be created.", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory("io_object", "The class of the object(s) which should be multiplied.", this.objectArray, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeCategory("multiply_type", "Defines the type of multiplying.", MULTIPLY_TYPES, 0);
        type.setExpert(false);
        types.add(type);
        type = new ParameterTypeInt("multiply_which", "Defines which input object should be multiplied (only used for deletion type 'multiply_one').", 1, Integer.MAX_VALUE, 1);
        type.setExpert(false);
        types.add(type);
        return types;
    }
}

